/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.kyber;

import org.bouncycastle.pqc.crypto.crystals.kyber.KyberEngine;
import org.bouncycastle.pqc.crypto.crystals.kyber.Poly;
import org.bouncycastle.util.Arrays;

class PolyVec {
    Poly[] vec;
    private KyberEngine engine;
    private int kyberK;
    private int polyVecBytes;

    public PolyVec(KyberEngine engine) {
        this.engine = engine;
        this.kyberK = engine.getKyberK();
        this.polyVecBytes = engine.getKyberPolyVecBytes();
        this.vec = new Poly[this.kyberK];
        for (int i = 0; i < this.kyberK; ++i) {
            this.vec[i] = new Poly(engine);
        }
    }

    public PolyVec() throws Exception {
        throw new Exception("Requires Parameter");
    }

    public Poly getVectorIndex(int i) {
        return this.vec[i];
    }

    public void polyVecNtt() {
        for (int i = 0; i < this.kyberK; ++i) {
            this.getVectorIndex(i).polyNtt();
        }
    }

    public void polyVecInverseNttToMont() {
        for (int i = 0; i < this.kyberK; ++i) {
            this.getVectorIndex(i).polyInverseNttToMont();
        }
    }

    public byte[] compressPolyVec() {
        this.conditionalSubQ();
        byte[] r = new byte[this.engine.getKyberPolyVecCompressedBytes()];
        int count = 0;
        if (this.engine.getKyberPolyVecCompressedBytes() == this.kyberK * 320) {
            short[] t = new short[4];
            for (int i = 0; i < this.kyberK; ++i) {
                for (int j = 0; j < 64; ++j) {
                    for (int k = 0; k < 4; ++k) {
                        t[k] = (short)(((this.getVectorIndex(i).getCoeffIndex(4 * j + k) << 10) + 1664) / 3329 & 0x3FF);
                    }
                    r[count + 0] = (byte)(t[0] >> 0);
                    r[count + 1] = (byte)(t[0] >> 8 | t[1] << 2);
                    r[count + 2] = (byte)(t[1] >> 6 | t[2] << 4);
                    r[count + 3] = (byte)(t[2] >> 4 | t[3] << 6);
                    r[count + 4] = (byte)(t[3] >> 2);
                    count += 5;
                }
            }
        } else if (this.engine.getKyberPolyVecCompressedBytes() == this.kyberK * 352) {
            short[] t = new short[8];
            for (int i = 0; i < this.kyberK; ++i) {
                for (int j = 0; j < 32; ++j) {
                    for (int k = 0; k < 8; ++k) {
                        t[k] = (short)(((this.getVectorIndex(i).getCoeffIndex(8 * j + k) << 11) + 1664) / 3329 & 0x7FF);
                    }
                    r[count + 0] = (byte)(t[0] >> 0);
                    r[count + 1] = (byte)(t[0] >> 8 | t[1] << 3);
                    r[count + 2] = (byte)(t[1] >> 5 | t[2] << 6);
                    r[count + 3] = (byte)(t[2] >> 2);
                    r[count + 4] = (byte)(t[2] >> 10 | t[3] << 1);
                    r[count + 5] = (byte)(t[3] >> 7 | t[4] << 4);
                    r[count + 6] = (byte)(t[4] >> 4 | t[5] << 7);
                    r[count + 7] = (byte)(t[5] >> 1);
                    r[count + 8] = (byte)(t[5] >> 9 | t[6] << 2);
                    r[count + 9] = (byte)(t[6] >> 6 | t[7] << 5);
                    r[count + 10] = (byte)(t[7] >> 3);
                    count += 11;
                }
            }
        } else {
            throw new RuntimeException("Kyber PolyVecCompressedBytes neither 320 * KyberK or 352 * KyberK!");
        }
        return r;
    }

    public void decompressPolyVec(byte[] compressedPolyVecCipherText) {
        int count = 0;
        if (this.engine.getKyberPolyVecCompressedBytes() == this.kyberK * 320) {
            short[] t = new short[4];
            for (int i = 0; i < this.kyberK; ++i) {
                for (int j = 0; j < 64; ++j) {
                    t[0] = (short)((compressedPolyVecCipherText[count] & 0xFF) >> 0 | (short)((compressedPolyVecCipherText[count + 1] & 0xFF) << 8));
                    t[1] = (short)((compressedPolyVecCipherText[count + 1] & 0xFF) >> 2 | (short)((compressedPolyVecCipherText[count + 2] & 0xFF) << 6));
                    t[2] = (short)((compressedPolyVecCipherText[count + 2] & 0xFF) >> 4 | (short)((compressedPolyVecCipherText[count + 3] & 0xFF) << 4));
                    t[3] = (short)((compressedPolyVecCipherText[count + 3] & 0xFF) >> 6 | (short)((compressedPolyVecCipherText[count + 4] & 0xFF) << 2));
                    count += 5;
                    for (int k = 0; k < 4; ++k) {
                        this.vec[i].setCoeffIndex(4 * j + k, (short)((t[k] & 0x3FF) * 3329 + 512 >> 10));
                    }
                }
            }
        } else if (this.engine.getKyberPolyVecCompressedBytes() == this.kyberK * 352) {
            short[] t = new short[8];
            for (int i = 0; i < this.kyberK; ++i) {
                for (int j = 0; j < 32; ++j) {
                    t[0] = (short)((compressedPolyVecCipherText[count] & 0xFF) >> 0 | (short)(compressedPolyVecCipherText[count + 1] & 0xFF) << 8);
                    t[1] = (short)((compressedPolyVecCipherText[count + 1] & 0xFF) >> 3 | (short)(compressedPolyVecCipherText[count + 2] & 0xFF) << 5);
                    t[2] = (short)((compressedPolyVecCipherText[count + 2] & 0xFF) >> 6 | (short)(compressedPolyVecCipherText[count + 3] & 0xFF) << 2 | (short)((compressedPolyVecCipherText[count + 4] & 0xFF) << 10));
                    t[3] = (short)((compressedPolyVecCipherText[count + 4] & 0xFF) >> 1 | (short)(compressedPolyVecCipherText[count + 5] & 0xFF) << 7);
                    t[4] = (short)((compressedPolyVecCipherText[count + 5] & 0xFF) >> 4 | (short)(compressedPolyVecCipherText[count + 6] & 0xFF) << 4);
                    t[5] = (short)((compressedPolyVecCipherText[count + 6] & 0xFF) >> 7 | (short)(compressedPolyVecCipherText[count + 7] & 0xFF) << 1 | (short)((compressedPolyVecCipherText[count + 8] & 0xFF) << 9));
                    t[6] = (short)((compressedPolyVecCipherText[count + 8] & 0xFF) >> 2 | (short)(compressedPolyVecCipherText[count + 9] & 0xFF) << 6);
                    t[7] = (short)((compressedPolyVecCipherText[count + 9] & 0xFF) >> 5 | (short)(compressedPolyVecCipherText[count + 10] & 0xFF) << 3);
                    count += 11;
                    for (int k = 0; k < 8; ++k) {
                        this.vec[i].setCoeffIndex(8 * j + k, (short)((t[k] & 0x7FF) * 3329 + 1024 >> 11));
                    }
                }
            }
        } else {
            throw new RuntimeException("Kyber PolyVecCompressedBytes neither 320 * KyberK or 352 * KyberK!");
        }
    }

    public static void pointwiseAccountMontgomery(Poly out, PolyVec inp1, PolyVec inp2, KyberEngine engine) {
        Poly t = new Poly(engine);
        Poly.baseMultMontgomery(out, inp1.getVectorIndex(0), inp2.getVectorIndex(0));
        for (int i = 1; i < engine.getKyberK(); ++i) {
            Poly.baseMultMontgomery(t, inp1.getVectorIndex(i), inp2.getVectorIndex(i));
            out.addCoeffs(t);
        }
        out.reduce();
    }

    public void reducePoly() {
        for (int i = 0; i < this.kyberK; ++i) {
            this.getVectorIndex(i).reduce();
        }
    }

    public void addPoly(PolyVec b) {
        for (int i = 0; i < this.kyberK; ++i) {
            this.getVectorIndex(i).addCoeffs(b.getVectorIndex(i));
        }
    }

    public byte[] toBytes() {
        byte[] r = new byte[this.polyVecBytes];
        for (int i = 0; i < this.kyberK; ++i) {
            System.arraycopy(this.vec[i].toBytes(), 0, r, i * 384, 384);
        }
        return r;
    }

    public void fromBytes(byte[] inputBytes) {
        for (int i = 0; i < this.kyberK; ++i) {
            this.getVectorIndex(i).fromBytes(Arrays.copyOfRange(inputBytes, i * 384, (i + 1) * 384));
        }
    }

    public void conditionalSubQ() {
        for (int i = 0; i < this.kyberK; ++i) {
            this.getVectorIndex(i).conditionalSubQ();
        }
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("[");
        for (int i = 0; i < this.kyberK; ++i) {
            out.append(this.vec[i].toString());
            if (i == this.kyberK - 1) continue;
            out.append(", ");
        }
        out.append("]");
        return out.toString();
    }
}

