/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1ApplicationSpecific;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLFactory;
import org.bouncycastle.asn1.DLTaggedObject;
import org.bouncycastle.util.Arrays;

public class DLApplicationSpecific
extends ASN1ApplicationSpecific {
    public DLApplicationSpecific(int tagNo, byte[] contentsOctets) {
        super(new DLTaggedObject(false, 64, tagNo, (ASN1Encodable)new DEROctetString(Arrays.clone(contentsOctets))));
    }

    public DLApplicationSpecific(int tagNo, ASN1Encodable baseEncodable) throws IOException {
        this(true, tagNo, baseEncodable);
    }

    public DLApplicationSpecific(boolean explicit, int tagNo, ASN1Encodable baseEncodable) throws IOException {
        super(new DLTaggedObject(explicit, 64, tagNo, baseEncodable));
    }

    public DLApplicationSpecific(int tagNo, ASN1EncodableVector contentsElements) {
        super(new DLTaggedObject(false, 64, tagNo, (ASN1Encodable)DLFactory.createSequence(contentsElements)));
    }

    DLApplicationSpecific(ASN1TaggedObject taggedObject) {
        super(taggedObject);
    }

    ASN1Primitive toDLObject() {
        return this;
    }
}

