/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.rsa;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PSSParameterSpec;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.pkcs.RSAESOAEPparams;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSParamSpec;
import org.bouncycastle.jcajce.util.MessageDigestUtils;

public abstract class AlgorithmParametersSpi
extends java.security.AlgorithmParametersSpi {
    static /* synthetic */ Class class$java$security$spec$PSSParameterSpec;

    protected boolean isASN1FormatString(String format) {
        return format == null || format.equals("ASN.1");
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (paramSpec == null) {
            throw new NullPointerException("argument to getParameterSpec must not be null");
        }
        return this.localEngineGetParameterSpec(paramSpec);
    }

    protected abstract AlgorithmParameterSpec localEngineGetParameterSpec(Class var1) throws InvalidParameterSpecException;

    public static class PSS
    extends AlgorithmParametersSpi {
        PSSParameterSpec currentSpec;

        protected byte[] engineGetEncoded() throws IOException {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            PSSParameterSpec pssSpec = this.currentSpec;
            RSASSAPSSparams pssP = new RSASSAPSSparams(RSASSAPSSparams.DEFAULT_HASH_ALGORITHM, RSASSAPSSparams.DEFAULT_MASK_GEN_FUNCTION, new ASN1Integer(pssSpec.getSaltLength()), RSASSAPSSparams.DEFAULT_TRAILER_FIELD);
            dOut.writeObject(pssP);
            dOut.close();
            return bOut.toByteArray();
        }

        protected byte[] engineGetEncoded(String format) throws IOException {
            if (format.equalsIgnoreCase("X.509") || format.equalsIgnoreCase("ASN.1")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == (class$java$security$spec$PSSParameterSpec == null ? (class$java$security$spec$PSSParameterSpec = AlgorithmParametersSpi.class$("java.security.spec.PSSParameterSpec")) : class$java$security$spec$PSSParameterSpec) && this.currentSpec != null) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to PSS parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof PSSParameterSpec)) {
                throw new InvalidParameterSpecException("PSSParameterSpec required to initialise an PSS algorithm parameters object");
            }
            this.currentSpec = (PSSParameterSpec)paramSpec;
        }

        protected void engineInit(byte[] params) throws IOException {
            try {
                RSASSAPSSparams pssP = RSASSAPSSparams.getInstance(params);
                String hashName = MessageDigestUtils.getDigestName(pssP.getHashAlgorithm().getAlgorithm());
                this.currentSpec = new PSSParamSpec(pssP.getSaltLength().intValue(), hashName);
            }
            catch (ClassCastException e) {
                throw new IOException("Not a valid PSS Parameter encoding.");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Not a valid PSS Parameter encoding.");
            }
        }

        protected void engineInit(byte[] params, String format) throws IOException {
            if (!this.isASN1FormatString(format) && !format.equalsIgnoreCase("X.509")) {
                throw new IOException("Unknown parameter format " + format);
            }
            this.engineInit(params);
        }

        protected String engineToString() {
            return "PSS Parameters";
        }
    }

    public static class OAEP
    extends AlgorithmParametersSpi {
        AlgorithmParameterSpec currentSpec;

        protected byte[] engineGetEncoded() {
            return null;
        }

        protected byte[] engineGetEncoded(String format) {
            if (this.isASN1FormatString(format) || format.equalsIgnoreCase("X.509")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            throw new InvalidParameterSpecException("unknown parameter spec passed to OAEP parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            this.currentSpec = paramSpec;
        }

        protected void engineInit(byte[] params) throws IOException {
            try {
                RSAESOAEPparams oaepP = RSAESOAEPparams.getInstance(params);
                throw new IOException("Operation not supported");
            }
            catch (ClassCastException e) {
                throw new IOException("Not a valid OAEP Parameter encoding.");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Not a valid OAEP Parameter encoding.");
            }
        }

        protected void engineInit(byte[] params, String format) throws IOException {
            if (!format.equalsIgnoreCase("X.509") && !format.equalsIgnoreCase("ASN.1")) {
                throw new IOException("Unknown parameter format " + format);
            }
            this.engineInit(params);
        }

        protected String engineToString() {
            return "OAEP Parameters";
        }
    }
}

