/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.cms.MACProvider;
import org.bouncycastle.util.Arrays;

public final class InputStreamWithMAC
extends InputStream {
    private final InputStream base;
    private MACProvider macProvider;
    private byte[] mac;
    private boolean baseFinished;
    private int index;

    InputStreamWithMAC(InputStream base, MACProvider macProvider) {
        this.base = base;
        this.macProvider = macProvider;
        this.baseFinished = false;
        this.index = 0;
    }

    public InputStreamWithMAC(InputStream base, byte[] mac) {
        this.base = base;
        this.mac = mac;
        this.baseFinished = false;
        this.index = 0;
    }

    @Override
    public int read() throws IOException {
        int ch;
        if (!this.baseFinished) {
            ch = this.base.read();
            if (ch < 0) {
                this.baseFinished = true;
                if (this.macProvider != null) {
                    this.macProvider.init();
                    this.mac = this.macProvider.getMAC();
                }
                return this.mac[this.index++] & 0xFF;
            }
        } else {
            if (this.index >= this.mac.length) {
                return -1;
            }
            return this.mac[this.index++] & 0xFF;
        }
        return ch;
    }

    public byte[] getMAC() {
        if (!this.baseFinished) {
            throw new IllegalStateException("input stream not fully processed");
        }
        return Arrays.clone((byte[])this.mac);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("input array is null");
        }
        if (off < 0 || b.length < off + len) {
            throw new IndexOutOfBoundsException("invalid off(" + off + ") and len(" + len + ")");
        }
        if (!this.baseFinished) {
            int ch = this.base.read(b, off, len);
            if (ch < 0) {
                this.baseFinished = true;
                if (this.macProvider != null) {
                    this.macProvider.init();
                    this.mac = this.macProvider.getMAC();
                }
                if (len >= this.mac.length) {
                    System.arraycopy(this.mac, 0, b, off, this.mac.length);
                    this.index = this.mac.length;
                    return this.mac.length;
                }
                System.arraycopy(this.mac, 0, b, off, len);
                this.index += len;
                return len;
            }
            return ch;
        }
        if (this.index < this.mac.length) {
            if (len >= this.mac.length - this.index) {
                System.arraycopy(this.mac, this.index, b, off, this.mac.length - this.index);
                int tmp = this.mac.length - this.index;
                this.index = this.mac.length;
                return tmp;
            }
            System.arraycopy(this.mac, this.index, b, off, len);
            this.index += len;
            return len;
        }
        return -1;
    }
}

