/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.cert.X509CertificateHolder;

public class DeltaCertificateTool {
    public static Extension makeDeltaCertificateExtension(boolean isCritical, X509CertificateHolder deltaCert) throws IOException {
        ASN1EncodableVector deltaV = new ASN1EncodableVector();
        deltaV.add((ASN1Encodable)new ASN1Integer(deltaCert.getSerialNumber()));
        deltaV.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)deltaCert.getSignatureAlgorithm()));
        deltaV.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)deltaCert.getIssuer()));
        ASN1EncodableVector validity = new ASN1EncodableVector(2);
        validity.add((ASN1Encodable)deltaCert.toASN1Structure().getStartDate());
        validity.add((ASN1Encodable)deltaCert.toASN1Structure().getEndDate());
        deltaV.add((ASN1Encodable)new DERTaggedObject(false, 2, (ASN1Encodable)new DERSequence(validity)));
        deltaV.add((ASN1Encodable)new DERTaggedObject(false, 3, (ASN1Encodable)deltaCert.getSubject()));
        deltaV.add((ASN1Encodable)deltaCert.getSubjectPublicKeyInfo());
        if (deltaCert.getExtensions() != null) {
            deltaV.add((ASN1Encodable)new DERTaggedObject(false, 4, (ASN1Encodable)deltaCert.getExtensions()));
        }
        deltaV.add((ASN1Encodable)new DERBitString(deltaCert.getSignature()));
        return new Extension(Extension.deltaCertificateDescriptor, isCritical, new DERSequence(deltaV).getEncoded("DER"));
    }

    public static X509CertificateHolder extractDeltaCertificate(X509CertificateHolder originCert) {
        ASN1ObjectIdentifier deltaExtOid = Extension.deltaCertificateDescriptor;
        Extension deltaExt = originCert.getExtension(deltaExtOid);
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)deltaExt.getParsedValue());
        ASN1Sequence originTbs = ASN1Sequence.getInstance((Object)originCert.toASN1Structure().getTBSCertificate().toASN1Primitive());
        int idx = 0;
        ASN1Encodable[] extracted = originTbs.toArray();
        extracted[0] = originTbs.getObjectAt(0);
        extracted[1] = ASN1Integer.getInstance((Object)seq.getObjectAt(idx++));
        ASN1Encodable next = seq.getObjectAt(idx++);
        while (next instanceof ASN1TaggedObject) {
            ASN1TaggedObject tagged = ASN1TaggedObject.getInstance((Object)next);
            switch (tagged.getTagNo()) {
                case 0: {
                    extracted[2] = ASN1Sequence.getInstance((ASN1TaggedObject)tagged, (boolean)false);
                    break;
                }
                case 1: {
                    extracted[3] = ASN1Sequence.getInstance((ASN1TaggedObject)tagged, (boolean)true);
                    break;
                }
                case 2: {
                    extracted[4] = ASN1Sequence.getInstance((ASN1TaggedObject)tagged, (boolean)false);
                    break;
                }
                case 3: {
                    extracted[5] = ASN1Sequence.getInstance((ASN1TaggedObject)((ASN1TaggedObject)next), (boolean)true);
                }
            }
            next = seq.getObjectAt(idx++);
        }
        extracted[6] = next;
        if (extracted[2] == null) {
            extracted[2] = originTbs.getObjectAt(2);
        }
        if (extracted[3] == null) {
            extracted[3] = originTbs.getObjectAt(3);
        }
        if (extracted[4] == null) {
            extracted[4] = originTbs.getObjectAt(4);
        }
        if (extracted[5] == null) {
            extracted[5] = originTbs.getObjectAt(5);
        }
        ExtensionsGenerator extGen = DeltaCertificateTool.extractExtensions(originTbs);
        if (idx < seq.size() - 1) {
            ASN1TaggedObject tagged;
            if ((tagged = ASN1TaggedObject.getInstance((Object)(next = seq.getObjectAt(idx++)))).getTagNo() != 4) {
                throw new IllegalArgumentException("malformed delta extension");
            }
            ASN1Sequence deltaExts = ASN1Sequence.getInstance((ASN1TaggedObject)tagged, (boolean)false);
            for (int i = 0; i != deltaExts.size(); ++i) {
                Extension ext = Extension.getInstance((Object)deltaExts.getObjectAt(i));
                extGen.replaceExtension(ext);
            }
            extracted[7] = new DERTaggedObject(3, (ASN1Encodable)extGen.generate());
        } else {
            extracted[7] = !extGen.isEmpty() ? new DERTaggedObject(3, (ASN1Encodable)extGen.generate()) : null;
        }
        ASN1EncodableVector tbsDeltaCertV = new ASN1EncodableVector(7);
        for (int i = 0; i != extracted.length; ++i) {
            if (extracted[i] == null) continue;
            tbsDeltaCertV.add(extracted[i]);
        }
        ASN1EncodableVector certV = new ASN1EncodableVector();
        certV.add((ASN1Encodable)new DERSequence(tbsDeltaCertV));
        certV.add((ASN1Encodable)ASN1Sequence.getInstance((Object)extracted[2]));
        certV.add((ASN1Encodable)ASN1BitString.getInstance((Object)seq.getObjectAt(seq.size() - 1)));
        return new X509CertificateHolder(Certificate.getInstance((Object)new DERSequence(certV)));
    }

    private static ExtensionsGenerator extractExtensions(ASN1Sequence originTbs) {
        ASN1ObjectIdentifier deltaExtOid = Extension.deltaCertificateDescriptor;
        ASN1Sequence originExt = ASN1Sequence.getInstance((ASN1TaggedObject)ASN1TaggedObject.getInstance((Object)originTbs.getObjectAt(originTbs.size() - 1)), (boolean)true);
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        for (int i = 0; i != originExt.size(); ++i) {
            Extension ext = Extension.getInstance((Object)originExt.getObjectAt(i));
            if (deltaExtOid.equals((ASN1Primitive)ext.getExtnId())) continue;
            extGen.addExtension(ext);
        }
        return extGen;
    }
}

