/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.cmp;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cmp.Challenge;
import org.bouncycastle.asn1.cmp.POPODecKeyChallContent;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.cmp.CMPException;
import org.bouncycastle.cert.cmp.POPODecryptionKeyChallengeContent;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Arrays;

public class POPODecryptionKeyChallengeContentBuilder {
    private final DigestCalculator owfCalculator;
    private final ASN1ObjectIdentifier challengeEncAlg;
    private ASN1EncodableVector challenges = new ASN1EncodableVector();

    public POPODecryptionKeyChallengeContentBuilder(DigestCalculator owfCalculator, ASN1ObjectIdentifier challengeEncAlg) {
        this.owfCalculator = owfCalculator;
        this.challengeEncAlg = challengeEncAlg;
    }

    public POPODecryptionKeyChallengeContentBuilder addChallenge(RecipientInfoGenerator recipientInfGenerator, GeneralName recipient, byte[] A) throws CMPException {
        CMSEnvelopedData encryptedChallenge;
        byte[] integer = Arrays.clone((byte[])A);
        try {
            OutputStream dOut = this.owfCalculator.getOutputStream();
            dOut.write(new ASN1Integer(integer).getEncoded());
            dOut.close();
        }
        catch (IOException e) {
            throw new CMPException("unable to calculate witness", e);
        }
        try {
            CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
            edGen.addRecipientInfoGenerator(recipientInfGenerator);
            encryptedChallenge = edGen.generate(new CMSProcessableByteArray(new Challenge.Rand(A, recipient).getEncoded()), new JceCMSContentEncryptorBuilder(this.challengeEncAlg).setProvider("BC").build());
        }
        catch (Exception e) {
            throw new CMPException("unable to encrypt challenge", e);
        }
        EnvelopedData encryptedRand = EnvelopedData.getInstance((Object)encryptedChallenge.toASN1Structure().getContent());
        if (this.challenges.size() == 0) {
            this.challenges.add((ASN1Encodable)new Challenge(this.owfCalculator.getAlgorithmIdentifier(), this.owfCalculator.getDigest(), encryptedRand));
        } else {
            this.challenges.add((ASN1Encodable)new Challenge(this.owfCalculator.getDigest(), encryptedRand));
        }
        return this;
    }

    public POPODecryptionKeyChallengeContent build() {
        return new POPODecryptionKeyChallengeContent(POPODecKeyChallContent.getInstance((Object)new DERSequence(this.challenges)), new DigestCalculatorProvider(){

            public DigestCalculator get(AlgorithmIdentifier digestAlgorithmIdentifier) throws OperatorCreationException {
                return POPODecryptionKeyChallengeContentBuilder.this.owfCalculator;
            }
        });
    }
}

