/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedData;

public class PKCS7ProcessableObject
implements CMSTypedData {
    private final ASN1ObjectIdentifier type;
    private final ASN1Encodable structure;

    public PKCS7ProcessableObject(ASN1ObjectIdentifier type, ASN1Encodable structure) {
        this.type = type;
        this.structure = structure;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.type;
    }

    public void write(OutputStream cOut) throws IOException, CMSException {
        if (this.structure instanceof ASN1Sequence) {
            ASN1Sequence s = ASN1Sequence.getInstance((Object)this.structure);
            Iterator it = s.iterator();
            while (it.hasNext()) {
                ASN1Encodable enc = (ASN1Encodable)it.next();
                cOut.write(enc.toASN1Primitive().getEncoded("DER"));
            }
        } else {
            byte[] encoded = this.structure.toASN1Primitive().getEncoded("DER");
            int index = 1;
            while ((encoded[index] & 0xFF) > 127) {
                ++index;
            }
            cOut.write(encoded, ++index, encoded.length - index);
        }
    }

    public Object getContent() {
        return this.structure;
    }
}

