/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.cmp;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CMPObjectIdentifiers;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.cmp.CMPException;
import org.bouncycastle.cert.cmp.CMPUtil;
import org.bouncycastle.cert.cmp.GeneralPKIMessage;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.MacCalculator;
import org.bouncycastle.operator.PBEMacCalculatorProvider;
import org.bouncycastle.util.Arrays;

public class ProtectedPKIMessage {
    private PKIMessage pkiMessage;

    public ProtectedPKIMessage(GeneralPKIMessage pkiMessage) {
        if (!pkiMessage.hasProtection()) {
            throw new IllegalArgumentException("PKIMessage not protected");
        }
        this.pkiMessage = pkiMessage.toASN1Structure();
    }

    ProtectedPKIMessage(PKIMessage pkiMessage) {
        if (pkiMessage.getHeader().getProtectionAlg() == null) {
            throw new IllegalArgumentException("PKIMessage not protected");
        }
        this.pkiMessage = pkiMessage;
    }

    public PKIHeader getHeader() {
        return this.pkiMessage.getHeader();
    }

    public PKIBody getBody() {
        return this.pkiMessage.getBody();
    }

    public PKIMessage toASN1Structure() {
        return this.pkiMessage;
    }

    public boolean hasPasswordBasedMacProtection() {
        return CMPObjectIdentifiers.passwordBasedMac.equals((ASN1Primitive)this.getProtectionAlgorithm().getAlgorithm());
    }

    public AlgorithmIdentifier getProtectionAlgorithm() {
        return this.pkiMessage.getHeader().getProtectionAlg();
    }

    public X509CertificateHolder[] getCertificates() {
        CMPCertificate[] certs = this.pkiMessage.getExtraCerts();
        if (certs == null) {
            return new X509CertificateHolder[0];
        }
        X509CertificateHolder[] res = new X509CertificateHolder[certs.length];
        for (int i = 0; i != certs.length; ++i) {
            res[i] = new X509CertificateHolder(certs[i].getX509v3PKCert());
        }
        return res;
    }

    public boolean verify(ContentVerifierProvider verifierProvider) throws CMPException {
        try {
            ContentVerifier verifier = verifierProvider.get(this.getProtectionAlgorithm());
            return this.verifySignature(this.pkiMessage.getProtection().getOctets(), verifier);
        }
        catch (Exception e) {
            throw new CMPException("unable to verify signature: " + e.getMessage(), e);
        }
    }

    public boolean verify(PBEMacCalculatorProvider pbeMacCalculatorProvider, char[] password) throws CMPException {
        try {
            MacCalculator calculator = pbeMacCalculatorProvider.get(this.getProtectionAlgorithm(), password);
            CMPUtil.derEncodeToStream((ASN1Object)this.createProtected(), calculator.getOutputStream());
            return Arrays.constantTimeAreEqual((byte[])calculator.getMac(), (byte[])this.pkiMessage.getProtection().getOctets());
        }
        catch (Exception e) {
            throw new CMPException("unable to verify MAC: " + e.getMessage(), e);
        }
    }

    private boolean verifySignature(byte[] signature, ContentVerifier verifier) {
        CMPUtil.derEncodeToStream((ASN1Object)this.createProtected(), verifier.getOutputStream());
        return verifier.verify(signature);
    }

    private DERSequence createProtected() {
        return new DERSequence((ASN1Encodable)this.pkiMessage.getHeader(), (ASN1Encodable)this.pkiMessage.getBody());
    }
}

