/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.bcpg.ArmoredInputException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.bcpg.SecretSubkeyPacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Iterable;

public class PGPSecretKeyRing
extends PGPKeyRing
implements Iterable {
    private static final Logger LOG = Logger.getLogger(PGPSecretKeyRing.class.getName());
    List keys;
    List extraPubKeys;

    private static List checkKeys(List list) {
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(list.size());
        for (int i = 0; i != list.size(); ++i) {
            PGPSecretKey pGPSecretKey = (PGPSecretKey)list.get(i);
            if (i == 0) {
                if (!pGPSecretKey.isMasterKey()) {
                    throw new IllegalArgumentException("key 0 must be a master key");
                }
            } else if (pGPSecretKey.isMasterKey()) {
                throw new IllegalArgumentException("key 0 can be only master key");
            }
            arrayList.add(pGPSecretKey);
        }
        return arrayList;
    }

    public PGPSecretKeyRing(List list) {
        this(PGPSecretKeyRing.checkKeys(list), new ArrayList());
    }

    private PGPSecretKeyRing(List list, List list2) {
        this.keys = list;
        this.extraPubKeys = list2;
    }

    public PGPSecretKeyRing(byte[] byArray, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        this(new ByteArrayInputStream(byArray), keyFingerPrintCalculator);
    }

    public PGPSecretKeyRing(InputStream inputStream, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        this.keys = new ArrayList();
        this.extraPubKeys = new ArrayList();
        BCPGInputStream bCPGInputStream = BCPGInputStream.wrap(inputStream);
        int n = bCPGInputStream.skipMarkerAndPaddingPackets();
        if (n != 5 && n != 7) {
            throw new IOException("secret key ring doesn't start with secret key tag: tag 0x" + Integer.toHexString(n));
        }
        SecretKeyPacket secretKeyPacket = (SecretKeyPacket)bCPGInputStream.readPacket();
        while (bCPGInputStream.nextPacketTag() == 61) {
            bCPGInputStream.readPacket();
        }
        TrustPacket trustPacket = PGPSecretKeyRing.readOptionalTrustPacket(bCPGInputStream);
        List list = PGPSecretKeyRing.readSignaturesAndTrust(bCPGInputStream);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        PGPSecretKeyRing.readUserIDs(bCPGInputStream, arrayList, arrayList2, arrayList3);
        this.keys.add(new PGPSecretKey(secretKeyPacket, new PGPPublicKey(secretKeyPacket.getPublicKeyPacket(), trustPacket, list, arrayList, arrayList2, arrayList3, keyFingerPrintCalculator)));
        while (bCPGInputStream.nextPacketTag() == 7 || bCPGInputStream.nextPacketTag() == 14) {
            try {
                List list2;
                TrustPacket trustPacket2;
                ContainedPacket containedPacket;
                if (bCPGInputStream.nextPacketTag() == 7) {
                    containedPacket = (SecretSubkeyPacket)bCPGInputStream.readPacket();
                    while (bCPGInputStream.nextPacketTag() == 61) {
                        bCPGInputStream.readPacket();
                    }
                    trustPacket2 = PGPSecretKeyRing.readOptionalTrustPacket(bCPGInputStream);
                    list2 = PGPSecretKeyRing.readSignaturesAndTrust(bCPGInputStream);
                    this.keys.add(new PGPSecretKey((SecretKeyPacket)containedPacket, new PGPPublicKey(((SecretKeyPacket)containedPacket).getPublicKeyPacket(), trustPacket2, list2, keyFingerPrintCalculator)));
                    continue;
                }
                containedPacket = (PublicSubkeyPacket)bCPGInputStream.readPacket();
                trustPacket2 = PGPSecretKeyRing.readOptionalTrustPacket(bCPGInputStream);
                list2 = PGPSecretKeyRing.readSignaturesAndTrust(bCPGInputStream);
                this.extraPubKeys.add(new PGPPublicKey((PublicKeyPacket)containedPacket, trustPacket2, list2, keyFingerPrintCalculator));
            }
            catch (EOFException eOFException) {
                throw eOFException;
            }
            catch (ArmoredInputException armoredInputException) {
                throw armoredInputException;
            }
            catch (IOException iOException) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("skipping unknown subkey: " + iOException.getMessage());
            }
        }
    }

    public PGPPublicKey getPublicKey() {
        return ((PGPSecretKey)this.keys.get(0)).getPublicKey();
    }

    public PGPPublicKey getPublicKey(long l) {
        PGPSecretKey pGPSecretKey = this.getSecretKey(l);
        if (pGPSecretKey != null) {
            return pGPSecretKey.getPublicKey();
        }
        for (int i = 0; i != this.extraPubKeys.size(); ++i) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.extraPubKeys.get(i);
            if (l != pGPPublicKey.getKeyID()) continue;
            return pGPPublicKey;
        }
        return null;
    }

    public PGPPublicKey getPublicKey(byte[] byArray) {
        PGPSecretKey pGPSecretKey = this.getSecretKey(byArray);
        if (pGPSecretKey != null) {
            return pGPSecretKey.getPublicKey();
        }
        for (int i = 0; i != this.extraPubKeys.size(); ++i) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.extraPubKeys.get(i);
            if (!Arrays.areEqual((byte[])byArray, (byte[])pGPPublicKey.getFingerprint())) continue;
            return pGPPublicKey;
        }
        return null;
    }

    public Iterator getKeysWithSignaturesBy(long l) {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        Iterator iterator = this.getPublicKeys();
        while (iterator.hasNext()) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)iterator.next();
            Iterator iterator2 = pGPPublicKey.getSignaturesForKeyID(l);
            if (!iterator2.hasNext()) continue;
            arrayList.add(pGPPublicKey);
        }
        return arrayList.iterator();
    }

    public Iterator getPublicKeys() {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        Iterator iterator = this.getSecretKeys();
        while (iterator.hasNext()) {
            PGPPublicKey pGPPublicKey = ((PGPSecretKey)iterator.next()).getPublicKey();
            arrayList.add(pGPPublicKey);
        }
        arrayList.addAll(this.extraPubKeys);
        return Collections.unmodifiableList(arrayList).iterator();
    }

    public PGPSecretKey getSecretKey() {
        return (PGPSecretKey)this.keys.get(0);
    }

    public Iterator getSecretKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    public PGPSecretKey getSecretKey(long l) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPSecretKey pGPSecretKey = (PGPSecretKey)this.keys.get(i);
            if (l != pGPSecretKey.getKeyID()) continue;
            return pGPSecretKey;
        }
        return null;
    }

    public PGPSecretKey getSecretKey(byte[] byArray) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPSecretKey pGPSecretKey = (PGPSecretKey)this.keys.get(i);
            if (!Arrays.areEqual((byte[])byArray, (byte[])pGPSecretKey.getPublicKey().getFingerprint())) continue;
            return pGPSecretKey;
        }
        return null;
    }

    public Iterator getExtraPublicKeys() {
        return this.extraPubKeys.iterator();
    }

    public int size() {
        return this.keys.size();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        Object object;
        int n;
        for (n = 0; n != this.keys.size(); ++n) {
            object = (PGPSecretKey)this.keys.get(n);
            ((PGPSecretKey)object).encode(outputStream);
        }
        for (n = 0; n != this.extraPubKeys.size(); ++n) {
            object = (PGPPublicKey)this.extraPubKeys.get(n);
            ((PGPPublicKey)object).encode(outputStream);
        }
    }

    public Iterator iterator() {
        return this.getSecretKeys();
    }

    public static PGPSecretKeyRing replacePublicKeys(PGPSecretKeyRing pGPSecretKeyRing, PGPPublicKeyRing pGPPublicKeyRing) {
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(pGPSecretKeyRing.keys.size());
        Iterator iterator = pGPSecretKeyRing.keys.iterator();
        while (iterator.hasNext()) {
            PGPSecretKey pGPSecretKey = (PGPSecretKey)iterator.next();
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey(pGPSecretKey.getKeyID());
            arrayList.add(PGPSecretKey.replacePublicKey(pGPSecretKey, pGPPublicKey));
        }
        return new PGPSecretKeyRing(arrayList);
    }

    public static PGPSecretKeyRing insertOrReplacePublicKey(PGPSecretKeyRing pGPSecretKeyRing, PGPPublicKey pGPPublicKey) {
        PGPSecretKey pGPSecretKey = pGPSecretKeyRing.getSecretKey(pGPPublicKey.getKeyID());
        if (pGPSecretKey != null) {
            ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(pGPSecretKeyRing.keys.size());
            Iterator iterator = pGPSecretKeyRing.getSecretKeys();
            while (iterator.hasNext()) {
                PGPSecretKey pGPSecretKey2 = (PGPSecretKey)iterator.next();
                if (pGPSecretKey2.getKeyID() != pGPPublicKey.getKeyID()) continue;
                pGPSecretKey2 = PGPSecretKey.replacePublicKey(pGPSecretKey, pGPPublicKey);
                arrayList.add(pGPSecretKey2);
            }
            return new PGPSecretKeyRing(arrayList);
        }
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>(pGPSecretKeyRing.extraPubKeys.size());
        boolean bl = false;
        Iterator iterator = pGPSecretKeyRing.getExtraPublicKeys();
        while (iterator.hasNext()) {
            PGPPublicKey pGPPublicKey2 = (PGPPublicKey)iterator.next();
            if (pGPPublicKey2.getKeyID() == pGPPublicKey.getKeyID()) {
                arrayList.add(pGPPublicKey);
                bl = true;
                continue;
            }
            arrayList.add(pGPPublicKey2);
        }
        if (!bl) {
            arrayList.add(pGPPublicKey);
        }
        return new PGPSecretKeyRing(new ArrayList(pGPSecretKeyRing.keys), arrayList);
    }

    public static PGPSecretKeyRing copyWithNewPassword(PGPSecretKeyRing pGPSecretKeyRing, PBESecretKeyDecryptor pBESecretKeyDecryptor, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(pGPSecretKeyRing.keys.size());
        Iterator iterator = pGPSecretKeyRing.getSecretKeys();
        while (iterator.hasNext()) {
            PGPSecretKey pGPSecretKey = (PGPSecretKey)iterator.next();
            if (pGPSecretKey.isPrivateKeyEmpty()) {
                arrayList.add(pGPSecretKey);
                continue;
            }
            arrayList.add(PGPSecretKey.copyWithNewPassword(pGPSecretKey, pBESecretKeyDecryptor, pBESecretKeyEncryptor));
        }
        return new PGPSecretKeyRing(arrayList, pGPSecretKeyRing.extraPubKeys);
    }

    public static PGPSecretKeyRing insertSecretKey(PGPSecretKeyRing pGPSecretKeyRing, PGPSecretKey pGPSecretKey) {
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(pGPSecretKeyRing.keys);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i != arrayList.size(); ++i) {
            PGPSecretKey pGPSecretKey2 = (PGPSecretKey)arrayList.get(i);
            if (pGPSecretKey2.getKeyID() == pGPSecretKey.getKeyID()) {
                bl = true;
                arrayList.set(i, pGPSecretKey);
            }
            if (!pGPSecretKey2.isMasterKey()) continue;
            bl2 = true;
        }
        if (!bl) {
            if (pGPSecretKey.isMasterKey()) {
                if (bl2) {
                    throw new IllegalArgumentException("cannot add a master key to a ring that already has one");
                }
                arrayList.add(0, pGPSecretKey);
            } else {
                arrayList.add(pGPSecretKey);
            }
        }
        return new PGPSecretKeyRing(arrayList, pGPSecretKeyRing.extraPubKeys);
    }

    public static PGPSecretKeyRing removeSecretKey(PGPSecretKeyRing pGPSecretKeyRing, PGPSecretKey pGPSecretKey) {
        int n = pGPSecretKeyRing.keys.size();
        long l = pGPSecretKey.getKeyID();
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            PGPSecretKey pGPSecretKey2 = (PGPSecretKey)pGPSecretKeyRing.keys.get(i);
            if (pGPSecretKey2.getKeyID() == l) {
                bl = true;
                continue;
            }
            arrayList.add(pGPSecretKey2);
        }
        if (!bl) {
            return null;
        }
        return new PGPSecretKeyRing(arrayList, pGPSecretKeyRing.extraPubKeys);
    }
}

