/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParametersHolder;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserDataPacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.Arrays;

public class PGPPublicKey
implements PublicKeyAlgorithmTags {
    private static final int[] MASTER_KEY_CERTIFICATION_TYPES = new int[]{19, 18, 17, 16, 31};
    PublicKeyPacket publicPk;
    TrustPacket trustPk;
    List keySigs = new ArrayList();
    List ids = new ArrayList();
    List idTrusts = new ArrayList();
    List idSigs = new ArrayList();
    List subSigs = null;
    private long keyID;
    private byte[] fingerprint;
    private int keyStrength;

    private void init(KeyFingerPrintCalculator keyFingerPrintCalculator) throws PGPException {
        RSAPublicBCPGKey rSAPublicBCPGKey;
        BCPGKey bCPGKey = this.publicPk.getKey();
        this.fingerprint = keyFingerPrintCalculator.calculateFingerprint(this.publicPk);
        if (this.publicPk.getVersion() <= 3) {
            rSAPublicBCPGKey = (RSAPublicBCPGKey)bCPGKey;
            this.keyID = rSAPublicBCPGKey.getModulus().longValue();
            this.keyStrength = rSAPublicBCPGKey.getModulus().bitLength();
        } else if (this.publicPk.getVersion() == 4) {
            this.keyID = (long)(this.fingerprint[this.fingerprint.length - 8] & 0xFF) << 56 | (long)(this.fingerprint[this.fingerprint.length - 7] & 0xFF) << 48 | (long)(this.fingerprint[this.fingerprint.length - 6] & 0xFF) << 40 | (long)(this.fingerprint[this.fingerprint.length - 5] & 0xFF) << 32 | (long)(this.fingerprint[this.fingerprint.length - 4] & 0xFF) << 24 | (long)(this.fingerprint[this.fingerprint.length - 3] & 0xFF) << 16 | (long)(this.fingerprint[this.fingerprint.length - 2] & 0xFF) << 8 | (long)(this.fingerprint[this.fingerprint.length - 1] & 0xFF);
        } else if (this.publicPk.getVersion() == 6) {
            this.keyID = (long)(this.fingerprint[0] & 0xFF) << 56 | (long)(this.fingerprint[1] & 0xFF) << 48 | (long)(this.fingerprint[2] & 0xFF) << 40 | (long)(this.fingerprint[3] & 0xFF) << 32 | (long)(this.fingerprint[4] & 0xFF) << 24 | (long)(this.fingerprint[5] & 0xFF) << 16 | (long)(this.fingerprint[6] & 0xFF) << 8 | (long)(this.fingerprint[7] & 0xFF);
        }
        if (this.publicPk.getVersion() >= 4) {
            if (bCPGKey instanceof RSAPublicBCPGKey) {
                this.keyStrength = ((RSAPublicBCPGKey)bCPGKey).getModulus().bitLength();
            } else if (bCPGKey instanceof DSAPublicBCPGKey) {
                this.keyStrength = ((DSAPublicBCPGKey)bCPGKey).getP().bitLength();
            } else if (bCPGKey instanceof ElGamalPublicBCPGKey) {
                this.keyStrength = ((ElGamalPublicBCPGKey)bCPGKey).getP().bitLength();
            } else if (bCPGKey instanceof ECPublicBCPGKey) {
                X9ECParametersHolder x9ECParametersHolder;
                rSAPublicBCPGKey = ((ECPublicBCPGKey)bCPGKey).getCurveOID();
                this.keyStrength = rSAPublicBCPGKey.equals((ASN1Primitive)GNUObjectIdentifiers.Ed25519) || rSAPublicBCPGKey.equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519) ? 256 : ((x9ECParametersHolder = ECNamedCurveTable.getByOIDLazy((ASN1ObjectIdentifier)rSAPublicBCPGKey)) != null ? x9ECParametersHolder.getCurve().getFieldSize() : -1);
            }
        }
    }

    public PGPPublicKey(PublicKeyPacket publicKeyPacket, KeyFingerPrintCalculator keyFingerPrintCalculator) throws PGPException {
        this.publicPk = publicKeyPacket;
        this.ids = new ArrayList();
        this.idSigs = new ArrayList();
        this.init(keyFingerPrintCalculator);
    }

    PGPPublicKey(PublicKeyPacket publicKeyPacket, TrustPacket trustPacket, List list, KeyFingerPrintCalculator keyFingerPrintCalculator) throws PGPException {
        this.publicPk = publicKeyPacket;
        this.trustPk = trustPacket;
        this.subSigs = list;
        this.init(keyFingerPrintCalculator);
    }

    PGPPublicKey(PGPPublicKey pGPPublicKey, TrustPacket trustPacket, List list) {
        this.publicPk = pGPPublicKey.publicPk;
        this.trustPk = trustPacket;
        this.subSigs = list;
        this.fingerprint = pGPPublicKey.fingerprint;
        this.keyID = pGPPublicKey.keyID;
        this.keyStrength = pGPPublicKey.keyStrength;
    }

    PGPPublicKey(PGPPublicKey pGPPublicKey) {
        this.publicPk = pGPPublicKey.publicPk;
        this.keySigs = new ArrayList(pGPPublicKey.keySigs);
        this.ids = new ArrayList(pGPPublicKey.ids);
        this.idTrusts = new ArrayList(pGPPublicKey.idTrusts);
        this.idSigs = new ArrayList(pGPPublicKey.idSigs.size());
        for (int i = 0; i != pGPPublicKey.idSigs.size(); ++i) {
            this.idSigs.add(new ArrayList((List)pGPPublicKey.idSigs.get(i)));
        }
        if (pGPPublicKey.subSigs != null) {
            this.subSigs = new ArrayList(pGPPublicKey.subSigs.size());
            this.subSigs.addAll(pGPPublicKey.subSigs);
        }
        this.fingerprint = pGPPublicKey.fingerprint;
        this.keyID = pGPPublicKey.keyID;
        this.keyStrength = pGPPublicKey.keyStrength;
    }

    PGPPublicKey(PublicKeyPacket publicKeyPacket, TrustPacket trustPacket, List list, List list2, List list3, List list4, KeyFingerPrintCalculator keyFingerPrintCalculator) throws PGPException {
        this.publicPk = publicKeyPacket;
        this.trustPk = trustPacket;
        this.keySigs = list;
        this.ids = list2;
        this.idTrusts = list3;
        this.idSigs = list4;
        this.init(keyFingerPrintCalculator);
    }

    PGPPublicKey(PGPPublicKey pGPPublicKey, TrustPacket trustPacket, List list, List list2, List list3, List list4) throws PGPException {
        this.publicPk = pGPPublicKey.publicPk;
        this.fingerprint = pGPPublicKey.fingerprint;
        this.keyStrength = pGPPublicKey.keyStrength;
        this.keyID = pGPPublicKey.keyID;
        this.trustPk = trustPacket;
        this.keySigs = list;
        this.ids = list2;
        this.idTrusts = list3;
        this.idSigs = list4;
    }

    public int getVersion() {
        return this.publicPk.getVersion();
    }

    public Date getCreationTime() {
        return this.publicPk.getTime();
    }

    public int getValidDays() {
        if (this.publicPk.getVersion() > 3) {
            long l = this.getValidSeconds() % 86400L;
            int n = (int)(this.getValidSeconds() / 86400L);
            if (l > 0L && n == 0) {
                return 1;
            }
            return n;
        }
        return this.publicPk.getValidDays();
    }

    public byte[] getTrustData() {
        if (this.trustPk == null) {
            return null;
        }
        return Arrays.clone((byte[])this.trustPk.getLevelAndTrustAmount());
    }

    public long getValidSeconds() {
        if (this.publicPk.getVersion() > 3) {
            if (this.isMasterKey()) {
                for (int i = 0; i != MASTER_KEY_CERTIFICATION_TYPES.length; ++i) {
                    long l = this.getExpirationTimeFromSig(true, MASTER_KEY_CERTIFICATION_TYPES[i]);
                    if (l < 0L) continue;
                    return l;
                }
            } else {
                long l = this.getExpirationTimeFromSig(false, 24);
                if (l >= 0L) {
                    return l;
                }
                l = this.getExpirationTimeFromSig(false, 31);
                if (l >= 0L) {
                    return l;
                }
            }
            return 0L;
        }
        return (long)this.publicPk.getValidDays() * 24L * 60L * 60L;
    }

    private long getExpirationTimeFromSig(boolean bl, int n) {
        Iterator iterator = this.getSignaturesOfType(n);
        long l = -1L;
        long l2 = -1L;
        while (iterator.hasNext()) {
            PGPSignatureSubpacketVector pGPSignatureSubpacketVector;
            PGPSignature pGPSignature = (PGPSignature)iterator.next();
            if (bl && pGPSignature.getKeyID() != this.getKeyID() || (pGPSignatureSubpacketVector = pGPSignature.getHashedSubPackets()) == null || !pGPSignatureSubpacketVector.hasSubpacket(9)) continue;
            long l3 = pGPSignatureSubpacketVector.getKeyExpirationTime();
            if (pGPSignature.getKeyID() == this.getKeyID()) {
                if (pGPSignature.getCreationTime().getTime() <= l2) continue;
                l2 = pGPSignature.getCreationTime().getTime();
                l = l3;
                continue;
            }
            if (l3 != 0L && l3 <= l) continue;
            l = l3;
        }
        return l;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public byte[] getFingerprint() {
        byte[] byArray = new byte[this.fingerprint.length];
        System.arraycopy(this.fingerprint, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public boolean isEncryptionKey() {
        int n = this.publicPk.getAlgorithm();
        return n == 1 || n == 2 || n == 16 || n == 20 || n == 21 || n == 18;
    }

    public boolean isMasterKey() {
        return !(this.publicPk instanceof PublicSubkeyPacket) && (!this.isEncryptionKey() || this.publicPk.getAlgorithm() == 1);
    }

    public int getAlgorithm() {
        return this.publicPk.getAlgorithm();
    }

    public int getBitStrength() {
        return this.keyStrength;
    }

    public Iterator getUserIDs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!(this.ids.get(i) instanceof UserIDPacket)) continue;
            arrayList.add(((UserIDPacket)this.ids.get(i)).getID());
        }
        return arrayList.iterator();
    }

    public Iterator getRawUserIDs() {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!(this.ids.get(i) instanceof UserIDPacket)) continue;
            arrayList.add(((UserIDPacket)this.ids.get(i)).getRawID());
        }
        return arrayList.iterator();
    }

    public Iterator getUserAttributes() {
        ArrayList<PGPUserAttributeSubpacketVector> arrayList = new ArrayList<PGPUserAttributeSubpacketVector>();
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!(this.ids.get(i) instanceof PGPUserAttributeSubpacketVector)) continue;
            arrayList.add((PGPUserAttributeSubpacketVector)this.ids.get(i));
        }
        return arrayList.iterator();
    }

    public Iterator getSignaturesForID(String string) {
        return this.getSignaturesForID(new UserIDPacket(string));
    }

    public Iterator getSignaturesForID(byte[] byArray) {
        return this.getSignaturesForID(new UserIDPacket(byArray));
    }

    public Iterator getSignaturesForKeyID(long l) {
        ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
        Iterator iterator = this.getSignatures();
        while (iterator.hasNext()) {
            PGPSignature pGPSignature = (PGPSignature)iterator.next();
            if (pGPSignature.getKeyID() != l) continue;
            arrayList.add(pGPSignature);
        }
        return arrayList.iterator();
    }

    private Iterator getSignaturesForID(UserIDPacket userIDPacket) {
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!userIDPacket.equals(this.ids.get(i))) continue;
            bl = true;
            arrayList.addAll((List)this.idSigs.get(i));
        }
        return bl ? arrayList.iterator() : null;
    }

    public Iterator getSignaturesForUserAttribute(PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector) {
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!pGPUserAttributeSubpacketVector.equals(this.ids.get(i))) continue;
            bl = true;
            arrayList.addAll((List)this.idSigs.get(i));
        }
        return bl ? arrayList.iterator() : null;
    }

    public Iterator getSignaturesOfType(int n) {
        ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
        Iterator iterator = this.getSignatures();
        while (iterator.hasNext()) {
            PGPSignature pGPSignature = (PGPSignature)iterator.next();
            if (pGPSignature.getSignatureType() != n) continue;
            arrayList.add(pGPSignature);
        }
        return arrayList.iterator();
    }

    public Iterator getSignatures() {
        if (this.subSigs == null) {
            ArrayList arrayList = new ArrayList(this.keySigs);
            for (int i = 0; i != this.idSigs.size(); ++i) {
                arrayList.addAll((List)this.idSigs.get(i));
            }
            return arrayList.iterator();
        }
        return this.subSigs.iterator();
    }

    public Iterator getKeySignatures() {
        if (this.subSigs == null) {
            ArrayList arrayList = new ArrayList(this.keySigs);
            return arrayList.iterator();
        }
        return this.subSigs.iterator();
    }

    public PublicKeyPacket getPublicKeyPacket() {
        return this.publicPk;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream, false);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getEncoded(boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream, bl);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(outputStream, false);
    }

    public void encode(OutputStream outputStream, boolean bl) throws IOException {
        BCPGOutputStream bCPGOutputStream = BCPGOutputStream.wrap(outputStream);
        bCPGOutputStream.writePacket(this.publicPk);
        if (!bl && this.trustPk != null) {
            bCPGOutputStream.writePacket(this.trustPk);
        }
        if (this.subSigs == null) {
            int n;
            for (n = 0; n != this.keySigs.size(); ++n) {
                ((PGPSignature)this.keySigs.get(n)).encode(bCPGOutputStream);
            }
            for (n = 0; n != this.ids.size(); ++n) {
                Object object;
                if (this.ids.get(n) instanceof UserIDPacket) {
                    object = (UserIDPacket)this.ids.get(n);
                    bCPGOutputStream.writePacket((ContainedPacket)object);
                } else {
                    object = (PGPUserAttributeSubpacketVector)this.ids.get(n);
                    bCPGOutputStream.writePacket(new UserAttributePacket(((PGPUserAttributeSubpacketVector)object).toSubpacketArray()));
                }
                if (!bl && this.idTrusts.get(n) != null) {
                    bCPGOutputStream.writePacket((TrustPacket)this.idTrusts.get(n));
                }
                object = (List)this.idSigs.get(n);
                for (int i = 0; i != object.size(); ++i) {
                    ((PGPSignature)object.get(i)).encode(bCPGOutputStream, bl);
                }
            }
        } else {
            for (int i = 0; i != this.subSigs.size(); ++i) {
                ((PGPSignature)this.subSigs.get(i)).encode(bCPGOutputStream, bl);
            }
        }
    }

    public boolean isRevoked() {
        return this.hasRevocation();
    }

    public boolean hasRevocation() {
        int n = 0;
        boolean bl = false;
        if (this.isMasterKey()) {
            while (!bl && n < this.keySigs.size()) {
                if (((PGPSignature)this.keySigs.get(n++)).getSignatureType() != 32) continue;
                bl = true;
            }
        } else {
            while (!bl && n < this.subSigs.size()) {
                if (((PGPSignature)this.subSigs.get(n++)).getSignatureType() != 40) continue;
                bl = true;
            }
        }
        return bl;
    }

    public static PGPPublicKey addCertification(PGPPublicKey pGPPublicKey, byte[] byArray, PGPSignature pGPSignature) {
        return PGPPublicKey.addCert(pGPPublicKey, new UserIDPacket(byArray), pGPSignature);
    }

    public static PGPPublicKey addCertification(PGPPublicKey pGPPublicKey, String string, PGPSignature pGPSignature) {
        return PGPPublicKey.addCert(pGPPublicKey, new UserIDPacket(string), pGPSignature);
    }

    public static PGPPublicKey addCertification(PGPPublicKey pGPPublicKey, PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector, PGPSignature pGPSignature) {
        return PGPPublicKey.addCert(pGPPublicKey, pGPUserAttributeSubpacketVector, pGPSignature);
    }

    private static PGPPublicKey addCert(PGPPublicKey pGPPublicKey, UserDataPacket userDataPacket, PGPSignature pGPSignature) {
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        List<PGPSignature> list = null;
        for (int i = 0; i != pGPPublicKey2.ids.size(); ++i) {
            if (!userDataPacket.equals(pGPPublicKey2.ids.get(i))) continue;
            list = (List)pGPPublicKey2.idSigs.get(i);
        }
        if (list != null) {
            list.add(pGPSignature);
        } else {
            list = new ArrayList<PGPSignature>();
            list.add(pGPSignature);
            pGPPublicKey2.ids.add(userDataPacket);
            pGPPublicKey2.idTrusts.add(null);
            pGPPublicKey2.idSigs.add(list);
        }
        return pGPPublicKey2;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector) {
        return PGPPublicKey.removeCert(pGPPublicKey, pGPUserAttributeSubpacketVector);
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, String string) {
        return PGPPublicKey.removeCert(pGPPublicKey, new UserIDPacket(string));
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, byte[] byArray) {
        return PGPPublicKey.removeCert(pGPPublicKey, new UserIDPacket(byArray));
    }

    private static PGPPublicKey removeCert(PGPPublicKey pGPPublicKey, UserDataPacket userDataPacket) {
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        boolean bl = false;
        for (int i = pGPPublicKey2.ids.size() - 1; i >= 0; --i) {
            if (!userDataPacket.equals(pGPPublicKey2.ids.get(i))) continue;
            bl = true;
            pGPPublicKey2.ids.remove(i);
            pGPPublicKey2.idTrusts.remove(i);
            pGPPublicKey2.idSigs.remove(i);
        }
        return bl ? pGPPublicKey2 : null;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, byte[] byArray, PGPSignature pGPSignature) {
        return PGPPublicKey.removeCert(pGPPublicKey, new UserIDPacket(byArray), pGPSignature);
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, String string, PGPSignature pGPSignature) {
        return PGPPublicKey.removeCert(pGPPublicKey, new UserIDPacket(string), pGPSignature);
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector, PGPSignature pGPSignature) {
        return PGPPublicKey.removeCert(pGPPublicKey, pGPUserAttributeSubpacketVector, pGPSignature);
    }

    private static PGPPublicKey removeCert(PGPPublicKey pGPPublicKey, UserDataPacket userDataPacket, PGPSignature pGPSignature) {
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        boolean bl = false;
        for (int i = 0; i < pGPPublicKey2.ids.size(); ++i) {
            if (!userDataPacket.equals(pGPPublicKey2.ids.get(i))) continue;
            bl |= ((List)pGPPublicKey2.idSigs.get(i)).remove(pGPSignature);
        }
        return bl ? pGPPublicKey2 : null;
    }

    public static PGPPublicKey addCertification(PGPPublicKey pGPPublicKey, PGPSignature pGPSignature) {
        if (pGPPublicKey.isMasterKey()) {
            if (pGPSignature.getSignatureType() == 40) {
                throw new IllegalArgumentException("signature type incorrect for master key revocation.");
            }
        } else if (pGPSignature.getSignatureType() == 32) {
            throw new IllegalArgumentException("signature type incorrect for sub-key revocation.");
        }
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        List list = pGPPublicKey2.subSigs != null ? pGPPublicKey2.subSigs : pGPPublicKey2.keySigs;
        list.add(pGPSignature);
        return pGPPublicKey2;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, PGPSignature pGPSignature) {
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        List list = pGPPublicKey2.subSigs != null ? pGPPublicKey2.subSigs : pGPPublicKey2.keySigs;
        boolean bl = list.remove(pGPSignature);
        Iterator iterator = pGPPublicKey2.idSigs.iterator();
        while (iterator.hasNext()) {
            List list2 = (List)iterator.next();
            bl |= list2.remove(pGPSignature);
        }
        return bl ? pGPPublicKey2 : null;
    }

    public static PGPPublicKey join(PGPPublicKey pGPPublicKey, PGPPublicKey pGPPublicKey2, boolean bl, boolean bl2) throws PGPException {
        Object object;
        ArrayList<Object> arrayList;
        if (pGPPublicKey.getKeyID() != pGPPublicKey2.getKeyID()) {
            throw new IllegalArgumentException("Key-ID mismatch.");
        }
        TrustPacket trustPacket = pGPPublicKey.trustPk;
        ArrayList<Object> arrayList2 = new ArrayList<Object>(pGPPublicKey.keySigs);
        ArrayList<Object> arrayList3 = new ArrayList<Object>(pGPPublicKey.ids);
        ArrayList<TrustPacket> arrayList4 = new ArrayList<TrustPacket>(pGPPublicKey.idTrusts);
        ArrayList arrayList5 = new ArrayList(pGPPublicKey.idSigs);
        ArrayList<Object> arrayList6 = arrayList = pGPPublicKey.subSigs == null ? null : new ArrayList<Object>(pGPPublicKey.subSigs);
        if (bl && pGPPublicKey2.trustPk != null) {
            trustPacket = pGPPublicKey2.trustPk;
        }
        Iterator iterator = pGPPublicKey2.keySigs.iterator();
        while (iterator.hasNext()) {
            object = (PGPSignature)iterator.next();
            boolean bl3 = false;
            for (int i = 0; i < arrayList2.size(); ++i) {
                PGPSignature pGPSignature = (PGPSignature)arrayList2.get(i);
                if (!PGPSignature.isSignatureEncodingEqual(pGPSignature, (PGPSignature)object)) continue;
                bl3 = true;
                pGPSignature = PGPSignature.join(pGPSignature, (PGPSignature)object);
                arrayList2.set(i, pGPSignature);
                break;
            }
            if (bl3) break;
            arrayList2.add(object);
        }
        for (int i = 0; i < pGPPublicKey2.ids.size(); ++i) {
            TrustPacket trustPacket2;
            Object object2;
            object = (UserDataPacket)pGPPublicKey2.ids.get(i);
            ArrayList arrayList7 = new ArrayList((List)pGPPublicKey2.idSigs.get(i));
            TrustPacket trustPacket3 = (TrustPacket)pGPPublicKey2.idTrusts.get(i);
            int n = -1;
            for (int j = 0; j < arrayList3.size(); ++j) {
                object2 = (UserDataPacket)arrayList3.get(j);
                if (!object2.equals(object)) continue;
                n = j;
                break;
            }
            if (n == -1) {
                arrayList3.add(object);
                arrayList5.add(arrayList7);
                arrayList4.add(bl ? trustPacket3 : null);
                continue;
            }
            if (bl && trustPacket3 != null && ((trustPacket2 = (TrustPacket)arrayList4.get(n)) == null || Arrays.areEqual((byte[])trustPacket3.getLevelAndTrustAmount(), (byte[])trustPacket2.getLevelAndTrustAmount()))) {
                arrayList4.set(n, trustPacket3);
            }
            List list = (List)arrayList5.get(n);
            object2 = arrayList7.iterator();
            while (object2.hasNext()) {
                PGPSignature pGPSignature = (PGPSignature)object2.next();
                boolean bl4 = false;
                for (int j = 0; j < list.size(); ++j) {
                    PGPSignature pGPSignature2 = (PGPSignature)list.get(j);
                    if (!PGPSignature.isSignatureEncodingEqual(pGPSignature, pGPSignature2)) continue;
                    bl4 = true;
                    pGPSignature2 = PGPSignature.join(pGPSignature2, pGPSignature);
                    list.set(j, pGPSignature2);
                    break;
                }
                if (bl4) continue;
                list.add(pGPSignature);
            }
        }
        if (pGPPublicKey2.subSigs != null) {
            if (arrayList == null && bl2) {
                arrayList = new ArrayList(pGPPublicKey2.subSigs);
            } else {
                Iterator iterator2 = pGPPublicKey2.subSigs.iterator();
                while (iterator2.hasNext()) {
                    object = (PGPSignature)iterator2.next();
                    boolean bl5 = false;
                    for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
                        PGPSignature pGPSignature = (PGPSignature)arrayList.get(i);
                        if (!PGPSignature.isSignatureEncodingEqual(pGPSignature, (PGPSignature)object)) continue;
                        bl5 = true;
                        pGPSignature = PGPSignature.join(pGPSignature, (PGPSignature)object);
                        arrayList.set(i, pGPSignature);
                        break;
                    }
                    if (bl5 || arrayList == null) continue;
                    arrayList.add(object);
                }
            }
        }
        PGPPublicKey pGPPublicKey3 = new PGPPublicKey(pGPPublicKey, trustPacket, arrayList2, arrayList3, arrayList4, arrayList5);
        pGPPublicKey3.subSigs = arrayList;
        return pGPPublicKey3;
    }
}

