/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class UTCUtil {
    private static SimpleDateFormat utc() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    }

    public static String format(Date timestamp) {
        return UTCUtil.utc().format(timestamp);
    }

    public static Date parse(String utcTimestamp) {
        try {
            return UTCUtil.utc().parse(utcTimestamp);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Malformed UTC timestamp: " + utcTimestamp, e);
        }
    }
}

