/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.util.Date;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.SignatureSubpacketsFunction;
import org.bouncycastle.util.Arrays;

public class SignatureParameters {
    private int signatureType;
    private Date signatureCreationTime = new Date();
    private int signatureHashAlgorithmId;
    private SignatureSubpacketsFunction hashedSubpacketsFunction;
    private SignatureSubpacketsFunction unhashedSubpacketsFunction;
    private final int[] allowedSignatureTypes;

    private SignatureParameters(int ... allowedSignatureTypes) {
        this.allowedSignatureTypes = allowedSignatureTypes;
    }

    public static SignatureParameters directKeySignature(OpenPGPPolicy policy) {
        return new SignatureParameters(31).setSignatureType(31).setSignatureHashAlgorithm(policy.getDefaultCertificationSignatureHashAlgorithm()).setSignatureCreationTime(new Date());
    }

    public static SignatureParameters keyRevocation(OpenPGPPolicy policy) {
        return new SignatureParameters(32).setSignatureType(32).setSignatureHashAlgorithm(policy.getDefaultCertificationSignatureHashAlgorithm()).setSignatureCreationTime(new Date());
    }

    public static SignatureParameters certification(OpenPGPPolicy policy) {
        return new SignatureParameters(16, 17, 18, 19).setSignatureType(19).setSignatureHashAlgorithm(policy.getDefaultCertificationSignatureHashAlgorithm()).setSignatureCreationTime(new Date());
    }

    public static SignatureParameters subkeyBinding(OpenPGPPolicy policy) {
        return new SignatureParameters(24).setSignatureType(24).setSignatureHashAlgorithm(policy.getDefaultCertificationSignatureHashAlgorithm()).setSignatureCreationTime(new Date());
    }

    public static SignatureParameters subkeyRevocation(OpenPGPPolicy policy) {
        return new SignatureParameters(40).setSignatureType(40).setSignatureHashAlgorithm(policy.getDefaultCertificationSignatureHashAlgorithm()).setSignatureCreationTime(new Date());
    }

    public static SignatureParameters primaryKeyBinding(OpenPGPPolicy policy) {
        return new SignatureParameters(25).setSignatureType(25).setSignatureHashAlgorithm(policy.getDefaultCertificationSignatureHashAlgorithm()).setSignatureCreationTime(new Date());
    }

    public static SignatureParameters certificationRevocation(OpenPGPPolicy policy) {
        return new SignatureParameters(48).setSignatureType(48).setSignatureHashAlgorithm(policy.getDefaultCertificationSignatureHashAlgorithm()).setSignatureCreationTime(new Date());
    }

    public static SignatureParameters dataSignature(OpenPGPPolicy policy) {
        return new SignatureParameters(0, 1).setSignatureType(0).setSignatureHashAlgorithm(policy.getDefaultDocumentSignatureHashAlgorithm()).setSignatureCreationTime(new Date());
    }

    public SignatureParameters setSignatureType(int signatureType) {
        if (!Arrays.contains((int[])this.allowedSignatureTypes, (int)signatureType)) {
            throw new IllegalArgumentException("Illegal signature type provided.");
        }
        this.signatureType = signatureType;
        return this;
    }

    public int getSignatureType() {
        return this.signatureType;
    }

    public SignatureParameters setSignatureCreationTime(Date signatureCreationTime) {
        if (signatureCreationTime == null) {
            throw new NullPointerException("Signature creation time cannot be null.");
        }
        this.signatureCreationTime = signatureCreationTime;
        return this;
    }

    public Date getSignatureCreationTime() {
        return this.signatureCreationTime;
    }

    public SignatureParameters setSignatureHashAlgorithm(int signatureHashAlgorithmId) {
        this.signatureHashAlgorithmId = signatureHashAlgorithmId;
        return this;
    }

    public int getSignatureHashAlgorithmId() {
        return this.signatureHashAlgorithmId;
    }

    public SignatureParameters setHashedSubpacketsFunction(SignatureSubpacketsFunction subpacketsFunction) {
        this.hashedSubpacketsFunction = subpacketsFunction;
        return this;
    }

    PGPSignatureSubpacketGenerator applyToHashedSubpackets(PGPSignatureSubpacketGenerator hashedSubpackets) {
        if (this.hashedSubpacketsFunction != null) {
            return this.hashedSubpacketsFunction.apply(hashedSubpackets);
        }
        return hashedSubpackets;
    }

    public SignatureParameters setUnhashedSubpacketsFunction(SignatureSubpacketsFunction subpacketsFunction) {
        this.unhashedSubpacketsFunction = subpacketsFunction;
        return this;
    }

    PGPSignatureSubpacketGenerator applyToUnhashedSubpackets(PGPSignatureSubpacketGenerator unhashedSubpackets) {
        if (this.unhashedSubpacketsFunction != null) {
            return this.unhashedSubpacketsFunction.apply(unhashedSubpackets);
        }
        return unhashedSubpackets;
    }

    public static interface Callback {
        default public SignatureParameters apply(SignatureParameters parameters) {
            return parameters;
        }

        public static class Util {
            public static Callback modifyHashedSubpackets(final SignatureSubpacketsFunction function) {
                return new Callback(){

                    @Override
                    public SignatureParameters apply(SignatureParameters parameters) {
                        return parameters.setHashedSubpacketsFunction(function);
                    }
                };
            }
        }
    }
}

