/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;

public interface OpenPGPPolicy {
    default public boolean isAcceptableSigningKey(PGPPublicKey key) {
        return this.isAcceptablePublicKey(key);
    }

    default public boolean isAcceptableVerificationKey(PGPPublicKey key) {
        return this.isAcceptablePublicKey(key);
    }

    default public boolean isAcceptableEncryptionKey(PGPPublicKey key) {
        return this.isAcceptablePublicKey(key);
    }

    default public boolean isAcceptableDecryptionKey(PGPPublicKey key) {
        return this.isAcceptablePublicKey(key);
    }

    default public boolean isAcceptablePublicKey(PGPPublicKey key) {
        return this.isAcceptablePublicKeyStrength(key.getAlgorithm(), key.getBitStrength());
    }

    default public boolean isAcceptableSignature(PGPSignature signature) {
        return this.hasAcceptableSignatureHashAlgorithm(signature) && this.hasNoCriticalUnknownNotations(signature) && this.hasNoCriticalUnknownSubpackets(signature);
    }

    default public boolean hasAcceptableSignatureHashAlgorithm(PGPSignature signature) {
        switch (signature.getSignatureType()) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 31: {
                return this.hasAcceptableCertificationSignatureHashAlgorithm(signature);
            }
            case 32: 
            case 40: 
            case 48: {
                return this.hasAcceptableRevocationSignatureHashAlgorithm(signature);
            }
        }
        return this.hasAcceptableDocumentSignatureHashAlgorithm(signature);
    }

    default public boolean hasAcceptableDocumentSignatureHashAlgorithm(PGPSignature signature) {
        return this.isAcceptableDocumentSignatureHashAlgorithm(signature.getHashAlgorithm(), signature.getCreationTime());
    }

    default public boolean hasAcceptableRevocationSignatureHashAlgorithm(PGPSignature signature) {
        return this.isAcceptableRevocationSignatureHashAlgorithm(signature.getHashAlgorithm(), signature.getCreationTime());
    }

    default public boolean hasAcceptableCertificationSignatureHashAlgorithm(PGPSignature signature) {
        return this.isAcceptableCertificationSignatureHashAlgorithm(signature.getHashAlgorithm(), signature.getCreationTime());
    }

    default public boolean hasNoCriticalUnknownNotations(PGPSignature signature) {
        NotationData[] notations;
        PGPSignatureSubpacketVector hashedSubpackets = signature.getHashedSubPackets();
        if (hashedSubpackets == null) {
            return true;
        }
        OpenPGPNotationRegistry registry = this.getNotationRegistry();
        for (NotationData notation : notations = hashedSubpackets.getNotationDataOccurrences()) {
            if (!notation.isCritical() || registry.isNotationKnown(notation.getNotationName())) continue;
            return false;
        }
        return true;
    }

    default public boolean hasNoCriticalUnknownSubpackets(PGPSignature signature) {
        PGPSignatureSubpacketVector hashedSubpackets = signature.getHashedSubPackets();
        if (hashedSubpackets == null) {
            return true;
        }
        for (SignatureSubpacket subpacket : hashedSubpackets.toArray()) {
            if (!subpacket.isCritical() || !subpacket.getClass().equals(SignatureSubpacket.class) || this.isKnownSignatureSubpacket(subpacket.getType())) continue;
            return false;
        }
        return true;
    }

    default public boolean isKnownSignatureSubpacket(int signatureSubpacketTag) {
        return false;
    }

    public boolean isAcceptableDocumentSignatureHashAlgorithm(int var1, Date var2);

    public boolean isAcceptableRevocationSignatureHashAlgorithm(int var1, Date var2);

    public boolean isAcceptableCertificationSignatureHashAlgorithm(int var1, Date var2);

    public int getDefaultCertificationSignatureHashAlgorithm();

    public int getDefaultDocumentSignatureHashAlgorithm();

    public boolean isAcceptableSymmetricKeyAlgorithm(int var1);

    public int getDefaultSymmetricKeyAlgorithm();

    public boolean isAcceptablePublicKeyStrength(int var1, int var2);

    public OpenPGPNotationRegistry getNotationRegistry();

    public static class OpenPGPNotationRegistry {
        private final Set<String> knownNotations = new HashSet<String>();

        public boolean isNotationKnown(String notationName) {
            return this.knownNotations.contains(notationName);
        }

        public void addKnownNotation(String notationName) {
            this.knownNotations.add(notationName);
        }
    }
}

