/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.openpgp.IntegrityProtectedInputStream;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.PGPSessionKeyEncryptedData;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.api.KeyPassphraseProvider;
import org.bouncycastle.openpgp.api.MissingMessagePassphraseCallback;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.api.OpenPGPKeyMaterialPool;
import org.bouncycastle.openpgp.api.OpenPGPKeyMaterialProvider;
import org.bouncycastle.openpgp.api.OpenPGPMessageInputStream;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.exception.KeyPassphraseException;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.util.Arrays;

public class OpenPGPMessageProcessor {
    private final OpenPGPImplementation implementation;
    private final Configuration configuration;

    public OpenPGPMessageProcessor() {
        this(OpenPGPImplementation.getInstance());
    }

    public OpenPGPMessageProcessor(OpenPGPImplementation implementation) {
        this(implementation, implementation.policy());
    }

    public OpenPGPMessageProcessor(OpenPGPImplementation implementation, OpenPGPPolicy policy) {
        this.implementation = implementation;
        this.configuration = new Configuration(policy);
    }

    public OpenPGPMessageProcessor addVerificationCertificate(OpenPGPCertificate issuerCertificate) {
        this.configuration.certificatePool.addItem(issuerCertificate);
        return this;
    }

    public OpenPGPMessageProcessor verifyNotAfter(Date date) {
        this.configuration.verifyNotAfter = date;
        return this;
    }

    public OpenPGPMessageProcessor verifyNotBefore(Date date) {
        this.configuration.verifyNotBefore = date;
        return this;
    }

    public OpenPGPMessageProcessor addDecryptionKey(OpenPGPKey key) {
        this.configuration.keyPool.addItem(key);
        return this;
    }

    public OpenPGPMessageProcessor addDecryptionKey(OpenPGPKey key, char[] passphrase) {
        this.configuration.keyPool.addItem(key);
        this.configuration.keyPassphraseProvider.addPassphrase(key, passphrase);
        return this;
    }

    public OpenPGPMessageProcessor addDecryptionKeyPassphrase(char[] passphrase) {
        this.configuration.keyPassphraseProvider.addPassphrase(passphrase);
        return this;
    }

    public OpenPGPMessageProcessor setMissingOpenPGPKeyPassphraseProvider(KeyPassphraseProvider keyPassphraseProvider) {
        this.configuration.keyPassphraseProvider.setMissingPassphraseCallback(keyPassphraseProvider);
        return this;
    }

    public OpenPGPMessageProcessor setMissingOpenPGPCertificateProvider(OpenPGPKeyMaterialProvider.OpenPGPCertificateProvider certificateProvider) {
        this.configuration.certificatePool.setMissingItemCallback((OpenPGPKeyMaterialProvider)certificateProvider);
        return this;
    }

    public OpenPGPMessageProcessor setMissingOpenPGPKeyProvider(OpenPGPKeyMaterialProvider.OpenPGPKeyProvider keyProvider) {
        this.configuration.keyPool.setMissingItemCallback((OpenPGPKeyMaterialProvider)keyProvider);
        return this;
    }

    public OpenPGPMessageProcessor addMessagePassphrase(char[] messagePassphrase) {
        this.configuration.addMessagePassphrase(messagePassphrase);
        return this;
    }

    public OpenPGPMessageProcessor setMissingMessagePassphraseCallback(MissingMessagePassphraseCallback callback) {
        this.configuration.missingMessagePassphraseCallback = callback;
        return this;
    }

    public OpenPGPMessageProcessor setSessionKey(PGPSessionKey sessionKey) {
        this.configuration.sessionKey = sessionKey;
        return this;
    }

    public OpenPGPMessageInputStream process(InputStream messageIn) throws IOException, PGPException {
        InputStream packetInputStream = PGPUtil.getDecoderStream(messageIn);
        PGPObjectFactory objectFactory = this.implementation.pgpObjectFactory(packetInputStream);
        OpenPGPMessageInputStream in = new OpenPGPMessageInputStream(objectFactory, this);
        in.process();
        return in;
    }

    Date getVerifyNotBefore() {
        return this.configuration.verifyNotBefore;
    }

    Date getVerifyNotAfter() {
        return this.configuration.verifyNotAfter;
    }

    Decrypted decrypt(PGPEncryptedDataList encDataList) throws PGPException {
        if (this.configuration.sessionKey != null) {
            SessionKeyDataDecryptorFactory decryptorFactory = this.implementation.sessionKeyDataDecryptorFactory(this.configuration.sessionKey);
            PGPSessionKeyEncryptedData encData = encDataList.extractSessionKeyEncryptedData();
            InputStream decryptedIn = encData.getDataStream(decryptorFactory);
            IntegrityProtectedInputStream verifyingIn = new IntegrityProtectedInputStream(decryptedIn, encData);
            return new Decrypted(encData, this.configuration.sessionKey, verifyingIn);
        }
        List<PGPPBEEncryptedData> skesks = this.skesks(encDataList);
        List<PGPPublicKeyEncryptedData> pkesks = this.pkesks(encDataList);
        PGPException exception = null;
        if (!skesks.isEmpty() && !this.configuration.messagePassphrases.isEmpty()) {
            for (PGPPBEEncryptedData skesk : skesks) {
                for (char[] passphrase : this.configuration.messagePassphrases) {
                    try {
                        PBEDataDecryptorFactory passphraseDecryptorFactory = this.implementation.pbeDataDecryptorFactory(passphrase);
                        PGPSessionKey decryptedSessionKey = skesk.getSessionKey(passphraseDecryptorFactory);
                        SessionKeyDataDecryptorFactory skDecryptorFactory = this.implementation.sessionKeyDataDecryptorFactory(decryptedSessionKey);
                        PGPSessionKeyEncryptedData encData = encDataList.extractSessionKeyEncryptedData();
                        InputStream decryptedIn = encData.getDataStream(skDecryptorFactory);
                        IntegrityProtectedInputStream verifyingIn = new IntegrityProtectedInputStream(decryptedIn, encData);
                        Decrypted decrypted = new Decrypted(encData, decryptedSessionKey, verifyingIn);
                        decrypted.decryptionPassphrase = passphrase;
                        return decrypted;
                    }
                    catch (PGPException e) {
                        this.onException(e);
                        exception = exception != null ? exception : e;
                    }
                }
            }
        }
        for (PGPPublicKeyEncryptedData pkesk : pkesks) {
            OpenPGPKey.OpenPGPSecretKey decryptionKey;
            KeyIdentifier identifier = pkesk.getKeyIdentifier();
            OpenPGPKey key = (OpenPGPKey)this.configuration.keyPool.provide(identifier);
            if (key == null || (decryptionKey = key.getSecretKeys().get(identifier)) == null) continue;
            try {
                if (!decryptionKey.isEncryptionKey()) {
                    throw new PGPException("Key is not an encryption key and can therefore not decrypt.");
                }
                char[] keyPassphrase = this.configuration.keyPassphraseProvider.getKeyPassword(decryptionKey);
                PGPKeyPair unlockedKey = decryptionKey.unlock(keyPassphrase).getKeyPair();
                if (unlockedKey == null) {
                    throw new KeyPassphraseException((OpenPGPCertificate.OpenPGPComponentKey)decryptionKey, (Exception)new PGPException("Cannot unlock secret key."));
                }
                PublicKeyDataDecryptorFactory pkDecryptorFactory = this.implementation.publicKeyDataDecryptorFactory(unlockedKey.getPrivateKey());
                PGPSessionKey decryptedSessionKey = pkesk.getSessionKey(pkDecryptorFactory);
                SessionKeyDataDecryptorFactory skDecryptorFactory = this.implementation.sessionKeyDataDecryptorFactory(decryptedSessionKey);
                PGPSessionKeyEncryptedData encData = encDataList.extractSessionKeyEncryptedData();
                InputStream decryptedIn = encData.getDataStream(skDecryptorFactory);
                IntegrityProtectedInputStream verifyingIn = new IntegrityProtectedInputStream(decryptedIn, encData);
                Decrypted decrypted = new Decrypted(encData, decryptedSessionKey, verifyingIn);
                decrypted.decryptionKey = decryptionKey;
                return decrypted;
            }
            catch (PGPException e) {
                this.onException(e);
            }
        }
        if (!skesks.isEmpty() && this.configuration.missingMessagePassphraseCallback != null) {
            char[] passphrase;
            while ((passphrase = this.configuration.missingMessagePassphraseCallback.getMessagePassphrase()) != null) {
                for (PGPPBEEncryptedData skesk : skesks) {
                    try {
                        PBEDataDecryptorFactory passphraseDecryptorFactory = this.implementation.pbeDataDecryptorFactory(passphrase);
                        PGPSessionKey decryptedSessionKey = skesk.getSessionKey(passphraseDecryptorFactory);
                        SessionKeyDataDecryptorFactory skDecryptorFactory = this.implementation.sessionKeyDataDecryptorFactory(decryptedSessionKey);
                        PGPSessionKeyEncryptedData encData = encDataList.extractSessionKeyEncryptedData();
                        InputStream decryptedIn = encData.getDataStream(skDecryptorFactory);
                        IntegrityProtectedInputStream verifyingIn = new IntegrityProtectedInputStream(decryptedIn, encData);
                        Decrypted decrypted = new Decrypted(encData, decryptedSessionKey, verifyingIn);
                        decrypted.decryptionPassphrase = passphrase;
                        return decrypted;
                    }
                    catch (PGPException e) {
                        this.onException(e);
                        exception = exception != null ? exception : e;
                    }
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
        throw new PGPException("No working decryption method found.");
    }

    private List<PGPPBEEncryptedData> skesks(PGPEncryptedDataList encDataList) {
        ArrayList<PGPPBEEncryptedData> list = new ArrayList<PGPPBEEncryptedData>();
        Iterator<PGPEncryptedData> iterator = encDataList.iterator();
        while (iterator.hasNext()) {
            PGPEncryptedData encData = iterator.next();
            if (!(encData instanceof PGPPBEEncryptedData)) continue;
            list.add((PGPPBEEncryptedData)encData);
        }
        return list;
    }

    private List<PGPPublicKeyEncryptedData> pkesks(PGPEncryptedDataList encDataList) {
        ArrayList<PGPPublicKeyEncryptedData> list = new ArrayList<PGPPublicKeyEncryptedData>();
        Iterator<PGPEncryptedData> iterator = encDataList.iterator();
        while (iterator.hasNext()) {
            PGPEncryptedData encData = iterator.next();
            if (!(encData instanceof PGPPublicKeyEncryptedData)) continue;
            list.add((PGPPublicKeyEncryptedData)encData);
        }
        return list;
    }

    OpenPGPCertificate provideCertificate(KeyIdentifier identifier) {
        return this.configuration.certificatePool.provide(identifier);
    }

    OpenPGPImplementation getImplementation() {
        return this.implementation;
    }

    void onException(PGPException e) {
        if (this.configuration.exceptionCallback != null) {
            this.configuration.exceptionCallback.onException(e);
        }
    }

    public static class Configuration {
        private final OpenPGPPolicy policy;
        private final OpenPGPKeyMaterialPool.OpenPGPCertificatePool certificatePool;
        private final OpenPGPKeyMaterialPool.OpenPGPKeyPool keyPool;
        private final KeyPassphraseProvider.DefaultKeyPassphraseProvider keyPassphraseProvider;
        public final List<char[]> messagePassphrases = new ArrayList<char[]>();
        private MissingMessagePassphraseCallback missingMessagePassphraseCallback;
        private PGPExceptionCallback exceptionCallback = null;
        private PGPSessionKey sessionKey;
        private Date verifyNotAfter = new Date();
        private Date verifyNotBefore = new Date(0L);

        public Configuration(OpenPGPPolicy policy) {
            this.policy = policy;
            this.certificatePool = new OpenPGPKeyMaterialPool.OpenPGPCertificatePool();
            this.keyPool = new OpenPGPKeyMaterialPool.OpenPGPKeyPool();
            this.keyPassphraseProvider = new KeyPassphraseProvider.DefaultKeyPassphraseProvider();
        }

        public Configuration addMessagePassphrase(char[] messagePassphrase) {
            boolean found = false;
            for (char[] existing : this.messagePassphrases) {
                found |= Arrays.areEqual((char[])existing, (char[])messagePassphrase);
            }
            if (!found) {
                this.messagePassphrases.add(messagePassphrase);
            }
            return this;
        }
    }

    static class Decrypted {
        final InputStream inputStream;
        final PGPSessionKey sessionKey;
        final PGPEncryptedData esk;
        OpenPGPCertificate.OpenPGPComponentKey decryptionKey;
        char[] decryptionPassphrase;

        public Decrypted(PGPEncryptedData encryptedData, PGPSessionKey decryptedSessionKey, InputStream decryptedIn) {
            this.esk = encryptedData;
            this.sessionKey = decryptedSessionKey;
            this.inputStream = decryptedIn;
        }
    }

    public static interface PGPExceptionCallback {
        public void onException(PGPException var1);
    }
}

