/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.PacketFormat;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyValidationException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.api.KeyPassphraseProvider;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.exception.KeyPassphraseException;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptorBuilderProvider;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptorFactory;

public class OpenPGPKey
extends OpenPGPCertificate {
    private final Map<KeyIdentifier, OpenPGPSecretKey> secretKeys = new LinkedHashMap<KeyIdentifier, OpenPGPSecretKey>();

    public OpenPGPKey(PGPSecretKeyRing keyRing) {
        this(keyRing, OpenPGPImplementation.getInstance());
    }

    public OpenPGPKey(PGPSecretKeyRing keyRing, OpenPGPImplementation implementation) {
        this(keyRing, implementation, implementation.policy());
    }

    public OpenPGPKey(PGPSecretKeyRing keyRing, OpenPGPImplementation implementation, OpenPGPPolicy policy) {
        super(keyRing, implementation, policy);
        for (OpenPGPCertificate.OpenPGPComponentKey key : this.getKeys()) {
            KeyIdentifier identifier = key.getKeyIdentifier();
            PGPSecretKey secretKey = keyRing.getSecretKey(identifier);
            if (secretKey == null) continue;
            this.secretKeys.put(identifier, new OpenPGPSecretKey(key, secretKey, implementation.pbeSecretKeyDecryptorBuilderProvider()));
        }
    }

    @Override
    public boolean isSecretKey() {
        return true;
    }

    public OpenPGPCertificate toCertificate() {
        return new OpenPGPCertificate(this.getPGPPublicKeyRing(), this.implementation, this.policy);
    }

    @Override
    public List<OpenPGPCertificate.OpenPGPCertificateComponent> getComponents() {
        List<OpenPGPCertificate.OpenPGPCertificateComponent> components = super.getComponents();
        for (int i = components.size() - 1; i >= 0; --i) {
            OpenPGPSecretKey secretKey;
            OpenPGPCertificate.OpenPGPCertificateComponent component = components.get(i);
            if (!(component instanceof OpenPGPCertificate.OpenPGPComponentKey) || (secretKey = this.getSecretKey((OpenPGPCertificate.OpenPGPComponentKey)component)) == null) continue;
            components.remove(i);
            components.add(i, secretKey);
        }
        return components;
    }

    public OpenPGPSecretKey getPrimarySecretKey() {
        return this.getSecretKey(this.getPrimaryKey());
    }

    public Map<KeyIdentifier, OpenPGPSecretKey> getSecretKeys() {
        return new LinkedHashMap<KeyIdentifier, OpenPGPSecretKey>(this.secretKeys);
    }

    public OpenPGPSecretKey getSecretKey(KeyIdentifier identifier) {
        return this.secretKeys.get(identifier);
    }

    public OpenPGPSecretKey getSecretKey(OpenPGPCertificate.OpenPGPComponentKey key) {
        return this.getSecretKey(key.getKeyIdentifier());
    }

    void replaceSecretKey(OpenPGPSecretKey secretKey) {
        this.keyRing = PGPSecretKeyRing.insertSecretKey((PGPSecretKeyRing)this.keyRing, secretKey.rawSecKey);
        this.secretKeys.put(secretKey.getKeyIdentifier(), secretKey);
    }

    @Override
    public PGPSecretKeyRing getPGPKeyRing() {
        return this.getPGPSecretKeyRing();
    }

    public PGPSecretKeyRing getPGPSecretKeyRing() {
        return (PGPSecretKeyRing)super.getPGPKeyRing();
    }

    @Override
    public byte[] getEncoded(PacketFormat packetFormat) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = new BCPGOutputStream((OutputStream)bOut, packetFormat);
        this.getPGPSecretKeyRing().encode(pOut);
        pOut.close();
        return bOut.toByteArray();
    }

    public static class OpenPGPPrivateKey {
        private final OpenPGPSecretKey secretKey;
        private final PGPKeyPair unlockedKey;

        public OpenPGPPrivateKey(OpenPGPSecretKey secretKey, PGPKeyPair unlockedKey) {
            this.secretKey = secretKey;
            this.unlockedKey = unlockedKey;
        }

        public OpenPGPCertificate.OpenPGPComponentKey getPublicKey() {
            return this.secretKey.getPublicKey();
        }

        public OpenPGPSecretKey getSecretKey() {
            return this.secretKey;
        }

        public PGPKeyPair getKeyPair() {
            return this.unlockedKey;
        }

        private OpenPGPImplementation getImplementation() {
            return this.getSecretKey().getOpenPGPKey().implementation;
        }

        public OpenPGPSecretKey changePassphrase(char[] newPassphrase) throws PGPException {
            boolean useAead = !this.secretKey.isLocked() || this.secretKey.getPGPSecretKey().getS2KUsage() == 253;
            return this.changePassphrase(newPassphrase, this.getImplementation(), useAead);
        }

        public OpenPGPSecretKey changePassphrase(char[] newPassphrase, OpenPGPImplementation implementation, boolean useAEAD) throws PGPException {
            return this.changePassphrase(newPassphrase, implementation.pbeSecretKeyEncryptorFactory(useAEAD));
        }

        public OpenPGPSecretKey changePassphrase(char[] newPassphrase, PBESecretKeyEncryptorFactory keyEncryptorFactory) throws PGPException {
            PBESecretKeyEncryptor keyEncryptor = newPassphrase == null || newPassphrase.length == 0 ? null : keyEncryptorFactory.build(newPassphrase, this.getKeyPair().getPublicKey().getPublicKeyPacket());
            return this.changePassphrase(keyEncryptor);
        }

        public OpenPGPSecretKey changePassphrase(PBESecretKeyEncryptor keyEncryptor) throws PGPException {
            PGPSecretKey encrypted = new PGPSecretKey(this.getKeyPair().getPrivateKey(), this.getKeyPair().getPublicKey(), this.getImplementation().pgpDigestCalculatorProvider().get(2), this.getSecretKey().isPrimaryKey(), keyEncryptor);
            OpenPGPSecretKey sk = new OpenPGPSecretKey(this.getSecretKey().getPublicKey(), encrypted, this.getImplementation().pbeSecretKeyDecryptorBuilderProvider());
            sk.sanitizeProtectionMode();
            return sk;
        }

        public OpenPGPSecretKey removePassphrase() throws PGPException {
            return this.changePassphrase((PBESecretKeyEncryptor)null);
        }
    }

    public static class OpenPGPSecretKey
    extends OpenPGPCertificate.OpenPGPComponentKey {
        private final PGPSecretKey rawSecKey;
        private final OpenPGPCertificate.OpenPGPComponentKey pubKey;
        private final PBESecretKeyDecryptorBuilderProvider decryptorBuilderProvider;

        public OpenPGPSecretKey(OpenPGPCertificate.OpenPGPComponentKey pubKey, PGPSecretKey secKey, PBESecretKeyDecryptorBuilderProvider decryptorBuilderProvider) {
            super(pubKey.getPGPPublicKey(), pubKey.getCertificate());
            this.decryptorBuilderProvider = decryptorBuilderProvider;
            this.rawSecKey = secKey;
            this.pubKey = pubKey;
        }

        @Override
        protected OpenPGPCertificate.OpenPGPCertificateComponent getPublicComponent() {
            return this.pubKey;
        }

        @Override
        public boolean isPrimaryKey() {
            return this.getPublicKey().isPrimaryKey();
        }

        @Override
        public OpenPGPCertificate.OpenPGPComponentSignature getLatestSelfSignature(Date evaluationTime) {
            return this.getPublicKey().getLatestSelfSignature(evaluationTime);
        }

        public OpenPGPKey getOpenPGPKey() {
            return (OpenPGPKey)this.getCertificate();
        }

        @Override
        public String toDetailString() {
            return "Private" + this.pubKey.toDetailString();
        }

        public PGPSecretKey getPGPSecretKey() {
            return this.rawSecKey;
        }

        public OpenPGPCertificate.OpenPGPComponentKey getPublicKey() {
            return this.pubKey;
        }

        public boolean isLocked() {
            return this.getPGPSecretKey().getS2KUsage() != 0;
        }

        public OpenPGPPrivateKey unlock() throws PGPException {
            return this.unlock((char[])null);
        }

        public OpenPGPPrivateKey unlock(KeyPassphraseProvider passphraseProvider) throws PGPException {
            if (!this.isLocked()) {
                return this.unlock((char[])null);
            }
            return this.unlock(passphraseProvider.getKeyPassword(this));
        }

        public OpenPGPPrivateKey unlock(char[] passphrase) throws PGPException {
            this.sanitizeProtectionMode();
            PBESecretKeyDecryptor decryptor = null;
            try {
                PGPPrivateKey privateKey;
                if (passphrase != null) {
                    decryptor = this.decryptorBuilderProvider.provide().build(passphrase);
                }
                if ((privateKey = this.getPGPSecretKey().extractPrivateKey(decryptor)) == null) {
                    return null;
                }
                PGPKeyPair unlockedKey = new PGPKeyPair(this.getPGPSecretKey().getPublicKey(), privateKey);
                return new OpenPGPPrivateKey(this, unlockedKey);
            }
            catch (PGPException e) {
                throw new KeyPassphraseException((OpenPGPCertificate.OpenPGPComponentKey)this, (Exception)e);
            }
        }

        private void sanitizeProtectionMode() throws PGPException {
            if (!this.isLocked()) {
                return;
            }
            PGPSecretKey secretKey = this.getPGPSecretKey();
            S2K s2k = secretKey.getS2K();
            if (s2k == null) {
                throw new PGPKeyValidationException("Legacy CFB using MD5 is not allowed.");
            }
            if (s2k.getType() == 4 && secretKey.getS2KUsage() != 253) {
                throw new PGPKeyValidationException("Argon2 without AEAD is not allowed.");
            }
            if (this.getVersion() == 6) {
                if (secretKey.getS2KUsage() == 255) {
                    throw new PGPKeyValidationException("Version 6 keys MUST NOT use malleable CFB.");
                }
                if (s2k.getType() == 0) {
                    throw new PGPKeyValidationException("Version 6 keys MUST NOT use SIMPLE S2K.");
                }
            }
        }

        public boolean isPassphraseCorrect(char[] passphrase) {
            if (passphrase != null && !this.isLocked()) {
                return false;
            }
            try {
                OpenPGPPrivateKey privateKey = this.unlock(passphrase);
                return privateKey != null && privateKey.unlockedKey != null;
            }
            catch (PGPException e) {
                return false;
            }
        }
    }
}

