/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.util.Exceptions;

public class IntegrityProtectedInputStream
extends FilterInputStream {
    private final PGPEncryptedData esk;

    public IntegrityProtectedInputStream(InputStream in, PGPEncryptedData dataPacket) {
        super(in);
        this.esk = dataPacket;
    }

    @Override
    public int read() throws IOException {
        int i = this.in.read();
        if (i == -1) {
            this.close();
        }
        return i;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int r = this.in.read(b);
        if (r == -1) {
            this.close();
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.in.read(b, off, len);
        if (r == -1) {
            this.close();
        }
        return r;
    }

    @Override
    public void close() throws IOException {
        SymmetricEncIntegrityPacket seipd;
        super.close();
        if (this.esk.getEncData() instanceof SymmetricEncIntegrityPacket && (seipd = (SymmetricEncIntegrityPacket)this.esk.getEncData()).getVersion() == 1) {
            try {
                if (!this.esk.verify()) {
                    throw new PGPException("Malformed integrity protected data.");
                }
            }
            catch (PGPException e) {
                throw Exceptions.ioException((String)e.getMessage(), (Throwable)e);
            }
        }
    }
}

