/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api.exception;

import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.exception.OpenPGPKeyException;

public class InvalidEncryptionKeyException
extends OpenPGPKeyException {
    public InvalidEncryptionKeyException(OpenPGPCertificate certificate) {
        super(certificate, "Certificate " + certificate.getKeyIdentifier() + " does not contain any usable subkeys capable of encryption.");
    }

    public InvalidEncryptionKeyException(OpenPGPCertificate.OpenPGPComponentKey encryptionSubkey) {
        super(encryptionSubkey, InvalidEncryptionKeyException.componentKeyErrorMessage(encryptionSubkey));
    }

    private static String componentKeyErrorMessage(OpenPGPCertificate.OpenPGPComponentKey componentKey) {
        if (componentKey.getKeyIdentifier().equals(componentKey.getCertificate().getKeyIdentifier())) {
            return "The primary key " + componentKey.getKeyIdentifier() + " is not usable for encryption.";
        }
        return "The subkey " + componentKey.getKeyIdentifier() + " from the certificate " + componentKey.getCertificate().getKeyIdentifier() + " is not usable for encryption.";
    }
}

