/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.sig.PreferredAEADCiphersuites;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPadding;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.api.AbstractOpenPGPDocumentSignatureGenerator;
import org.bouncycastle.openpgp.api.EncryptedDataPacketType;
import org.bouncycastle.openpgp.api.MessageEncryptionMechanism;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPEncryptionNegotiator;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPMessageOutputStream;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.SubkeySelector;
import org.bouncycastle.openpgp.api.exception.InvalidEncryptionKeyException;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;

public class OpenPGPMessageGenerator
extends AbstractOpenPGPDocumentSignatureGenerator<OpenPGPMessageGenerator> {
    public static final int BUFFER_SIZE = 1024;
    private boolean isArmored = true;
    public boolean isAllowPadding = true;
    private final List<OpenPGPCertificate.OpenPGPComponentKey> encryptionKeys = new ArrayList<OpenPGPCertificate.OpenPGPComponentKey>();
    private final List<char[]> messagePassphrases = new ArrayList<char[]>();
    private Date fileModificationDate = null;
    private String filename = null;
    private char format = (char)98;
    private PGPEncryptedDataGenerator.SessionKeyExtractionCallback sessionKeyExtractionCallback;
    private ArmoredOutputStreamFactory armorStreamFactory = new ArmoredOutputStreamFactory(){

        @Override
        public ArmoredOutputStream get(OutputStream outputStream) {
            return ArmoredOutputStream.builder().clearHeaders().enableCRC(false).build(outputStream);
        }
    };
    private SubkeySelector encryptionKeySelector = new SubkeySelector(){

        @Override
        public List<OpenPGPCertificate.OpenPGPComponentKey> select(OpenPGPCertificate certificate, OpenPGPPolicy policy) {
            ArrayList<OpenPGPCertificate.OpenPGPComponentKey> result = new ArrayList<OpenPGPCertificate.OpenPGPComponentKey>();
            for (OpenPGPCertificate.OpenPGPComponentKey key : certificate.getEncryptionKeys()) {
                if (!policy.isAcceptablePublicKey(key.getPGPPublicKey())) continue;
                result.add(key);
            }
            return result;
        }
    };
    private OpenPGPEncryptionNegotiator passwordBasedEncryptionNegotiator = new OpenPGPEncryptionNegotiator(){

        @Override
        public MessageEncryptionMechanism negotiateEncryption(OpenPGPMessageGenerator configuration) {
            return MessageEncryptionMechanism.aead(9, 2);
        }
    };
    private OpenPGPEncryptionNegotiator publicKeyBasedEncryptionNegotiator = new OpenPGPEncryptionNegotiator(){

        @Override
        public MessageEncryptionMechanism negotiateEncryption(OpenPGPMessageGenerator configuration) {
            ArrayList<OpenPGPCertificate> certificates = new ArrayList<OpenPGPCertificate>();
            HashSet<OpenPGPCertificate> uniqueCertificates = new HashSet<OpenPGPCertificate>();
            Iterator it = OpenPGPMessageGenerator.this.encryptionKeys.iterator();
            while (it.hasNext()) {
                OpenPGPCertificate cert = ((OpenPGPCertificate.OpenPGPComponentKey)it.next()).getCertificate();
                if (!uniqueCertificates.add(cert)) continue;
                certificates.add(cert);
            }
            if (OpenPGPEncryptionNegotiator.allRecipientsSupportSeipd2(certificates)) {
                PreferredAEADCiphersuites commonDenominator = OpenPGPEncryptionNegotiator.negotiateAEADCiphersuite(certificates, OpenPGPMessageGenerator.this.policy);
                return MessageEncryptionMechanism.aead(commonDenominator.getAlgorithms()[0]);
            }
            if (OpenPGPEncryptionNegotiator.allRecipientsSupportLibrePGPOED(certificates)) {
                return MessageEncryptionMechanism.librePgp(OpenPGPEncryptionNegotiator.bestOEDEncryptionModeByWeight(certificates, OpenPGPMessageGenerator.this.policy));
            }
            return MessageEncryptionMechanism.integrityProtected(OpenPGPEncryptionNegotiator.bestSymmetricKeyAlgorithmByWeight(certificates, OpenPGPMessageGenerator.this.policy));
        }
    };
    private final OpenPGPEncryptionNegotiator encryptionNegotiator = new OpenPGPEncryptionNegotiator(){

        @Override
        public MessageEncryptionMechanism negotiateEncryption(OpenPGPMessageGenerator configuration) {
            if (OpenPGPMessageGenerator.this.encryptionKeys.isEmpty() && OpenPGPMessageGenerator.this.messagePassphrases.isEmpty()) {
                return MessageEncryptionMechanism.unencrypted();
            }
            if (OpenPGPMessageGenerator.this.encryptionKeys.isEmpty()) {
                return OpenPGPMessageGenerator.this.passwordBasedEncryptionNegotiator.negotiateEncryption(configuration);
            }
            return OpenPGPMessageGenerator.this.publicKeyBasedEncryptionNegotiator.negotiateEncryption(configuration);
        }
    };
    private CompressionNegotiator compressionNegotiator = new CompressionNegotiator(){

        @Override
        public int negotiateCompression(OpenPGPMessageGenerator configuration, OpenPGPPolicy policy) {
            return 0;
        }
    };

    public OpenPGPMessageGenerator() {
        this(OpenPGPImplementation.getInstance());
    }

    public OpenPGPMessageGenerator(OpenPGPImplementation implementation) {
        this(implementation, implementation.policy());
    }

    public OpenPGPMessageGenerator(OpenPGPImplementation implementation, OpenPGPPolicy policy) {
        super(implementation, policy);
    }

    public OpenPGPMessageGenerator addEncryptionCertificate(OpenPGPCertificate recipientCertificate) throws InvalidEncryptionKeyException {
        return this.addEncryptionCertificate(recipientCertificate, this.encryptionKeySelector);
    }

    public OpenPGPMessageGenerator addEncryptionCertificate(OpenPGPCertificate recipientCertificate, SubkeySelector subkeySelector) throws InvalidEncryptionKeyException {
        List<OpenPGPCertificate.OpenPGPComponentKey> subkeys = subkeySelector.select(recipientCertificate, this.policy);
        if (subkeys.isEmpty()) {
            throw new InvalidEncryptionKeyException(recipientCertificate);
        }
        this.encryptionKeys.addAll(subkeys);
        return this;
    }

    public OpenPGPMessageGenerator addEncryptionCertificate(OpenPGPCertificate.OpenPGPComponentKey encryptionKey) throws InvalidEncryptionKeyException {
        if (!encryptionKey.isEncryptionKey()) {
            throw new InvalidEncryptionKeyException(encryptionKey);
        }
        this.encryptionKeys.add(encryptionKey);
        return this;
    }

    public OpenPGPMessageGenerator addEncryptionPassphrase(char[] passphrase) {
        this.messagePassphrases.add(passphrase);
        return this;
    }

    public OpenPGPMessageGenerator setArmored(boolean armored) {
        this.isArmored = armored;
        return this;
    }

    public OpenPGPMessageGenerator setAllowPadding(boolean allowPadding) {
        this.isAllowPadding = allowPadding;
        return this;
    }

    public OpenPGPMessageGenerator setFileMetadata(File file) {
        this.filename = file.getName();
        this.fileModificationDate = new Date(file.lastModified());
        this.format = (char)98;
        return this;
    }

    public OpenPGPMessageGenerator setSessionKeyExtractionCallback(PGPEncryptedDataGenerator.SessionKeyExtractionCallback callback) {
        this.sessionKeyExtractionCallback = callback;
        return this;
    }

    public OpenPGPMessageOutputStream open(OutputStream out) throws PGPException, IOException {
        OpenPGPMessageOutputStream.Builder streamBuilder = OpenPGPMessageOutputStream.builder();
        this.applyOptionalAsciiArmor(streamBuilder);
        this.applyOptionalEncryption(streamBuilder, this.sessionKeyExtractionCallback);
        this.applySignatures(streamBuilder);
        this.applyOptionalCompression(streamBuilder);
        this.applyLiteralDataWrap(streamBuilder);
        return streamBuilder.build(out);
    }

    private void applyOptionalAsciiArmor(OpenPGPMessageOutputStream.Builder builder) {
        if (this.isArmored) {
            builder.armor(this.armorStreamFactory);
        }
    }

    private void applyOptionalEncryption(OpenPGPMessageOutputStream.Builder builder, PGPEncryptedDataGenerator.SessionKeyExtractionCallback sessionKeyExtractionCallback) {
        MessageEncryptionMechanism encryption = this.encryptionNegotiator.negotiateEncryption(this);
        if (!encryption.isEncrypted()) {
            return;
        }
        PGPDataEncryptorBuilder encBuilder = this.implementation.pgpDataEncryptorBuilder(encryption.getSymmetricKeyAlgorithm());
        switch (encryption.getMode()) {
            case SEIPDv1: {
                encBuilder.setWithIntegrityPacket(true);
                break;
            }
            case SEIPDv2: {
                encBuilder.setWithAEAD(encryption.getAeadAlgorithm(), 6);
                encBuilder.setUseV6AEAD();
                break;
            }
            case LIBREPGP_OED: {
                encBuilder.setWithAEAD(encryption.getAeadAlgorithm(), 6);
                encBuilder.setUseV5AEAD();
            }
        }
        final PGPEncryptedDataGenerator encGen = new PGPEncryptedDataGenerator(encBuilder);
        encGen.setForceSessionKey(true);
        encGen.setSessionKeyExtractionCallback(sessionKeyExtractionCallback);
        for (OpenPGPCertificate.OpenPGPComponentKey encryptionSubkey : this.encryptionKeys) {
            PublicKeyKeyEncryptionMethodGenerator method = this.implementation.publicKeyKeyEncryptionMethodGenerator(encryptionSubkey.getPGPPublicKey());
            encGen.addMethod(method);
        }
        block10: for (char[] passphrase : this.messagePassphrases) {
            PBEKeyEncryptionMethodGenerator skeskGen;
            switch (encryption.getMode()) {
                case SEIPDv1: 
                case LIBREPGP_OED: {
                    skeskGen = this.implementation.pbeKeyEncryptionMethodGenerator(passphrase);
                    break;
                }
                case SEIPDv2: {
                    skeskGen = this.implementation.pbeKeyEncryptionMethodGenerator(passphrase, S2K.Argon2Params.memoryConstrainedParameters());
                    break;
                }
                default: {
                    continue block10;
                }
            }
            skeskGen.setSecureRandom(CryptoServicesRegistrar.getSecureRandom());
            encGen.addMethod(skeskGen);
        }
        builder.encrypt(new OpenPGPMessageOutputStream.OutputStreamFactory(){

            @Override
            public OutputStream get(OutputStream o) throws PGPException, IOException {
                try {
                    return encGen.open(o, new byte[1024]);
                }
                catch (IOException e) {
                    throw new PGPException("Could not open encryptor OutputStream", e);
                }
            }
        });
        if (encryption.getMode() == EncryptedDataPacketType.SEIPDv2 && this.isAllowPadding) {
            builder.padding(new OpenPGPMessageOutputStream.OutputStreamFactory(){

                @Override
                public OutputStream get(OutputStream o) {
                    return new OpenPGPMessageOutputStream.PaddingPacketAppenderOutputStream(o, new OpenPGPMessageOutputStream.PaddingPacketFactory(){

                        @Override
                        public PGPPadding providePaddingPacket() {
                            return new PGPPadding();
                        }
                    });
                }
            });
        }
    }

    private void applySignatures(OpenPGPMessageOutputStream.Builder builder) {
        builder.sign(new OpenPGPMessageOutputStream.OutputStreamFactory(){

            @Override
            public OutputStream get(OutputStream o) throws PGPException, IOException {
                OpenPGPMessageGenerator.this.addSignToGenerator();
                Iterator sigGens = OpenPGPMessageGenerator.this.signatureGenerators.iterator();
                while (sigGens.hasNext()) {
                    PGPSignatureGenerator gen = (PGPSignatureGenerator)sigGens.next();
                    PGPOnePassSignature ops = gen.generateOnePassVersion(sigGens.hasNext());
                    ops.encode(o);
                }
                return new OpenPGPMessageOutputStream.SignatureGeneratorOutputStream(o, OpenPGPMessageGenerator.this.signatureGenerators);
            }
        });
    }

    private void applyOptionalCompression(OpenPGPMessageOutputStream.Builder builder) {
        int compressionAlgorithm = this.compressionNegotiator.negotiateCompression(this, this.policy);
        if (compressionAlgorithm == 0) {
            return;
        }
        final PGPCompressedDataGenerator compGen = new PGPCompressedDataGenerator(compressionAlgorithm);
        builder.compress(new OpenPGPMessageOutputStream.OutputStreamFactory(){

            @Override
            public OutputStream get(OutputStream o) throws PGPException, IOException {
                try {
                    return compGen.open(o, new byte[1024]);
                }
                catch (IOException e) {
                    throw new PGPException("Could not apply compression", e);
                }
            }
        });
    }

    private void applyLiteralDataWrap(OpenPGPMessageOutputStream.Builder builder) {
        final PGPLiteralDataGenerator litGen = new PGPLiteralDataGenerator();
        builder.literalData(new OpenPGPMessageOutputStream.OutputStreamFactory(){

            @Override
            public OutputStream get(OutputStream o) throws PGPException, IOException {
                try {
                    return litGen.open(o, OpenPGPMessageGenerator.this.format, OpenPGPMessageGenerator.this.filename != null ? OpenPGPMessageGenerator.this.filename : "", OpenPGPMessageGenerator.this.fileModificationDate != null ? OpenPGPMessageGenerator.this.fileModificationDate : PGPLiteralData.NOW, new byte[1024]);
                }
                catch (IOException e) {
                    throw new PGPException("Could not apply literal data wrapping", e);
                }
            }
        });
    }

    public OpenPGPMessageGenerator setPasswordBasedEncryptionNegotiator(OpenPGPEncryptionNegotiator pbeNegotiator) {
        if (pbeNegotiator == null) {
            throw new NullPointerException();
        }
        this.passwordBasedEncryptionNegotiator = pbeNegotiator;
        return this;
    }

    public OpenPGPMessageGenerator setPublicKeyBasedEncryptionNegotiator(OpenPGPEncryptionNegotiator pkbeNegotiator) {
        if (pkbeNegotiator == null) {
            throw new NullPointerException();
        }
        this.publicKeyBasedEncryptionNegotiator = pkbeNegotiator;
        return this;
    }

    public OpenPGPMessageGenerator setEncryptionKeySelector(SubkeySelector encryptionKeySelector) {
        if (encryptionKeySelector == null) {
            throw new NullPointerException();
        }
        this.encryptionKeySelector = encryptionKeySelector;
        return this;
    }

    public OpenPGPMessageGenerator setCompressionNegotiator(CompressionNegotiator compressionNegotiator) {
        if (compressionNegotiator == null) {
            throw new NullPointerException();
        }
        this.compressionNegotiator = compressionNegotiator;
        return this;
    }

    public OpenPGPMessageGenerator setArmorStreamFactory(ArmoredOutputStreamFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        this.armorStreamFactory = factory;
        return this;
    }

    public static interface ArmoredOutputStreamFactory
    extends OpenPGPMessageOutputStream.OutputStreamFactory {
        @Override
        public ArmoredOutputStream get(OutputStream var1);
    }

    public static interface CompressionNegotiator {
        public int negotiateCompression(OpenPGPMessageGenerator var1, OpenPGPPolicy var2);
    }
}

