/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.SymmetricEncDataPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;

public enum EncryptedDataPacketType {
    SED,
    SEIPDv1,
    SEIPDv2,
    LIBREPGP_OED;


    public static EncryptedDataPacketType of(PGPEncryptedDataList encDataList) throws PGPException {
        return EncryptedDataPacketType.of(encDataList.getEncryptedData());
    }

    public static EncryptedDataPacketType of(InputStreamPacket encData) throws PGPException {
        if (encData instanceof SymmetricEncIntegrityPacket) {
            SymmetricEncIntegrityPacket seipd = (SymmetricEncIntegrityPacket)encData;
            if (seipd.getVersion() == 1) {
                return SEIPDv1;
            }
            if (seipd.getVersion() == 2) {
                return SEIPDv2;
            }
            throw new UnsupportedPacketVersionException("Symmetrically-Encrypted Integrity-Protected Data Packet of unknown version encountered: " + seipd.getVersion());
        }
        if (encData instanceof AEADEncDataPacket) {
            return LIBREPGP_OED;
        }
        if (encData instanceof SymmetricEncDataPacket) {
            return SED;
        }
        throw new PGPException("Unexpected packet type: " + encData.getClass().getName());
    }
}

