/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg.sig;

import org.bouncycastle.bcpg.FingerprintUtil;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.util.Arrays;

public class IssuerFingerprint
extends SignatureSubpacket {
    public IssuerFingerprint(boolean critical, boolean isLongLength, byte[] data) {
        super(33, critical, isLongLength, IssuerFingerprint.verifyData(data));
    }

    public IssuerFingerprint(boolean critical, int keyVersion, byte[] fingerprint) {
        super(33, critical, false, Arrays.prepend((byte[])fingerprint, (byte)((byte)keyVersion)));
    }

    private static byte[] verifyData(byte[] data) {
        if (data.length < 1) {
            throw new IllegalArgumentException("Data too short. Expect at least one octet of key version.");
        }
        return data;
    }

    public int getKeyVersion() {
        return this.data[0] & 0xFF;
    }

    public byte[] getFingerprint() {
        return Arrays.copyOfRange((byte[])this.data, (int)1, (int)this.data.length);
    }

    public long getKeyID() {
        if (this.getKeyVersion() == 4) {
            return FingerprintUtil.keyIdFromV4Fingerprint(this.getFingerprint());
        }
        if (this.getKeyVersion() == 5) {
            return FingerprintUtil.keyIdFromLibrePgpFingerprint(this.getFingerprint());
        }
        if (this.getKeyVersion() == 6) {
            return FingerprintUtil.keyIdFromV6Fingerprint(this.getFingerprint());
        }
        return 0L;
    }

    public KeyIdentifier getKeyIdentifier() {
        return new KeyIdentifier(this.getFingerprint());
    }
}

