/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.Provider;
import java.security.SecureRandom;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;

public class JcaPGPContentSignerBuilderProvider
extends PGPContentSignerBuilderProvider {
    private Provider digestProvider;
    private Provider securityProvider;
    private SecureRandom secureRandom;

    public JcaPGPContentSignerBuilderProvider(int hashAlgorithmId) {
        super(hashAlgorithmId);
    }

    public JcaPGPContentSignerBuilderProvider setDigestProvider(Provider provider) {
        this.digestProvider = provider;
        return this;
    }

    public JcaPGPContentSignerBuilderProvider setSecurityProvider(Provider provider) {
        this.securityProvider = provider;
        return this;
    }

    public JcaPGPContentSignerBuilderProvider setSecureRandom(SecureRandom random) {
        this.secureRandom = random;
        return this;
    }

    @Override
    public PGPContentSignerBuilder get(PGPPublicKey signingKey) {
        JcaPGPContentSignerBuilder builder = new JcaPGPContentSignerBuilder(signingKey.getAlgorithm(), this.hashAlgorithmId);
        if (this.digestProvider != null) {
            builder.setDigestProvider(this.digestProvider);
        }
        if (this.securityProvider != null) {
            builder.setProvider(this.securityProvider);
        }
        if (this.secureRandom != null) {
            builder.setSecureRandom(this.secureRandom);
        }
        return builder;
    }
}

