/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api.exception;

import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.exception.OpenPGPKeyException;

public class KeyPassphraseException
extends OpenPGPKeyException {
    private final Exception cause;

    public KeyPassphraseException(OpenPGPCertificate.OpenPGPComponentKey key, Exception cause) {
        super(key, KeyPassphraseException.componentKeyErrorMessage(key, cause));
        this.cause = cause;
    }

    private static String componentKeyErrorMessage(OpenPGPCertificate.OpenPGPComponentKey key, Exception cause) {
        if (key.getKeyIdentifier().equals(key.getCertificate().getKeyIdentifier())) {
            return "Cannot unlock primary key " + key.getKeyIdentifier() + ": " + cause.getMessage();
        }
        return "Cannot unlock subkey " + key.getKeyIdentifier() + " from key " + key.getCertificate().getKeyIdentifier() + ": " + cause.getMessage();
    }

    @Override
    public Exception getCause() {
        return this.cause;
    }
}

