/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.bcpg.PublicKeyUtils;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.api.AbstractOpenPGPKeySignatureGenerator;
import org.bouncycastle.openpgp.api.KeyPairGeneratorCallback;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.api.SignatureParameters;
import org.bouncycastle.openpgp.api.SignatureSubpacketsFunction;
import org.bouncycastle.openpgp.api.Utils;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PGPKeyPairGenerator;
import org.bouncycastle.openpgp.operator.PGPKeyPairGeneratorProvider;
import org.bouncycastle.util.Arrays;

public class OpenPGPKeyGenerator
extends AbstractOpenPGPKeySignatureGenerator {
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_DAY = 86400L;
    private static final long SECONDS_PER_YEAR = 31536000L;
    private final int keyVersion;
    private final OpenPGPImplementation implementationProvider;
    private final Configuration configuration;

    public OpenPGPKeyGenerator(OpenPGPImplementation implementation, boolean aead, Date creationTime) throws PGPException {
        this(implementation, 6, aead, creationTime);
    }

    public OpenPGPKeyGenerator(OpenPGPImplementation implementationProvider, int version, boolean aead, Date creationTime) throws PGPException {
        this(implementationProvider, version, implementationProvider.pgpKeyPairGeneratorProvider(), implementationProvider.pgpDigestCalculatorProvider(), implementationProvider.pbeSecretKeyEncryptorFactory(aead), implementationProvider.keyFingerPrintCalculator(), creationTime);
    }

    public OpenPGPKeyGenerator(OpenPGPImplementation implementationProvider, int keyVersion, PGPKeyPairGeneratorProvider kpGenProvider, PGPDigestCalculatorProvider digestCalculatorProvider, PBESecretKeyEncryptorFactory keyEncryptionBuilderProvider, KeyFingerPrintCalculator keyFingerPrintCalculator, Date creationTime) {
        if (keyVersion != 4 && keyVersion != 5 && keyVersion != 6) {
            throw new IllegalArgumentException("Generating keys of version " + keyVersion + " is not supported.");
        }
        this.implementationProvider = implementationProvider;
        this.keyVersion = keyVersion;
        this.configuration = new Configuration(creationTime, kpGenProvider, digestCalculatorProvider, keyEncryptionBuilderProvider, keyFingerPrintCalculator);
    }

    public WithPrimaryKey classicKey(String userId) throws PGPException {
        WithPrimaryKey builder = this.withPrimaryKey().addSigningSubkey().addEncryptionSubkey();
        if (userId != null) {
            builder.addUserId(userId);
        }
        return builder;
    }

    public WithPrimaryKey ed25519x25519Key(String userId) throws PGPException {
        WithPrimaryKey builder = this.withPrimaryKey(new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator generator) throws PGPException {
                return generator.generateEd25519KeyPair();
            }
        }).addSigningSubkey(new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator generator) throws PGPException {
                return generator.generateEd25519KeyPair();
            }
        }).addEncryptionSubkey(new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator generator) throws PGPException {
                return generator.generateX25519KeyPair();
            }
        });
        if (userId != null) {
            builder.addUserId(userId);
        }
        return builder;
    }

    public WithPrimaryKey ed448x448Key(String userId) throws PGPException {
        WithPrimaryKey builder = this.withPrimaryKey(new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator generator) throws PGPException {
                return generator.generateEd448KeyPair();
            }
        }).addSigningSubkey(new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator generator) throws PGPException {
                return generator.generateEd448KeyPair();
            }
        }).addEncryptionSubkey(new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator generator) throws PGPException {
                return generator.generateX448KeyPair();
            }
        });
        if (userId != null) {
            builder.addUserId(userId);
        }
        return builder;
    }

    public WithPrimaryKey signOnlyKey() throws PGPException {
        return this.withPrimaryKey(KeyPairGeneratorCallback.primaryKey(), SignatureParameters.Callback.Util.modifyHashedSubpackets(new SignatureSubpacketsFunction(){

            @Override
            public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator subpackets) {
                subpackets.removePacketsOfType(27);
                subpackets.setKeyFlags(true, 3);
                return subpackets;
            }
        }));
    }

    public WithPrimaryKey withPrimaryKey() throws PGPException {
        return this.withPrimaryKey(KeyPairGeneratorCallback.primaryKey());
    }

    public WithPrimaryKey withPrimaryKey(KeyPairGeneratorCallback keyGenCallback) throws PGPException {
        return this.withPrimaryKey(keyGenCallback, null);
    }

    public WithPrimaryKey withPrimaryKey(KeyPairGeneratorCallback keyGenCallback, SignatureParameters.Callback preferenceSignatureCallback) throws PGPException {
        PGPKeyPair primaryKeyPair = keyGenCallback.generateFrom(this.configuration.kpGenProvider.get(this.keyVersion, this.configuration.keyCreationTime));
        if (primaryKeyPair.getPublicKey().getPublicKeyPacket() instanceof PublicSubkeyPacket) {
            throw new IllegalArgumentException("Primary key MUST NOT consist of subkey packet.");
        }
        if (!PublicKeyUtils.isSigningAlgorithm(primaryKeyPair.getPublicKey().getAlgorithm())) {
            throw new PGPException("Primary key MUST use signing-capable algorithm.");
        }
        SignatureParameters parameters = Utils.applySignatureParameters(preferenceSignatureCallback, SignatureParameters.directKeySignature(this.implementationProvider.policy()));
        if (parameters != null) {
            PGPSignatureGenerator preferenceSigGen = Utils.getPgpSignatureGenerator(this.implementationProvider, primaryKeyPair.getPublicKey(), primaryKeyPair.getPrivateKey(), parameters, this.configuration.keyCreationTime, new Utils.HashedSubpacketsOperation(){

                @Override
                public void operate(PGPSignatureSubpacketGenerator hashedSubpackets) throws PGPException {
                    hashedSubpackets = OpenPGPKeyGenerator.this.directKeySignatureSubpackets.apply(hashedSubpackets);
                    hashedSubpackets.setKeyFlags(true, 1);
                    hashedSubpackets.setKeyExpirationTime(false, 157680000L);
                }
            });
            primaryKeyPair = new PGPKeyPair(Utils.injectCertification(primaryKeyPair.getPublicKey(), preferenceSigGen), primaryKeyPair.getPrivateKey());
        }
        return new WithPrimaryKey(this.implementationProvider, this.configuration, primaryKeyPair);
    }

    private static class Configuration {
        final Date keyCreationTime;
        final PGPKeyPairGeneratorProvider kpGenProvider;
        final PGPDigestCalculatorProvider digestCalculatorProvider;
        final PBESecretKeyEncryptorFactory keyEncryptorBuilderProvider;
        final KeyFingerPrintCalculator keyFingerprintCalculator;

        public Configuration(Date keyCreationTime, PGPKeyPairGeneratorProvider keyPairGeneratorProvider, PGPDigestCalculatorProvider digestCalculatorProvider, PBESecretKeyEncryptorFactory keyEncryptorBuilderProvider, KeyFingerPrintCalculator keyFingerPrintCalculator) {
            this.keyCreationTime = new Date(keyCreationTime.getTime() / 1000L * 1000L);
            this.kpGenProvider = keyPairGeneratorProvider;
            this.digestCalculatorProvider = digestCalculatorProvider;
            this.keyEncryptorBuilderProvider = keyEncryptorBuilderProvider;
            this.keyFingerprintCalculator = keyFingerPrintCalculator;
        }
    }

    public class WithPrimaryKey {
        private final OpenPGPImplementation implementation;
        private final Configuration configuration;
        private PGPKeyPair primaryKey;
        private final List<PGPKeyPair> subkeys = new ArrayList<PGPKeyPair>();

        private WithPrimaryKey(OpenPGPImplementation implementation, Configuration configuration, PGPKeyPair primaryKey) {
            this.implementation = implementation;
            this.configuration = configuration;
            this.primaryKey = primaryKey;
        }

        public WithPrimaryKey addUserId(String userId) throws PGPException {
            return this.addUserId(userId, null);
        }

        public WithPrimaryKey addUserId(String userId, SignatureParameters.Callback signatureParameters) throws PGPException {
            if (userId == null || userId.trim().length() == 0) {
                throw new IllegalArgumentException("User-ID cannot be null or empty.");
            }
            SignatureParameters parameters = Utils.applySignatureParameters(signatureParameters, SignatureParameters.certification(this.implementation.policy()));
            if (parameters != null) {
                PGPSignatureGenerator uidSigGen = Utils.getPgpSignatureGenerator(this.implementation, this.primaryKey.getPublicKey(), this.primaryKey.getPrivateKey(), parameters, this.configuration.keyCreationTime, null);
                this.primaryKey = new PGPKeyPair(Utils.injectCertification(userId, this.primaryKey.getPublicKey(), uidSigGen), this.primaryKey.getPrivateKey());
            }
            return this;
        }

        public WithPrimaryKey addEncryptionSubkey() throws PGPException {
            return this.addEncryptionSubkey(KeyPairGeneratorCallback.encryptionKey());
        }

        public WithPrimaryKey addEncryptionSubkey(KeyPairGeneratorCallback keyGenCallback) throws PGPException {
            return this.addEncryptionSubkey(keyGenCallback, null);
        }

        public WithPrimaryKey addEncryptionSubkey(KeyPairGeneratorCallback generatorCallback, SignatureParameters.Callback bindingSubpacketsCallback) throws PGPException {
            PGPKeyPairGenerator generator = this.configuration.kpGenProvider.get(OpenPGPKeyGenerator.this.keyVersion, this.configuration.keyCreationTime);
            PGPKeyPair subkey = generatorCallback.generateFrom(generator);
            subkey = subkey.asSubkey(this.implementation.keyFingerPrintCalculator());
            return this.addEncryptionSubkey(subkey, bindingSubpacketsCallback);
        }

        public WithPrimaryKey addEncryptionSubkey(PGPKeyPair encryptionSubkey, SignatureParameters.Callback bindingSubpacketsCallback) throws PGPException {
            if (!(encryptionSubkey.getPublicKey().getPublicKeyPacket() instanceof PublicSubkeyPacket)) {
                throw new IllegalArgumentException("Encryption subkey MUST NOT consist of a primary key packet.");
            }
            if (!encryptionSubkey.getPublicKey().isEncryptionKey()) {
                throw new PGPException("Encryption key MUST use encryption-capable algorithm.");
            }
            encryptionSubkey = this.updateSubkey(encryptionSubkey, bindingSubpacketsCallback, new Utils.HashedSubpacketsOperation(){

                @Override
                public void operate(PGPSignatureSubpacketGenerator hashedSubpackets) throws PGPException {
                    hashedSubpackets = OpenPGPKeyGenerator.this.encryptionSubkeySubpackets.apply(hashedSubpackets);
                }
            });
            this.subkeys.add(encryptionSubkey);
            return this;
        }

        public WithPrimaryKey addSigningSubkey() throws PGPException {
            return this.addSigningSubkey(KeyPairGeneratorCallback.signingKey());
        }

        public WithPrimaryKey addSigningSubkey(KeyPairGeneratorCallback keyGenCallback) throws PGPException {
            return this.addSigningSubkey(keyGenCallback, null, null);
        }

        public WithPrimaryKey addSigningSubkey(KeyPairGeneratorCallback keyGenCallback, SignatureParameters.Callback bindingSignatureCallback, SignatureParameters.Callback backSignatureCallback) throws PGPException {
            PGPKeyPair subkey = keyGenCallback.generateFrom(this.configuration.kpGenProvider.get(OpenPGPKeyGenerator.this.keyVersion, this.configuration.keyCreationTime));
            subkey = subkey.asSubkey(this.configuration.keyFingerprintCalculator);
            return this.addSigningSubkey(subkey, bindingSignatureCallback, backSignatureCallback);
        }

        public WithPrimaryKey addSigningSubkey(PGPKeyPair signingSubkey, SignatureParameters.Callback bindingSignatureCallback, SignatureParameters.Callback backSignatureCallback) throws PGPException {
            if (!(signingSubkey.getPublicKey().getPublicKeyPacket() instanceof PublicSubkeyPacket)) {
                throw new IllegalArgumentException("Signing subkey MUST NOT consist of primary key packet.");
            }
            if (!PublicKeyUtils.isSigningAlgorithm(signingSubkey.getPublicKey().getAlgorithm())) {
                throw new PGPException("Signing key MUST use signing-capable algorithm.");
            }
            SignatureParameters parameters = Utils.applySignatureParameters(backSignatureCallback, SignatureParameters.primaryKeyBinding(this.implementation.policy()));
            final PGPSignature backSig = Utils.getBackSignature(signingSubkey, parameters, this.primaryKey.getPublicKey(), this.implementation, this.configuration.keyCreationTime);
            signingSubkey = this.updateSubkey(signingSubkey, bindingSignatureCallback, new Utils.HashedSubpacketsOperation(){

                @Override
                public void operate(PGPSignatureSubpacketGenerator hashedSubpackets) throws PGPException {
                    hashedSubpackets = OpenPGPKeyGenerator.this.signingSubkeySubpackets.apply(hashedSubpackets);
                    Utils.addEmbeddedSiganture(backSig, hashedSubpackets);
                }
            });
            this.subkeys.add(signingSubkey);
            return this;
        }

        public OpenPGPKey build() throws PGPException {
            return this.build(null);
        }

        public OpenPGPKey build(char[] passphrase) throws PGPException {
            PBESecretKeyEncryptor primaryKeyEncryptor = this.configuration.keyEncryptorBuilderProvider.build(passphrase, this.primaryKey.getPublicKey().getPublicKeyPacket());
            PGPSecretKey primarySecretKey = new PGPSecretKey(this.primaryKey.getPrivateKey(), this.primaryKey.getPublicKey(), this.configuration.digestCalculatorProvider.get(2), true, primaryKeyEncryptor);
            this.sanitizeKeyEncryptor(primaryKeyEncryptor);
            ArrayList<PGPSecretKey> keys = new ArrayList<PGPSecretKey>();
            keys.add(primarySecretKey);
            for (PGPKeyPair key : this.subkeys) {
                PBESecretKeyEncryptor subkeyEncryptor = this.configuration.keyEncryptorBuilderProvider.build(passphrase, key.getPublicKey().getPublicKeyPacket());
                PGPSecretKey subkey = new PGPSecretKey(key.getPrivateKey(), key.getPublicKey(), this.configuration.digestCalculatorProvider.get(2), false, subkeyEncryptor);
                this.sanitizeKeyEncryptor(subkeyEncryptor);
                keys.add(subkey);
            }
            if (passphrase != null) {
                Arrays.fill((char[])passphrase, (char)'\u0000');
            }
            PGPSecretKeyRing secretKeys = new PGPSecretKeyRing(keys);
            return new OpenPGPKey(secretKeys, this.implementation);
        }

        protected void sanitizeKeyEncryptor(PBESecretKeyEncryptor keyEncryptor) {
            if (keyEncryptor == null) {
                return;
            }
            S2K s2k = keyEncryptor.getS2K();
            if (s2k.getType() == 0 || s2k.getType() == 1) {
                throw new IllegalArgumentException("S2K specifiers SIMPLE and SALTED are not allowed for secret key encryption.");
            }
            if (s2k.getType() == 4 && keyEncryptor.getAeadAlgorithm() == 0) {
                throw new IllegalArgumentException("Argon2 MUST be used with AEAD.");
            }
        }

        private PGPKeyPair updateSubkey(PGPKeyPair subkey, SignatureParameters.Callback bindingSubpacketsCallback, Utils.HashedSubpacketsOperation operation) throws PGPException {
            SignatureParameters parameters = Utils.applySignatureParameters(bindingSubpacketsCallback, SignatureParameters.subkeyBinding(this.implementation.policy()).setSignatureCreationTime(this.configuration.keyCreationTime));
            if (parameters != null) {
                PGPSignatureGenerator bindingSigGen = Utils.getPgpSignatureGenerator(this.implementation, this.primaryKey.getPublicKey(), this.primaryKey.getPrivateKey(), parameters, parameters.getSignatureCreationTime(), operation);
                PGPPublicKey publicSubkey = Utils.injectCertification(subkey.getPublicKey(), bindingSigGen, this.primaryKey.getPublicKey());
                subkey = new PGPKeyPair(publicSubkey, subkey.getPrivateKey());
            }
            return subkey;
        }
    }
}

