/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.api.AbstractOpenPGPDocumentSignatureGenerator;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.OpenPGPSignature;

public class OpenPGPDetachedSignatureGenerator
extends AbstractOpenPGPDocumentSignatureGenerator<OpenPGPDetachedSignatureGenerator> {
    public OpenPGPDetachedSignatureGenerator() {
        this(OpenPGPImplementation.getInstance());
    }

    public OpenPGPDetachedSignatureGenerator(OpenPGPImplementation implementation) {
        this(implementation, implementation.policy());
    }

    public OpenPGPDetachedSignatureGenerator(OpenPGPImplementation implementation, OpenPGPPolicy policy) {
        super(implementation, policy);
    }

    public List<OpenPGPSignature.OpenPGPDocumentSignature> sign(InputStream inputStream) throws IOException, PGPException {
        int r;
        this.addSignToGenerator();
        byte[] buf = new byte[2048];
        while ((r = inputStream.read(buf)) != -1) {
            Iterator it = this.signatureGenerators.iterator();
            while (it.hasNext()) {
                ((PGPSignatureGenerator)it.next()).update(buf, 0, r);
            }
        }
        ArrayList<OpenPGPSignature.OpenPGPDocumentSignature> documentSignatures = new ArrayList<OpenPGPSignature.OpenPGPDocumentSignature>();
        for (int i = 0; i < this.signatureGenerators.size(); ++i) {
            PGPSignatureGenerator sigGen = (PGPSignatureGenerator)this.signatureGenerators.get(i);
            PGPSignature signature = sigGen.generate();
            OpenPGPSignature.OpenPGPDocumentSignature docSig = new OpenPGPSignature.OpenPGPDocumentSignature(signature, (OpenPGPCertificate.OpenPGPComponentKey)this.signingKeys.get(i));
            documentSignatures.add(docSig);
        }
        return documentSignatures;
    }
}

