/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.operator.PGPKeyPairGenerator;

public abstract class KeyPairGeneratorCallback {
    public abstract PGPKeyPair generateFrom(PGPKeyPairGenerator var1) throws PGPException;

    public static KeyPairGeneratorCallback primaryKey() {
        return new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator generator) throws PGPException {
                return generator.generatePrimaryKey();
            }
        };
    }

    public static KeyPairGeneratorCallback encryptionKey() {
        return new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator generator) throws PGPException {
                return generator.generateEncryptionSubkey();
            }
        };
    }

    public static KeyPairGeneratorCallback signingKey() {
        return new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator generator) throws PGPException {
                return generator.generateSigningSubkey();
            }
        };
    }
}

