/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import org.bouncycastle.bcpg.sig.PreferredAEADCiphersuites;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.api.SignatureSubpacketsFunction;

public abstract class AbstractOpenPGPKeySignatureGenerator {
    protected SignatureSubpacketsFunction defaultAeadAlgorithmPreferences = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator subpackets) {
            subpackets.removePacketsOfType(39);
            subpackets.setPreferredAEADCiphersuites(PreferredAEADCiphersuites.builder(false).addCombination(9, 2).addCombination(8, 2).addCombination(7, 2));
            return subpackets;
        }
    };
    protected SignatureSubpacketsFunction defaultSymmetricKeyPreferences = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator subpackets) {
            subpackets.removePacketsOfType(11);
            subpackets.setPreferredSymmetricAlgorithms(false, new int[]{9, 8, 7});
            return subpackets;
        }
    };
    protected SignatureSubpacketsFunction defaultHashAlgorithmPreferences = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator subpackets) {
            subpackets.removePacketsOfType(21);
            subpackets.setPreferredHashAlgorithms(false, new int[]{14, 12, 10, 9, 8});
            return subpackets;
        }
    };
    protected SignatureSubpacketsFunction defaultCompressionAlgorithmPreferences = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator subpackets) {
            subpackets.removePacketsOfType(22);
            subpackets.setPreferredCompressionAlgorithms(false, new int[]{0, 1, 2, 3});
            return subpackets;
        }
    };
    protected SignatureSubpacketsFunction defaultFeatures = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator subpackets) {
            subpackets.removePacketsOfType(30);
            subpackets.setFeature(false, (byte)9);
            return subpackets;
        }
    };
    protected SignatureSubpacketsFunction signingSubkeySubpackets = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator subpackets) {
            subpackets.removePacketsOfType(27);
            subpackets.setKeyFlags(true, 2);
            return subpackets;
        }
    };
    protected SignatureSubpacketsFunction encryptionSubkeySubpackets = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator subpackets) {
            subpackets.removePacketsOfType(27);
            subpackets.setKeyFlags(true, 12);
            return subpackets;
        }
    };
    protected SignatureSubpacketsFunction directKeySignatureSubpackets = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator subpackets) {
            subpackets = AbstractOpenPGPKeySignatureGenerator.this.defaultFeatures.apply(subpackets);
            subpackets = AbstractOpenPGPKeySignatureGenerator.this.defaultHashAlgorithmPreferences.apply(subpackets);
            subpackets = AbstractOpenPGPKeySignatureGenerator.this.defaultCompressionAlgorithmPreferences.apply(subpackets);
            subpackets = AbstractOpenPGPKeySignatureGenerator.this.defaultSymmetricKeyPreferences.apply(subpackets);
            subpackets = AbstractOpenPGPKeySignatureGenerator.this.defaultAeadAlgorithmPreferences.apply(subpackets);
            return subpackets;
        }
    };

    public void setDefaultAeadAlgorithmPreferences(SignatureSubpacketsFunction aeadAlgorithmPreferences) {
        this.defaultAeadAlgorithmPreferences = aeadAlgorithmPreferences;
    }

    public void setDefaultSymmetricKeyPreferences(SignatureSubpacketsFunction symmetricKeyPreferences) {
        this.defaultSymmetricKeyPreferences = symmetricKeyPreferences;
    }

    public void setDefaultHashAlgorithmPreferences(SignatureSubpacketsFunction hashAlgorithmPreferences) {
        this.defaultHashAlgorithmPreferences = hashAlgorithmPreferences;
    }

    public void setDefaultCompressionAlgorithmPreferences(SignatureSubpacketsFunction compressionAlgorithmPreferences) {
        this.defaultCompressionAlgorithmPreferences = compressionAlgorithmPreferences;
    }

    public void setDirectKeySignatureSubpackets(SignatureSubpacketsFunction directKeySignatureSubpackets) {
        this.directKeySignatureSubpackets = directKeySignatureSubpackets;
    }

    public void setDefaultFeatures(SignatureSubpacketsFunction features) {
        this.defaultFeatures = features;
    }

    public void setSigningSubkeySubpackets(SignatureSubpacketsFunction signingSubkeySubpackets) {
        this.signingSubkeySubpackets = signingSubkeySubpackets;
    }

    public void setEncryptionSubkeySubpackets(SignatureSubpacketsFunction encryptionSubkeySubpackets) {
        this.encryptionSubkeySubpackets = encryptionSubkeySubpackets;
    }
}

