/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADCipherUtil;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADUtil;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.Arrays;

public class JcaAEADSecretKeyEncryptorBuilder {
    private int aeadAlgorithm;
    private int symmetricAlgorithm;
    private S2K.Argon2Params argon2Params;
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private JceAEADUtil aeadUtil = new JceAEADUtil(this.helper);

    public JcaAEADSecretKeyEncryptorBuilder(int aeadAlgorithm, int symmetricAlgorithm, S2K.Argon2Params argon2Params) {
        this.aeadAlgorithm = aeadAlgorithm;
        this.symmetricAlgorithm = symmetricAlgorithm;
        this.argon2Params = argon2Params;
    }

    public JcaAEADSecretKeyEncryptorBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.aeadUtil = new JceAEADUtil(this.helper);
        return this;
    }

    public JcaAEADSecretKeyEncryptorBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        this.aeadUtil = new JceAEADUtil(this.helper);
        return this;
    }

    public PBESecretKeyEncryptor build(char[] passphrase, final PublicKeyPacket pubKey) {
        return new PBESecretKeyEncryptor(this.symmetricAlgorithm, this.aeadAlgorithm, this.argon2Params, new SecureRandom(), passphrase){
            private byte[] iv;
            {
                super(encAlgorithm, aeadAlgorithm, argon2Params, random, passPhrase);
                this.iv = new byte[AEADUtils.getIVLength(this.aeadAlgorithm)];
                this.random.nextBytes(this.iv);
            }

            @Override
            public byte[] encryptKeyData(byte[] key, byte[] keyData, int keyOff, int keyLen) throws PGPException {
                int packetTag = pubKey.getPacketTag() == 6 ? 5 : 7;
                byte[] hkdfInfo = new byte[]{(byte)(0xC0 | packetTag), (byte)pubKey.getVersion(), (byte)JcaAEADSecretKeyEncryptorBuilder.this.symmetricAlgorithm, (byte)this.aeadAlgorithm};
                HKDFParameters hkdfParameters = new HKDFParameters(this.getKey(), null, hkdfInfo);
                HKDFBytesGenerator hkdfGen = new HKDFBytesGenerator((Digest)new SHA256Digest());
                hkdfGen.init((DerivationParameters)hkdfParameters);
                key = new byte[SymmetricKeyUtils.getKeyLengthInOctets(this.encAlgorithm)];
                hkdfGen.generateBytes(key, 0, key.length);
                try {
                    byte[] aad = Arrays.prepend((byte[])pubKey.getEncodedContents(), (byte)((byte)(0xC0 | packetTag)));
                    SecretKeySpec secretKey = new SecretKeySpec(key, PGPUtil.getSymmetricCipherName(this.encAlgorithm));
                    Cipher c = JcaAEADSecretKeyEncryptorBuilder.this.aeadUtil.createAEADCipher(this.encAlgorithm, this.aeadAlgorithm);
                    JceAEADCipherUtil.setUpAeadCipher(c, secretKey, 1, this.iv, 128, aad);
                    byte[] data = c.doFinal(keyData, keyOff, keyLen);
                    return data;
                }
                catch (Exception e) {
                    throw new PGPException("Exception AEAD protecting private key material", e);
                }
            }

            @Override
            public byte[] getCipherIV() {
                return this.iv;
            }
        };
    }
}

