/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.util.Arrays;

public class BcAEADSecretKeyEncryptorBuilder {
    private int aeadAlgorithm;
    private int symmetricAlgorithm;
    private S2K.Argon2Params argon2Params;

    public BcAEADSecretKeyEncryptorBuilder(int aeadAlgorithm, int symmetricAlgorithm, S2K.Argon2Params argon2Params) {
        this.aeadAlgorithm = aeadAlgorithm;
        this.symmetricAlgorithm = symmetricAlgorithm;
        this.argon2Params = argon2Params;
    }

    public PBESecretKeyEncryptor build(char[] passphrase, final PublicKeyPacket pubKey) {
        return new PBESecretKeyEncryptor(this.symmetricAlgorithm, this.aeadAlgorithm, this.argon2Params, new SecureRandom(), passphrase){
            private byte[] iv;
            {
                super(encAlgorithm, aeadAlgorithm, argon2Params, random, passPhrase);
                this.iv = new byte[AEADUtils.getIVLength(this.aeadAlgorithm)];
                this.random.nextBytes(this.iv);
            }

            @Override
            public byte[] encryptKeyData(byte[] key, byte[] keyData, int keyOff, int keyLen) throws PGPException {
                int packetTag = pubKey.getPacketTag() == 6 ? 5 : 7;
                byte[] hkdfInfo = new byte[]{(byte)(0xC0 | packetTag), (byte)pubKey.getVersion(), (byte)BcAEADSecretKeyEncryptorBuilder.this.symmetricAlgorithm, (byte)this.aeadAlgorithm};
                HKDFParameters hkdfParameters = new HKDFParameters(this.getKey(), null, hkdfInfo);
                HKDFBytesGenerator hkdfGen = new HKDFBytesGenerator((Digest)new SHA256Digest());
                hkdfGen.init((DerivationParameters)hkdfParameters);
                key = new byte[SymmetricKeyUtils.getKeyLengthInOctets(this.encAlgorithm)];
                hkdfGen.generateBytes(key, 0, key.length);
                try {
                    byte[] aad = Arrays.prepend((byte[])pubKey.getEncodedContents(), (byte)((byte)(0xC0 | packetTag)));
                    AEADBlockCipher cipher = BcAEADUtil.createAEADCipher(this.encAlgorithm, this.aeadAlgorithm);
                    cipher.init(true, (CipherParameters)new AEADParameters(new KeyParameter(key), 128, this.getCipherIV(), aad));
                    int dataLen = cipher.getOutputSize(keyData.length);
                    byte[] encKey = new byte[dataLen];
                    dataLen = cipher.processBytes(keyData, 0, keyData.length, encKey, 0);
                    cipher.doFinal(encKey, dataLen);
                    return encKey;
                }
                catch (IOException e) {
                    throw new PGPException("Exception AEAD protecting private key material", e);
                }
                catch (InvalidCipherTextException e) {
                    throw new PGPException("Exception AEAD protecting private key material", (Exception)((Object)e));
                }
            }

            @Override
            public byte[] getCipherIV() {
                return this.iv;
            }
        };
    }
}

