/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.io.CipherOutputStream;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPAEADDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;
import org.bouncycastle.util.Arrays;

public class BcPGPDataEncryptorBuilder
implements PGPDataEncryptorBuilder {
    private SecureRandom random;
    private boolean withIntegrityPacket;
    private int encAlgorithm;
    private int aeadAlgorithm = -1;
    private int chunkSize;

    public BcPGPDataEncryptorBuilder(int encAlgorithm) {
        this.encAlgorithm = encAlgorithm;
        if (encAlgorithm == 0) {
            throw new IllegalArgumentException("null cipher specified");
        }
    }

    @Override
    public BcPGPDataEncryptorBuilder setWithIntegrityPacket(boolean withIntegrityPacket) {
        this.withIntegrityPacket = withIntegrityPacket;
        return this;
    }

    @Override
    public BcPGPDataEncryptorBuilder setWithAEAD(int aeadAlgorithm, int chunkSize) {
        if (this.encAlgorithm != 7 && this.encAlgorithm != 8 && this.encAlgorithm != 9) {
            throw new IllegalStateException("AEAD algorithms can only be used with AES");
        }
        if (chunkSize < 6) {
            throw new IllegalArgumentException("minimum chunkSize is 6");
        }
        this.aeadAlgorithm = aeadAlgorithm;
        this.chunkSize = chunkSize - 6;
        return this;
    }

    public BcPGPDataEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    @Override
    public int getAlgorithm() {
        return this.encAlgorithm;
    }

    @Override
    public SecureRandom getSecureRandom() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return this.random;
    }

    @Override
    public PGPDataEncryptor build(byte[] keyBytes) throws PGPException {
        if (this.aeadAlgorithm > 0) {
            return new MyAeadDataEncryptor(keyBytes);
        }
        return new MyPGPDataEncryptor(keyBytes);
    }

    private class MyAeadDataEncryptor
    implements PGPAEADDataEncryptor {
        private final AEADBlockCipher c;
        private final byte[] keyBytes;
        private final byte[] iv;

        MyAeadDataEncryptor(byte[] keyBytes) throws PGPException {
            this.keyBytes = keyBytes;
            this.c = BcUtil.createAEADCipher(BcPGPDataEncryptorBuilder.this.encAlgorithm, BcPGPDataEncryptorBuilder.this.aeadAlgorithm);
            this.iv = new byte[AEADEncDataPacket.getIVLength((byte)BcPGPDataEncryptorBuilder.this.aeadAlgorithm)];
            BcPGPDataEncryptorBuilder.this.getSecureRandom().nextBytes(this.iv);
        }

        @Override
        public OutputStream getOutputStream(OutputStream out) {
            try {
                return new BcUtil.PGPAeadOutputStream(out, this.c, new KeyParameter(this.keyBytes), BcPGPDataEncryptorBuilder.this.encAlgorithm, BcPGPDataEncryptorBuilder.this.aeadAlgorithm, BcPGPDataEncryptorBuilder.this.chunkSize, this.iv);
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to process stream: " + e.getMessage());
            }
        }

        @Override
        public PGPDigestCalculator getIntegrityCalculator() {
            return null;
        }

        @Override
        public int getBlockSize() {
            return this.c.getUnderlyingCipher().getBlockSize();
        }

        @Override
        public int getAEADAlgorithm() {
            return BcPGPDataEncryptorBuilder.this.aeadAlgorithm;
        }

        @Override
        public int getChunkSize() {
            return BcPGPDataEncryptorBuilder.this.chunkSize;
        }

        @Override
        public byte[] getIV() {
            return Arrays.clone((byte[])this.iv);
        }
    }

    private class MyPGPDataEncryptor
    implements PGPDataEncryptor {
        private final BufferedBlockCipher c;

        MyPGPDataEncryptor(byte[] keyBytes) throws PGPException {
            BlockCipher engine = BcImplProvider.createBlockCipher(BcPGPDataEncryptorBuilder.this.encAlgorithm);
            try {
                this.c = BcUtil.createStreamCipher(true, engine, BcPGPDataEncryptorBuilder.this.withIntegrityPacket, keyBytes);
            }
            catch (IllegalArgumentException e) {
                throw new PGPException("invalid parameters: " + e.getMessage(), e);
            }
        }

        @Override
        public OutputStream getOutputStream(OutputStream out) {
            return new CipherOutputStream(out, this.c);
        }

        @Override
        public PGPDigestCalculator getIntegrityCalculator() {
            if (BcPGPDataEncryptorBuilder.this.withIntegrityPacket) {
                return new SHA1PGPDigestCalculator();
            }
            return null;
        }

        @Override
        public int getBlockSize() {
            return this.c.getBlockSize();
        }
    }
}

