/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureException;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPKeyMaterialPool;
import org.bouncycastle.openpgp.api.OpenPGPMessageProcessor;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.OpenPGPSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenPGPDetachedSignatureProcessor {
    private final OpenPGPImplementation implementation;
    private final OpenPGPPolicy policy;
    private final OpenPGPKeyMaterialPool.OpenPGPCertificatePool certificatePool = new OpenPGPKeyMaterialPool.OpenPGPCertificatePool();
    private final List<PGPSignature> pgpSignatures = new ArrayList<PGPSignature>();
    private Date verifyNotAfter = new Date();
    private Date verifyNotBefore = new Date(0L);
    private OpenPGPMessageProcessor.PGPExceptionCallback exceptionCallback = null;

    public OpenPGPDetachedSignatureProcessor() {
        this(OpenPGPImplementation.getInstance());
    }

    public OpenPGPDetachedSignatureProcessor(OpenPGPImplementation implementation) {
        this(implementation, implementation.policy());
    }

    public OpenPGPDetachedSignatureProcessor(OpenPGPImplementation implementation, OpenPGPPolicy policy) {
        this.implementation = implementation;
        this.policy = policy;
    }

    public OpenPGPDetachedSignatureProcessor addSignatures(InputStream inputStream) throws IOException {
        Object next;
        InputStream decoderStream = PGPUtil.getDecoderStream(inputStream);
        BCPGInputStream pIn = BCPGInputStream.wrap(decoderStream);
        PGPObjectFactory objFac = this.implementation.pgpObjectFactory(pIn);
        while ((next = objFac.nextObject()) != null) {
            if (next instanceof PGPSignatureList) {
                this.addSignatures((PGPSignatureList)next);
                continue;
            }
            if (!(next instanceof PGPSignature)) continue;
            this.addSignature((PGPSignature)next);
        }
        return this;
    }

    public OpenPGPDetachedSignatureProcessor addSignatures(PGPSignatureList signatures) {
        Iterator<PGPSignature> it = signatures.iterator();
        while (it.hasNext()) {
            this.addSignature(it.next());
        }
        return this;
    }

    public OpenPGPDetachedSignatureProcessor addSignature(PGPSignature signature) {
        this.pgpSignatures.add(signature);
        return this;
    }

    public OpenPGPDetachedSignatureProcessor addVerificationCertificate(OpenPGPCertificate certificate) {
        this.certificatePool.addItem(certificate);
        return this;
    }

    public OpenPGPDetachedSignatureProcessor verifyNotBefore(Date date) {
        this.verifyNotBefore = date;
        return this;
    }

    public OpenPGPDetachedSignatureProcessor verifyNotAfter(Date date) {
        this.verifyNotAfter = date;
        return this;
    }

    public List<OpenPGPSignature.OpenPGPDocumentSignature> process(InputStream inputStream) throws IOException {
        Iterator it;
        int r;
        ArrayList<OpenPGPSignature.OpenPGPDocumentSignature> documentSignatures = new ArrayList<OpenPGPSignature.OpenPGPDocumentSignature>();
        for (PGPSignature signature : this.pgpSignatures) {
            OpenPGPCertificate.OpenPGPComponentKey signingKey;
            Object certificate;
            KeyIdentifier identifier = OpenPGPSignature.getMostExpressiveIdentifier(signature.getKeyIdentifiers());
            if (identifier == null || (certificate = this.certificatePool.provide(identifier)) == null || (signingKey = ((OpenPGPCertificate)certificate).getKey(identifier)) == null) continue;
            try {
                signature.init(this.implementation.pgpContentVerifierBuilderProvider(), signingKey.getPGPPublicKey());
            }
            catch (PGPException e) {
                if (this.exceptionCallback == null) continue;
                this.exceptionCallback.onException(e);
                continue;
            }
            OpenPGPSignature.OpenPGPDocumentSignature sig = new OpenPGPSignature.OpenPGPDocumentSignature(signature, signingKey);
            try {
                sig.sanitize(signingKey, this.policy);
            }
            catch (PGPSignatureException e) {
                if (this.exceptionCallback == null) continue;
                this.exceptionCallback.onException(e);
                continue;
            }
            if (!sig.createdInBounds(this.verifyNotBefore, this.verifyNotAfter)) continue;
            documentSignatures.add(sig);
        }
        byte[] buf = new byte[2048];
        while ((r = inputStream.read(buf)) != -1) {
            it = documentSignatures.iterator();
            while (it.hasNext()) {
                ((OpenPGPSignature.OpenPGPDocumentSignature)it.next()).getSignature().update(buf, 0, r);
            }
        }
        it = documentSignatures.iterator();
        while (it.hasNext()) {
            try {
                ((OpenPGPSignature.OpenPGPDocumentSignature)it.next()).verify();
            }
            catch (PGPException e) {
                if (this.exceptionCallback == null) continue;
                this.exceptionCallback.onException(e);
            }
        }
        return documentSignatures;
    }

    public OpenPGPDetachedSignatureProcessor setExceptionCallback(OpenPGPMessageProcessor.PGPExceptionCallback callback) {
        this.exceptionCallback = callback;
        return this;
    }
}

