/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.ECSecretBCPGKey;
import org.bouncycastle.bcpg.Ed25519SecretBCPGKey;
import org.bouncycastle.bcpg.Ed448SecretBCPGKey;
import org.bouncycastle.bcpg.EdSecretBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.PublicKeyUtils;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.bcpg.SecretSubkeyPacket;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.bcpg.X25519SecretBCPGKey;
import org.bouncycastle.bcpg.X448SecretBCPGKey;
import org.bouncycastle.gpg.SExprParser;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.Util;
import org.bouncycastle.openpgp.operator.GnuDivertToCardSecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PGPSecretKey {
    SecretKeyPacket secret;
    PGPPublicKey pub;

    public PGPSecretKey(SecretKeyPacket secret, PGPPublicKey pub) {
        this.secret = secret;
        this.pub = pub;
    }

    PGPSecretKey(PGPPrivateKey privKey, PGPPublicKey pubKey, PGPDigestCalculator checksumCalculator, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this(privKey, pubKey, checksumCalculator, false, keyEncryptor);
    }

    public PGPSecretKey(PGPPrivateKey privKey, PGPPublicKey pubKey, PGPDigestCalculator checksumCalculator, boolean isMasterKey, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this.pub = PGPSecretKey.buildPublicKey(isMasterKey, pubKey);
        this.secret = PGPSecretKey.buildSecretKeyPacket(isMasterKey, privKey, pubKey, keyEncryptor, checksumCalculator);
    }

    private static PGPPublicKey buildPublicKey(boolean isMasterKey, PGPPublicKey pubKey) {
        PublicKeyPacket pubPacket = pubKey.publicPk;
        if (isMasterKey && (!pubKey.isEncryptionKey() || pubPacket.getAlgorithm() == 1)) {
            PGPPublicKey mstKey = new PGPPublicKey(pubKey);
            mstKey.publicPk = new PublicKeyPacket(pubPacket.getVersion(), pubPacket.getAlgorithm(), pubPacket.getTime(), pubPacket.getKey());
            return mstKey;
        }
        PGPPublicKey subKey = new PGPPublicKey(pubKey);
        subKey.publicPk = new PublicSubkeyPacket(pubPacket.getVersion(), pubPacket.getAlgorithm(), pubPacket.getTime(), pubPacket.getKey());
        return subKey;
    }

    private static SecretKeyPacket buildSecretKeyPacket(boolean isMasterKey, PGPPrivateKey privKey, PGPPublicKey pubKey, PBESecretKeyEncryptor keyEncryptor, PGPDigestCalculator checksumCalculator) throws PGPException {
        BCPGObject secKey = (BCPGObject)((Object)privKey.getPrivateKeyDataPacket());
        if (secKey == null) {
            return PGPSecretKey.generateSecretKeyPacket(isMasterKey, pubKey.publicPk, 0, new byte[0]);
        }
        try {
            int encAlgorithm;
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            BCPGOutputStream pOut = new BCPGOutputStream(bOut);
            pOut.writeObject(secKey);
            byte[] keyData = bOut.toByteArray();
            int n = encAlgorithm = keyEncryptor != null ? keyEncryptor.getAlgorithm() : 0;
            if (encAlgorithm != 0) {
                int s2kUsage;
                pOut.write(PGPSecretKey.checksum(checksumCalculator, keyData, keyData.length));
                keyData = bOut.toByteArray();
                byte[] encData = keyEncryptor.encryptKeyData(keyData, 0, keyData.length);
                byte[] iv = keyEncryptor.getCipherIV();
                S2K s2k = keyEncryptor.getS2K();
                if (keyEncryptor.getAeadAlgorithm() != 0) {
                    int s2kUsage2 = 253;
                    return PGPSecretKey.generateSecretKeyPacket(isMasterKey, pubKey.publicPk, encAlgorithm, keyEncryptor.getAeadAlgorithm(), s2kUsage2, s2k, iv, encData);
                }
                if (checksumCalculator != null) {
                    if (checksumCalculator.getAlgorithm() != 2) {
                        throw new PGPException("only SHA1 supported for key checksum calculations.");
                    }
                    s2kUsage = 254;
                } else {
                    s2kUsage = 255;
                }
                return PGPSecretKey.generateSecretKeyPacket(isMasterKey, pubKey.publicPk, encAlgorithm, s2kUsage, s2k, iv, encData);
            }
            if (pubKey.getVersion() != 6) {
                pOut.write(PGPSecretKey.checksum(null, keyData, keyData.length));
            }
            return PGPSecretKey.generateSecretKeyPacket(isMasterKey, pubKey.publicPk, encAlgorithm, bOut.toByteArray());
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception encrypting key", e);
        }
    }

    private static SecretKeyPacket generateSecretKeyPacket(boolean isMasterKey, PublicKeyPacket pubKey, int encAlgorithm, byte[] secKeyData) {
        if (isMasterKey) {
            return new SecretKeyPacket(pubKey, encAlgorithm, null, null, secKeyData);
        }
        return new SecretSubkeyPacket(pubKey, encAlgorithm, null, null, secKeyData);
    }

    private static SecretKeyPacket generateSecretKeyPacket(boolean isMasterKey, PublicKeyPacket pubKey, int encAlgorithm, int s2kusage, S2K s2k, byte[] iv, byte[] secKeyData) {
        if (isMasterKey) {
            return new SecretKeyPacket(pubKey, encAlgorithm, s2kusage, s2k, iv, secKeyData);
        }
        return new SecretSubkeyPacket(pubKey, encAlgorithm, s2kusage, s2k, iv, secKeyData);
    }

    private static SecretKeyPacket generateSecretKeyPacket(boolean isMasterKey, PublicKeyPacket pubKey, int encAlgorithm, int aeadAlgorithm, int s2kUsage, S2K s2K, byte[] iv, byte[] secKeyData) {
        if (isMasterKey) {
            return new SecretKeyPacket(pubKey, encAlgorithm, aeadAlgorithm, s2kUsage, s2K, iv, secKeyData);
        }
        return new SecretSubkeyPacket(pubKey, encAlgorithm, aeadAlgorithm, s2kUsage, s2K, iv, secKeyData);
    }

    public PGPSecretKey(int certificationLevel, PGPKeyPair keyPair, String id, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder certificationSignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this(certificationLevel, keyPair, id, null, hashedPcks, unhashedPcks, certificationSignerBuilder, keyEncryptor);
    }

    public PGPSecretKey(PGPKeyPair masterKeyPair, PGPKeyPair keyPair, PGPDigestCalculator checksumCalculator, PGPContentSignerBuilder certificationSignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this(masterKeyPair, keyPair, checksumCalculator, null, null, certificationSignerBuilder, keyEncryptor);
    }

    public PGPSecretKey(PGPKeyPair masterKeyPair, PGPKeyPair keyPair, PGPDigestCalculator checksumCalculator, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder certificationSignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        PGPSignatureGenerator sGen = new PGPSignatureGenerator(certificationSignerBuilder, masterKeyPair.getPublicKey());
        sGen.init(24, masterKeyPair.getPrivateKey());
        if (!keyPair.getPublicKey().isEncryptionKey()) {
            if (hashedPcks == null) {
                PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(certificationSignerBuilder, keyPair.getPublicKey());
                signatureGenerator.init(25, keyPair.getPrivateKey());
                PGPSignatureSubpacketGenerator subGen = new PGPSignatureSubpacketGenerator();
                try {
                    subGen.addEmbeddedSignature(false, signatureGenerator.generateCertification(masterKeyPair.getPublicKey(), keyPair.getPublicKey()));
                    hashedPcks = subGen.generate();
                }
                catch (IOException e) {
                    throw new PGPException(e.getMessage(), e);
                }
            } else if (!hashedPcks.hasSubpacket(32)) {
                throw new PGPException("signing subkey requires embedded PRIMARYKEY_BINDING signature");
            }
        }
        sGen.setHashedSubpackets(hashedPcks);
        sGen.setUnhashedSubpackets(unhashedPcks);
        ArrayList<PGPSignature> subSigs = new ArrayList<PGPSignature>();
        subSigs.add(sGen.generateCertification(masterKeyPair.getPublicKey(), keyPair.getPublicKey()));
        PGPPublicKey pubSubKey = new PGPPublicKey(keyPair.getPublicKey(), null, subSigs);
        pubSubKey.publicPk = new PublicSubkeyPacket(pubSubKey.getVersion(), pubSubKey.getAlgorithm(), pubSubKey.getCreationTime(), pubSubKey.publicPk.getKey());
        this.pub = pubSubKey;
        this.secret = PGPSecretKey.buildSecretKeyPacket(false, keyPair.getPrivateKey(), keyPair.getPublicKey(), keyEncryptor, checksumCalculator);
    }

    public PGPSecretKey(int certificationLevel, PGPKeyPair keyPair, String id, PGPDigestCalculator checksumCalculator, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder certificationSignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this(keyPair.getPrivateKey(), PGPSecretKey.certifiedPublicKey(certificationLevel, keyPair, id, hashedPcks, unhashedPcks, certificationSignerBuilder), checksumCalculator, true, keyEncryptor);
    }

    private static PGPPublicKey certifiedPublicKey(int certificationLevel, PGPKeyPair keyPair, String id, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder certificationSignerBuilder) throws PGPException {
        PGPSignatureGenerator sGen;
        try {
            sGen = new PGPSignatureGenerator(certificationSignerBuilder, keyPair.getPublicKey());
        }
        catch (Exception e) {
            throw new PGPException("creating signature generator: " + e, e);
        }
        sGen.init(certificationLevel, keyPair.getPrivateKey());
        sGen.setHashedSubpackets(hashedPcks);
        sGen.setUnhashedSubpackets(unhashedPcks);
        try {
            PGPSignature certification = sGen.generateCertification(id, keyPair.getPublicKey());
            return PGPPublicKey.addCertification(keyPair.getPublicKey(), id, certification);
        }
        catch (Exception e) {
            throw new PGPException("exception doing certification: " + e, e);
        }
    }

    public boolean isSigningKey() {
        return PublicKeyUtils.isSigningAlgorithm(this.pub.getAlgorithm());
    }

    public boolean isMasterKey() {
        return this.pub.isMasterKey();
    }

    public boolean isPrivateKeyEmpty() {
        byte[] secKeyData = this.secret.getSecretKeyData();
        return secKeyData == null || secKeyData.length < 1;
    }

    public int getKeyEncryptionAlgorithm() {
        return this.secret.getEncAlgorithm();
    }

    public int getAEADKeyEncryptionAlgorithm() {
        return this.secret.getAeadAlgorithm();
    }

    public long getKeyID() {
        return this.pub.getKeyID();
    }

    public KeyIdentifier getKeyIdentifier() {
        return this.getPublicKey().getKeyIdentifier();
    }

    public byte[] getFingerprint() {
        return this.pub.getFingerprint();
    }

    public int getS2KUsage() {
        return this.secret.getS2KUsage();
    }

    public S2K getS2K() {
        return this.secret.getS2K();
    }

    public PGPPublicKey getPublicKey() {
        return this.pub;
    }

    public Iterator<String> getUserIDs() {
        return this.pub.getUserIDs();
    }

    public Iterator<PGPUserAttributeSubpacketVector> getUserAttributes() {
        return this.pub.getUserAttributes();
    }

    private byte[] extractKeyData(PBESecretKeyDecryptor decryptorFactory) throws PGPException {
        byte[] encData = this.secret.getSecretKeyData();
        if (this.secret.getEncAlgorithm() == 0) {
            return encData;
        }
        try {
            byte[] data;
            byte[] key = decryptorFactory.makeKeyFromPassPhrase(this.secret.getEncAlgorithm(), this.secret.getS2K());
            if (this.secret.getPublicKeyPacket().getVersion() >= 4) {
                if (this.secret.getS2KUsage() == 253) {
                    return decryptorFactory.recoverKeyData(this.secret.getEncAlgorithm(), this.secret.getAeadAlgorithm(), key, this.secret.getIV(), this.secret.getPacketTag(), this.secret.getPublicKeyPacket().getVersion(), this.secret.getSecretKeyData(), this.secret.getPublicKeyPacket().getEncodedContents());
                }
                data = decryptorFactory.recoverKeyData(this.secret.getEncAlgorithm(), key, this.secret.getIV(), encData, 0, encData.length);
                boolean useSHA1 = this.secret.getS2KUsage() == 254;
                byte[] check = PGPSecretKey.checksum(useSHA1 ? decryptorFactory.getChecksumCalculator(2) : null, data, useSHA1 ? data.length - 20 : data.length - 2);
                if (!Arrays.constantTimeAreEqual((int)check.length, (byte[])check, (int)0, (byte[])data, (int)(data.length - check.length))) {
                    throw new PGPException("checksum mismatch in checksum of " + check.length + " bytes");
                }
            } else {
                data = new byte[encData.length];
                byte[] iv = new byte[this.secret.getIV().length];
                System.arraycopy(this.secret.getIV(), 0, iv, 0, iv.length);
                int pos = 0;
                for (int i = 0; i != 4; ++i) {
                    int encLen = (((encData[pos] & 0xFF) << 8 | encData[pos + 1] & 0xFF) + 7) / 8;
                    data[pos] = encData[pos];
                    data[pos + 1] = encData[pos + 1];
                    if (encLen > encData.length - (pos + 2)) {
                        throw new PGPException("out of range encLen found in encData");
                    }
                    byte[] tmp = decryptorFactory.recoverKeyData(this.secret.getEncAlgorithm(), key, iv, encData, pos + 2, encLen);
                    System.arraycopy(tmp, 0, data, pos + 2, tmp.length);
                    pos += 2 + encLen;
                    if (i == 3) continue;
                    System.arraycopy(encData, pos - iv.length, iv, 0, iv.length);
                }
                data[pos] = encData[pos];
                data[pos + 1] = encData[pos + 1];
                int cs = encData[pos] << 8 & 0xFF00 | encData[pos + 1] & 0xFF;
                int calcCs = 0;
                for (int j = 0; j < data.length - 2; ++j) {
                    calcCs += data[j] & 0xFF;
                }
                if ((calcCs &= 0xFFFF) != cs) {
                    throw new PGPException("checksum mismatch: passphrase wrong, expected " + Integer.toHexString(cs) + " found " + Integer.toHexString(calcCs));
                }
            }
            return data;
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception decrypting key", e);
        }
    }

    public PGPKeyPair extractKeyPair(PBESecretKeyDecryptor decryptorFactory) throws PGPException {
        return new PGPKeyPair(this.getPublicKey(), this.extractPrivateKey(decryptorFactory));
    }

    public PGPPrivateKey extractPrivateKey(PBESecretKeyDecryptor decryptorFactory) throws PGPException {
        if (this.isPrivateKeyEmpty()) {
            return null;
        }
        PublicKeyPacket pubPk = this.secret.getPublicKeyPacket();
        try {
            byte[] data = this.extractKeyData(decryptorFactory);
            BCPGInputStream in = new BCPGInputStream(new ByteArrayInputStream(data));
            switch (pubPk.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSASecretBCPGKey rsaPriv = new RSASecretBCPGKey(in);
                    return new PGPPrivateKey(this.getKeyID(), pubPk, rsaPriv);
                }
                case 17: {
                    DSASecretBCPGKey dsaPriv = new DSASecretBCPGKey(in);
                    return new PGPPrivateKey(this.getKeyID(), pubPk, dsaPriv);
                }
                case 16: 
                case 20: {
                    ElGamalSecretBCPGKey elPriv = new ElGamalSecretBCPGKey(in);
                    return new PGPPrivateKey(this.getKeyID(), pubPk, elPriv);
                }
                case 18: 
                case 19: {
                    ECSecretBCPGKey ecPriv = new ECSecretBCPGKey(in);
                    return new PGPPrivateKey(this.getKeyID(), pubPk, ecPriv);
                }
                case 25: {
                    return new PGPPrivateKey(this.getKeyID(), pubPk, new X25519SecretBCPGKey(in));
                }
                case 26: {
                    return new PGPPrivateKey(this.getKeyID(), pubPk, new X448SecretBCPGKey(in));
                }
                case 22: {
                    return new PGPPrivateKey(this.getKeyID(), pubPk, new EdSecretBCPGKey(in));
                }
                case 27: {
                    return new PGPPrivateKey(this.getKeyID(), pubPk, new Ed25519SecretBCPGKey(in));
                }
                case 28: {
                    return new PGPPrivateKey(this.getKeyID(), pubPk, new Ed448SecretBCPGKey(in));
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception constructing key", e);
        }
    }

    private static byte[] checksum(PGPDigestCalculator digCalc, byte[] bytes, int length) throws PGPException {
        if (digCalc != null) {
            OutputStream dOut = digCalc.getOutputStream();
            try {
                dOut.write(bytes, 0, length);
                dOut.close();
            }
            catch (Exception e) {
                throw new PGPException("checksum digest calculation failed: " + e.getMessage(), e);
            }
            return digCalc.getDigest();
        }
        int checksum = 0;
        for (int i = 0; i != length; ++i) {
            checksum += bytes[i] & 0xFF;
        }
        byte[] check = new byte[]{(byte)(checksum >> 8), (byte)checksum};
        return check;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        BCPGOutputStream out = BCPGOutputStream.wrap(outStream);
        out.writePacket(this.secret);
        if (this.pub.trustPk != null) {
            out.writePacket(this.pub.trustPk);
        }
        if (this.pub.subSigs == null) {
            Util.encodePGPSignatures(out, this.pub.keySigs, false);
            for (int i = 0; i != this.pub.ids.size(); ++i) {
                if (this.pub.ids.get(i) instanceof UserIDPacket) {
                    UserIDPacket id = (UserIDPacket)this.pub.ids.get(i);
                    out.writePacket(id);
                } else {
                    PGPUserAttributeSubpacketVector v = (PGPUserAttributeSubpacketVector)this.pub.ids.get(i);
                    out.writePacket(new UserAttributePacket(v.toSubpacketArray()));
                }
                if (this.pub.idTrusts.get(i) != null) {
                    out.writePacket(this.pub.idTrusts.get(i));
                }
                List<PGPSignature> sigs = this.pub.idSigs.get(i);
                Util.encodePGPSignatures(out, sigs, false);
            }
        } else {
            Util.encodePGPSignatures(out, this.pub.subSigs, false);
        }
        out.finish();
    }

    public static PGPSecretKey copyWithNewPassword(PGPSecretKey key, PBESecretKeyDecryptor oldKeyDecryptor, PBESecretKeyEncryptor newKeyEncryptor) throws PGPException {
        return PGPSecretKey.copyWithNewPassword(key, oldKeyDecryptor, newKeyEncryptor, null);
    }

    public static PGPSecretKey copyWithNewPassword(PGPSecretKey key, PBESecretKeyDecryptor oldKeyDecryptor, PBESecretKeyEncryptor newKeyEncryptor, PGPDigestCalculator checksumCalculator) throws PGPException {
        SecretKeyPacket secret;
        byte[] check;
        byte[] keyData;
        if (key.isPrivateKeyEmpty()) {
            throw new PGPException("no private key in this SecretKey - public key present only.");
        }
        byte[] rawKeyData = key.extractKeyData(oldKeyDecryptor);
        int s2kUsage = key.secret.getS2KUsage();
        byte[] iv = null;
        S2K s2k = null;
        int newEncAlgorithm = 0;
        if (newKeyEncryptor == null || newKeyEncryptor.getAlgorithm() == 0 && !(newKeyEncryptor instanceof GnuDivertToCardSecretKeyEncryptor)) {
            s2kUsage = 0;
            if (key.secret.getS2KUsage() == 254) {
                keyData = new byte[rawKeyData.length - 18];
                System.arraycopy(rawKeyData, 0, keyData, 0, keyData.length - 2);
                check = PGPSecretKey.checksum(null, keyData, keyData.length - 2);
                keyData[keyData.length - 2] = check[0];
                keyData[keyData.length - 1] = check[1];
            } else {
                keyData = rawKeyData;
            }
        } else {
            if (key.secret.getPublicKeyPacket().getVersion() < 4) {
                if (s2kUsage == 0) {
                    s2kUsage = 255;
                }
                byte[] encKey = newKeyEncryptor.getKey();
                keyData = new byte[rawKeyData.length];
                if (newKeyEncryptor.getHashAlgorithm() != 1) {
                    throw new PGPException("MD5 Digest Calculator required for version 3 key encryptor.");
                }
                int pos = 0;
                for (int i = 0; i != 4; ++i) {
                    byte[] tmp;
                    int encLen = (((rawKeyData[pos] & 0xFF) << 8 | rawKeyData[pos + 1] & 0xFF) + 7) / 8;
                    keyData[pos] = rawKeyData[pos];
                    keyData[pos + 1] = rawKeyData[pos + 1];
                    if (encLen > rawKeyData.length - (pos + 2)) {
                        throw new PGPException("out of range encLen found in rawKeyData");
                    }
                    if (i == 0) {
                        tmp = newKeyEncryptor.encryptKeyData(encKey, rawKeyData, pos + 2, encLen);
                        iv = newKeyEncryptor.getCipherIV();
                    } else {
                        byte[] tmpIv = new byte[iv.length];
                        System.arraycopy(keyData, pos - iv.length, tmpIv, 0, tmpIv.length);
                        tmp = newKeyEncryptor.encryptKeyData(encKey, tmpIv, rawKeyData, pos + 2, encLen);
                    }
                    System.arraycopy(tmp, 0, keyData, pos + 2, tmp.length);
                    pos += 2 + encLen;
                }
                keyData[pos] = rawKeyData[pos];
                keyData[pos + 1] = rawKeyData[pos + 1];
            } else {
                if (s2kUsage == 0) {
                    if (checksumCalculator != null) {
                        if (checksumCalculator.getAlgorithm() != 2) {
                            throw new IllegalArgumentException("only SHA-1 supported for checksums");
                        }
                        s2kUsage = 254;
                        check = PGPSecretKey.checksum(checksumCalculator, rawKeyData, rawKeyData.length);
                        rawKeyData = Arrays.concatenate((byte[])rawKeyData, (byte[])check);
                    } else {
                        s2kUsage = 255;
                    }
                }
                keyData = newKeyEncryptor.encryptKeyData(rawKeyData, 0, rawKeyData.length);
                iv = newKeyEncryptor.getCipherIV();
            }
            s2k = newKeyEncryptor.getS2K();
            newEncAlgorithm = newKeyEncryptor.getAlgorithm();
        }
        if (newKeyEncryptor != null && newKeyEncryptor.getAeadAlgorithm() > 0) {
            s2kUsage = 253;
            secret = PGPSecretKey.generateSecretKeyPacket(!(key.secret instanceof SecretSubkeyPacket), key.secret.getPublicKeyPacket(), newEncAlgorithm, newKeyEncryptor.getAeadAlgorithm(), s2kUsage, s2k, iv, keyData);
        } else {
            secret = PGPSecretKey.generateSecretKeyPacket(!(key.secret instanceof SecretSubkeyPacket), key.secret.getPublicKeyPacket(), newEncAlgorithm, s2kUsage, s2k, iv, keyData);
        }
        return new PGPSecretKey(secret, key.pub);
    }

    public static PGPSecretKey replacePublicKey(PGPSecretKey secretKey, PGPPublicKey publicKey) {
        if (publicKey.getKeyID() != secretKey.getKeyID()) {
            throw new IllegalArgumentException("keyIDs do not match");
        }
        return new PGPSecretKey(secretKey.secret, publicKey);
    }

    public static PGPSecretKey parseSecretKeyFromSExpr(InputStream inputStream, PBEProtectionRemoverFactory keyProtectionRemoverFactory, PGPPublicKey pubKey) throws IOException, PGPException {
        return new SExprParser(null).parseSecretKey(inputStream, keyProtectionRemoverFactory, pubKey);
    }

    public static PGPSecretKey parseSecretKeyFromSExpr(InputStream inputStream, PBEProtectionRemoverFactory keyProtectionRemoverFactory, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        return new SExprParser(null).parseSecretKey(inputStream, keyProtectionRemoverFactory, fingerPrintCalculator);
    }
}

