/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.UnknownPacket;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPMarker;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPadding;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPTrust;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.Iterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PGPObjectFactory
implements Iterable<Object> {
    private BCPGInputStream in;
    private KeyFingerPrintCalculator fingerPrintCalculator;
    private boolean throwForUnknownCriticalPackets = false;

    public PGPObjectFactory(InputStream in, KeyFingerPrintCalculator fingerPrintCalculator) {
        this.in = BCPGInputStream.wrap(in);
        this.fingerPrintCalculator = fingerPrintCalculator;
    }

    public PGPObjectFactory(byte[] bytes, KeyFingerPrintCalculator fingerPrintCalculator) {
        this(new ByteArrayInputStream(bytes), fingerPrintCalculator);
    }

    public Object nextObject() throws IOException {
        switch (this.in.nextPacketTag()) {
            case -1: {
                return null;
            }
            case 0: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return this.in.readPacket();
            }
            case 2: {
                ArrayList<PGPSignature> l = new ArrayList<PGPSignature>();
                while (this.in.nextPacketTag() == 2) {
                    try {
                        l.add(new PGPSignature(this.in));
                    }
                    catch (UnsupportedPacketVersionException e) {
                    }
                    catch (PGPException e) {
                        throw new IOException("can't create signature object: " + e);
                    }
                }
                return new PGPSignatureList(l.toArray(new PGPSignature[l.size()]));
            }
            case 5: {
                try {
                    return new PGPSecretKeyRing(this.in, this.fingerPrintCalculator);
                }
                catch (PGPException e) {
                    throw new IOException("can't create secret key object: " + e);
                }
            }
            case 6: {
                return new PGPPublicKeyRing(this.in, this.fingerPrintCalculator);
            }
            case 14: {
                try {
                    return PGPPublicKeyRing.readSubkey(this.in, this.fingerPrintCalculator);
                }
                catch (PGPException e) {
                    throw new IOException("processing error: " + e.getMessage());
                }
            }
            case 8: {
                return new PGPCompressedData(this.in);
            }
            case 11: {
                return new PGPLiteralData(this.in);
            }
            case 12: {
                return new PGPTrust(this.in);
            }
            case 1: 
            case 3: 
            case 9: 
            case 18: 
            case 20: {
                return new PGPEncryptedDataList(this.in);
            }
            case 4: {
                ArrayList<PGPOnePassSignature> l = new ArrayList<PGPOnePassSignature>();
                while (this.in.nextPacketTag() == 4) {
                    try {
                        l.add(new PGPOnePassSignature(this.in));
                    }
                    catch (PGPException e) {
                        throw new IOException("can't create one pass signature object: " + e);
                    }
                }
                return new PGPOnePassSignatureList(l.toArray(new PGPOnePassSignature[l.size()]));
            }
            case 10: {
                return new PGPMarker(this.in);
            }
            case 21: {
                return new PGPPadding(this.in);
            }
            case 19: {
                return new UnknownPacket(19, this.in);
            }
            case 13: {
                return new UnknownPacket(13, this.in);
            }
            case 17: {
                return new UnknownPacket(17, this.in);
            }
        }
        int tag = this.in.nextPacketTag();
        UnknownPacket unknownPacket = (UnknownPacket)this.in.readPacket();
        if (this.throwForUnknownCriticalPackets && unknownPacket.isCritical()) {
            throw new IOException("unknown object in stream: " + tag);
        }
        return unknownPacket;
    }

    public Iterator iterator() {
        return new Iterator(){
            private boolean triedNext = false;
            private Object obj = null;

            public boolean hasNext() {
                if (!this.triedNext) {
                    this.triedNext = true;
                    this.obj = this.getObject();
                }
                return this.obj != null;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.triedNext = false;
                return this.obj;
            }

            public void remove() {
                throw new UnsupportedOperationException("Cannot remove element from factory.");
            }

            private Object getObject() {
                try {
                    return PGPObjectFactory.this.nextObject();
                }
                catch (IOException e) {
                    throw new PGPRuntimeOperationException("Iterator failed to get next object: " + e.getMessage(), e);
                }
            }
        };
    }

    public PGPObjectFactory setThrowForUnknownCriticalPackets(boolean throwException) {
        this.throwForUnknownCriticalPackets = throwException;
        return this;
    }
}

