/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg.sig;

import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class RegularExpression
extends SignatureSubpacket {
    public RegularExpression(boolean critical, boolean isLongLength, byte[] data) {
        super(6, critical, isLongLength, data);
        if (data.length == 0 || data[data.length - 1] != 0) {
            throw new IllegalArgumentException("data in regex missing null termination");
        }
    }

    public RegularExpression(boolean critical, String regex) {
        super(6, critical, false, RegularExpression.toNullTerminatedUTF8ByteArray(regex));
    }

    public String getRegex() {
        return Strings.fromUTF8ByteArray((byte[])this.data, (int)0, (int)(this.data.length - 1));
    }

    public byte[] getRawRegex() {
        return Arrays.clone((byte[])this.data);
    }

    private static byte[] toNullTerminatedUTF8ByteArray(String string) {
        byte[] utf8 = Strings.toUTF8ByteArray((String)string);
        return Arrays.append((byte[])utf8, (byte)0);
    }
}

