/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.FingerprintUtil;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.PacketFormat;
import org.bouncycastle.bcpg.PublicKeyUtils;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.sig.Features;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.PreferredAEADCiphersuites;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.bcpg.sig.PrimaryUserID;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureException;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.OpenPGPSignature;
import org.bouncycastle.openpgp.api.exception.IncorrectOpenPGPSignatureException;
import org.bouncycastle.openpgp.api.exception.MalformedOpenPGPSignatureException;
import org.bouncycastle.openpgp.api.exception.MissingIssuerCertException;
import org.bouncycastle.openpgp.api.util.UTCUtil;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenPGPCertificate {
    final OpenPGPImplementation implementation;
    final OpenPGPPolicy policy;
    protected PGPKeyRing keyRing;
    private final OpenPGPPrimaryKey primaryKey;
    private final Map<KeyIdentifier, OpenPGPSubkey> subkeys;
    private final Map<OpenPGPCertificateComponent, OpenPGPSignatureChains> componentSignatureChains;

    public OpenPGPCertificate(PGPKeyRing keyRing) {
        this(keyRing, OpenPGPImplementation.getInstance());
    }

    public OpenPGPCertificate(PGPKeyRing keyRing, OpenPGPImplementation implementation) {
        this(keyRing, implementation, implementation.policy());
    }

    public OpenPGPCertificate(PGPKeyRing keyRing, OpenPGPImplementation implementation, OpenPGPPolicy policy) {
        this.implementation = implementation;
        this.policy = policy;
        this.keyRing = keyRing;
        this.subkeys = new LinkedHashMap<KeyIdentifier, OpenPGPSubkey>();
        this.componentSignatureChains = new LinkedHashMap<OpenPGPCertificateComponent, OpenPGPSignatureChains>();
        Iterator<PGPPublicKey> rawKeys = keyRing.getPublicKeys();
        PGPPublicKey rawPrimaryKey = rawKeys.next();
        this.primaryKey = new OpenPGPPrimaryKey(rawPrimaryKey, this);
        this.processPrimaryKey(this.primaryKey);
        while (rawKeys.hasNext()) {
            PGPPublicKey rawSubkey = rawKeys.next();
            OpenPGPSubkey subkey = new OpenPGPSubkey(rawSubkey, this);
            this.subkeys.put(rawSubkey.getKeyIdentifier(), subkey);
            this.processSubkey(subkey);
        }
    }

    public boolean isSecretKey() {
        return false;
    }

    public List<OpenPGPUserId> getAllUserIds() {
        return this.getPrimaryKey().getUserIDs();
    }

    public List<OpenPGPUserId> getValidUserIds() {
        return this.getValidUserIds(new Date());
    }

    public List<OpenPGPUserId> getValidUserIds(Date evaluationTime) {
        return this.getPrimaryKey().getValidUserIDs(evaluationTime);
    }

    public Map<KeyIdentifier, OpenPGPComponentKey> getPublicKeys() {
        HashMap<KeyIdentifier, OpenPGPComponentKey> keys = new HashMap<KeyIdentifier, OpenPGPComponentKey>();
        keys.put(this.primaryKey.getKeyIdentifier(), this.primaryKey);
        keys.putAll(this.subkeys);
        return keys;
    }

    public OpenPGPPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public Map<KeyIdentifier, OpenPGPSubkey> getSubkeys() {
        return new LinkedHashMap<KeyIdentifier, OpenPGPSubkey>(this.subkeys);
    }

    public List<OpenPGPComponentKey> getComponentKeysWithFlag(Date evaluationTime, final int ... keyFlags) {
        return this.filterKeys(evaluationTime, new KeyFilter(){

            public boolean test(OpenPGPComponentKey key, Date time) {
                return key.hasKeyFlags(time, keyFlags);
            }
        });
    }

    public List<OpenPGPCertificateComponent> getComponents() {
        return new ArrayList<OpenPGPCertificateComponent>(this.componentSignatureChains.keySet());
    }

    public List<OpenPGPComponentKey> getKeys() {
        ArrayList<OpenPGPComponentKey> keys = new ArrayList<OpenPGPComponentKey>();
        keys.add(this.primaryKey);
        keys.addAll(this.subkeys.values());
        return keys;
    }

    public List<OpenPGPComponentKey> getValidKeys() {
        return this.getValidKeys(new Date());
    }

    public List<OpenPGPComponentKey> getValidKeys(Date evaluationTime) {
        return this.filterKeys(evaluationTime, new KeyFilter(){

            public boolean test(OpenPGPComponentKey key, Date time) {
                return true;
            }
        });
    }

    public OpenPGPComponentKey getKey(KeyIdentifier identifier) {
        if (identifier.matchesExplicit(this.getPrimaryKey().getPGPPublicKey().getKeyIdentifier())) {
            return this.primaryKey;
        }
        return this.subkeys.get(identifier);
    }

    public OpenPGPComponentKey getSigningKeyFor(PGPSignature signature) {
        List<KeyIdentifier> keyIdentifiers = signature.getKeyIdentifiers();
        int type = signature.getSignatureType();
        if (type == 24 || type == 40) {
            return this.primaryKey;
        }
        if (KeyIdentifier.matches(keyIdentifiers, this.getPrimaryKey().getKeyIdentifier(), true)) {
            return this.primaryKey;
        }
        for (KeyIdentifier subkeyIdentifier : this.subkeys.keySet()) {
            if (!KeyIdentifier.matches(keyIdentifiers, subkeyIdentifier, true)) continue;
            return this.subkeys.get(subkeyIdentifier);
        }
        return null;
    }

    public PGPKeyRing getPGPKeyRing() {
        return this.keyRing;
    }

    public PGPPublicKeyRing getPGPPublicKeyRing() {
        if (this.keyRing instanceof PGPPublicKeyRing) {
            return (PGPPublicKeyRing)this.keyRing;
        }
        ArrayList<PGPPublicKey> list = new ArrayList<PGPPublicKey>();
        Iterator<PGPPublicKey> it = this.keyRing.getPublicKeys();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return new PGPPublicKeyRing(list);
    }

    public KeyIdentifier getKeyIdentifier() {
        return this.primaryKey.getKeyIdentifier();
    }

    public List<KeyIdentifier> getAllKeyIdentifiers() {
        ArrayList<KeyIdentifier> identifiers = new ArrayList<KeyIdentifier>();
        Iterator<PGPPublicKey> it = this.keyRing.getPublicKeys();
        while (it.hasNext()) {
            PGPPublicKey key = it.next();
            identifiers.add(key.getKeyIdentifier());
        }
        return identifiers;
    }

    public OpenPGPComponentSignature getCertification() {
        return this.getCertification(new Date());
    }

    public OpenPGPComponentSignature getCertification(Date evaluationTime) {
        return this.primaryKey.getCertification(evaluationTime);
    }

    public OpenPGPComponentSignature getRevocation() {
        return this.getRevocation(new Date());
    }

    public OpenPGPComponentSignature getRevocation(Date evaluationTime) {
        return this.primaryKey.getRevocation(evaluationTime);
    }

    public Date getLastModificationDate() {
        return this.getLastModificationDateAt(new Date());
    }

    public Date getLastModificationDateAt(Date evaluationTime) {
        Date latestModification = null;
        Iterator<OpenPGPCertificateComponent> it = this.getComponents().iterator();
        while (it.hasNext()) {
            OpenPGPSignatureChains componentChains = this.getAllSignatureChainsFor(it.next());
            componentChains = componentChains.getChainsAt(evaluationTime);
            Iterator<OpenPGPSignatureChain> it2 = componentChains.iterator();
            while (it2.hasNext()) {
                for (OpenPGPSignatureChain.Link link : it2.next()) {
                    if (latestModification != null && !link.since().after(latestModification)) continue;
                    latestModification = link.since();
                }
            }
        }
        if (latestModification != null) {
            return latestModification;
        }
        for (OpenPGPComponentKey key : this.getKeys()) {
            if (key.getCreationTime().after(evaluationTime) || latestModification != null && !key.getCreationTime().after(latestModification)) continue;
            latestModification = key.getCreationTime();
        }
        return latestModification;
    }

    public static OpenPGPCertificate join(OpenPGPCertificate certificate, String armored) throws IOException, PGPException {
        Object next;
        ByteArrayInputStream bIn = new ByteArrayInputStream(armored.getBytes());
        InputStream decoderStream = PGPUtil.getDecoderStream(bIn);
        BCPGInputStream wrapper = BCPGInputStream.wrap(decoderStream);
        PGPObjectFactory objFac = certificate.implementation.pgpObjectFactory(wrapper);
        while ((next = objFac.nextObject()) != null) {
            if (next instanceof PGPPublicKeyRing) {
                PGPPublicKeyRing publicKeys = (PGPPublicKeyRing)next;
                OpenPGPCertificate otherCert = new OpenPGPCertificate(publicKeys, certificate.implementation);
                try {
                    return OpenPGPCertificate.join(certificate, otherCert);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
            }
            if (next instanceof PGPSecretKeyRing) {
                throw new IllegalArgumentException("Joining with a secret key is not supported.");
            }
            if (!(next instanceof PGPSignatureList)) continue;
            PGPSignatureList signatures = (PGPSignatureList)next;
            PGPPublicKeyRing publicKeys = certificate.getPGPPublicKeyRing();
            PGPPublicKey primaryKey = publicKeys.getPublicKey();
            Iterator<PGPSignature> it = signatures.iterator();
            while (it.hasNext()) {
                primaryKey = PGPPublicKey.addCertification(primaryKey, it.next());
            }
            publicKeys = PGPPublicKeyRing.insertPublicKey(publicKeys, primaryKey);
            return new OpenPGPCertificate(publicKeys, certificate.implementation);
        }
        return null;
    }

    public static OpenPGPCertificate join(OpenPGPCertificate certificate, OpenPGPCertificate other) throws PGPException {
        PGPPublicKeyRing joined = PGPPublicKeyRing.join(certificate.getPGPPublicKeyRing(), other.getPGPPublicKeyRing());
        return new OpenPGPCertificate(joined, certificate.implementation);
    }

    public byte[] getFingerprint() {
        return this.primaryKey.getPGPPublicKey().getFingerprint();
    }

    public String getPrettyFingerprint() {
        return FingerprintUtil.prettifyFingerprint(this.getFingerprint());
    }

    public String toAsciiArmoredString() throws IOException {
        return this.toAsciiArmoredString(PacketFormat.ROUNDTRIP);
    }

    public String toAsciiArmoredString(PacketFormat packetFormat) throws IOException {
        ArmoredOutputStream.Builder armorBuilder = ArmoredOutputStream.builder().clearHeaders();
        armorBuilder.addSplitMultilineComment(this.getPrettyFingerprint());
        Iterator<OpenPGPUserId> it = this.getPrimaryKey().getUserIDs().iterator();
        while (it.hasNext()) {
            armorBuilder.addEllipsizedComment(it.next().getUserId());
        }
        return this.toAsciiArmoredString(packetFormat, armorBuilder);
    }

    public String toAsciiArmoredString(PacketFormat packetFormat, ArmoredOutputStream.Builder armorBuilder) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ArmoredOutputStream aOut = armorBuilder.build(bOut);
        aOut.write(this.getEncoded(packetFormat));
        aOut.close();
        return bOut.toString();
    }

    public byte[] getEncoded() throws IOException {
        return this.getEncoded(PacketFormat.ROUNDTRIP);
    }

    public byte[] getEncoded(PacketFormat format) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = new BCPGOutputStream((OutputStream)bOut, format);
        ArrayList<PGPPublicKey> list = new ArrayList<PGPPublicKey>();
        Iterator<PGPPublicKey> it = this.getPGPKeyRing().getPublicKeys();
        while (it.hasNext()) {
            list.add(it.next());
        }
        PGPPublicKeyRing publicKeys = new PGPPublicKeyRing(list);
        publicKeys.encode(pOut, true);
        pOut.close();
        return bOut.toByteArray();
    }

    private OpenPGPSignatureChain getSignatureChainFor(OpenPGPCertificateComponent component, OpenPGPComponentKey origin, Date evaluationDate) {
        OpenPGPSignatureChains fromOrigin;
        OpenPGPUserId primaryUserId;
        boolean isPrimaryKey;
        OpenPGPSignatureChains chainsForComponent = this.getAllSignatureChainsFor(component);
        boolean bl = isPrimaryKey = component == this.getPrimaryKey();
        if (isPrimaryKey && chainsForComponent.getCertificationAt(evaluationDate) == null && (primaryUserId = this.getPrimaryUserId(evaluationDate)) != null) {
            chainsForComponent.addAll(this.getAllSignatureChainsFor(primaryUserId));
        }
        if ((fromOrigin = chainsForComponent.fromOrigin(origin)) == null) {
            return null;
        }
        return fromOrigin.getChainAt(evaluationDate);
    }

    private OpenPGPSignatureChains getAllSignatureChainsFor(OpenPGPCertificateComponent component) {
        OpenPGPSignatureChains chains = new OpenPGPSignatureChains(component.getPublicComponent());
        chains.addAll(this.componentSignatureChains.get(component.getPublicComponent()));
        return chains;
    }

    private void processPrimaryKey(OpenPGPPrimaryKey primaryKey) {
        OpenPGPSignatureChains keySignatureChains = new OpenPGPSignatureChains(primaryKey);
        List<OpenPGPComponentSignature> keySignatures = primaryKey.getKeySignatures();
        this.addSignaturesToChains(keySignatures, keySignatureChains);
        this.componentSignatureChains.put(primaryKey, keySignatureChains);
        for (OpenPGPIdentityComponent identity : primaryKey.identityComponents) {
            OpenPGPSignatureChains identityChains = new OpenPGPSignatureChains(identity);
            List<OpenPGPComponentSignature> bindings = identity instanceof OpenPGPUserId ? primaryKey.getUserIdSignatures((OpenPGPUserId)identity) : primaryKey.getUserAttributeSignatures((OpenPGPUserAttribute)identity);
            this.addSignaturesToChains(bindings, identityChains);
            this.componentSignatureChains.put(identity, identityChains);
        }
    }

    private void processSubkey(OpenPGPSubkey subkey) {
        List<OpenPGPComponentSignature> bindingSignatures = subkey.getKeySignatures();
        OpenPGPSignatureChains subkeyChains = new OpenPGPSignatureChains(subkey);
        for (OpenPGPComponentSignature sig : bindingSignatures) {
            OpenPGPComponentKey issuer = subkey.getCertificate().getSigningKeyFor(sig.getSignature());
            if (issuer == null) continue;
            OpenPGPSignatureChains issuerChains = this.getAllSignatureChainsFor(issuer);
            if (!issuerChains.chains.isEmpty()) {
                Iterator it2 = issuerChains.chains.iterator();
                while (it2.hasNext()) {
                    subkeyChains.add(((OpenPGPSignatureChain)it2.next()).plus(sig));
                }
                continue;
            }
            subkeyChains.add(new OpenPGPSignatureChain(OpenPGPSignatureChain.Link.create(sig)));
        }
        this.componentSignatureChains.put(subkey, subkeyChains);
    }

    private boolean isBound(OpenPGPCertificateComponent component, Date evaluationTime) {
        return this.isBoundBy(component, this.getPrimaryKey(), evaluationTime);
    }

    private boolean isBoundBy(OpenPGPCertificateComponent component, OpenPGPComponentKey root, Date evaluationTime) {
        KeyExpirationTime kexp;
        OpenPGPSignature.OpenPGPSignatureSubpacket keyExpiration = component.getApplyingSubpacket(evaluationTime, 9);
        if (keyExpiration != null && (kexp = (KeyExpirationTime)keyExpiration.getSubpacket()).getTime() != 0L) {
            OpenPGPComponentKey key = component.getKeyComponent();
            Date expirationDate = new Date(1000L * kexp.getTime() + key.getCreationTime().getTime());
            if (expirationDate.before(evaluationTime)) {
                return false;
            }
        }
        try {
            OpenPGPSignatureChain chain = this.getSignatureChainFor(component, root, evaluationTime);
            if (chain == null) {
                return false;
            }
            if (chain.isValid(this.implementation.pgpContentVerifierBuilderProvider(), this.policy)) {
                return !chain.isRevocation();
            }
            return false;
        }
        catch (PGPException e) {
            return false;
        }
    }

    public List<OpenPGPComponentKey> getEncryptionKeys() {
        return this.getEncryptionKeys(new Date());
    }

    public List<OpenPGPComponentKey> getEncryptionKeys(Date evaluationTime) {
        return this.filterKeys(evaluationTime, new KeyFilter(){

            public boolean test(OpenPGPComponentKey key, Date time) {
                return key.isEncryptionKey(time);
            }
        });
    }

    public List<OpenPGPComponentKey> getSigningKeys() {
        return this.getSigningKeys(new Date());
    }

    public List<OpenPGPComponentKey> getSigningKeys(Date evaluationTime) {
        return this.filterKeys(evaluationTime, new KeyFilter(){

            public boolean test(OpenPGPComponentKey key, Date time) {
                return key.isSigningKey(time);
            }
        });
    }

    public List<OpenPGPComponentKey> getCertificationKeys() {
        return this.getCertificationKeys(new Date());
    }

    public List<OpenPGPComponentKey> getCertificationKeys(Date evaluationTime) {
        return this.filterKeys(evaluationTime, new KeyFilter(){

            public boolean test(OpenPGPComponentKey key, Date time) {
                return key.isCertificationKey(time);
            }
        });
    }

    private OpenPGPSignatureChain getPreferenceSignature(Date evaluationTime) {
        OpenPGPSignatureChain directKeyBinding = this.getPrimaryKey().getSignatureChains().fromOrigin(this.getPrimaryKey()).getCertificationAt(evaluationTime);
        if (directKeyBinding != null) {
            return directKeyBinding;
        }
        ArrayList<OpenPGPSignatureChain> uidBindings = new ArrayList<OpenPGPSignatureChain>();
        Iterator<OpenPGPUserId> it = this.getPrimaryKey().getUserIDs().iterator();
        while (it.hasNext()) {
            OpenPGPSignatureChain uidBinding = this.getAllSignatureChainsFor(it.next()).fromOrigin(this.getPrimaryKey()).getCertificationAt(evaluationTime);
            if (uidBinding == null) continue;
            uidBindings.add(uidBinding);
        }
        uidBindings.sort(new Comparator<OpenPGPSignatureChain>(){

            @Override
            public int compare(OpenPGPSignatureChain o1, OpenPGPSignatureChain o2) {
                return o2.getSince().compareTo(o1.getSince());
            }
        });
        for (OpenPGPSignatureChain binding : uidBindings) {
            PGPSignature sig = binding.getSignature().getSignature();
            if (!sig.getHashedSubPackets().isPrimaryUserID()) continue;
            return binding;
        }
        return uidBindings.isEmpty() ? null : (OpenPGPSignatureChain)uidBindings.get(0);
    }

    public List<OpenPGPIdentityComponent> getIdentities() {
        return new ArrayList<OpenPGPIdentityComponent>(this.primaryKey.identityComponents);
    }

    public OpenPGPUserId getPrimaryUserId() {
        return this.getPrimaryUserId(new Date());
    }

    public OpenPGPUserId getPrimaryUserId(Date evaluationTime) {
        return this.primaryKey.getExplicitOrImplicitPrimaryUserId(evaluationTime);
    }

    public OpenPGPUserId getUserId(String userId) {
        for (OpenPGPUserId uid : this.primaryKey.getUserIDs()) {
            if (!uid.getUserId().equals(userId)) continue;
            return uid;
        }
        return null;
    }

    public Date getExpirationTime() {
        return this.getExpirationTime(new Date());
    }

    public Date getExpirationTime(Date evaluationTime) {
        return this.getPrimaryKey().getKeyExpirationDateAt(evaluationTime);
    }

    public OpenPGPSignatureChain getDelegationBy(OpenPGPCertificate thirdPartyCertificate) {
        return this.getDelegationBy(thirdPartyCertificate, new Date());
    }

    public OpenPGPSignatureChain getDelegationBy(OpenPGPCertificate thirdPartyCertificate, Date evaluationTime) {
        OpenPGPSignatureChains chainsBy = this.getPrimaryKey().getMergedDanglingExternalSignatureChainEndsFrom(thirdPartyCertificate, evaluationTime);
        return chainsBy.getCertificationAt(evaluationTime);
    }

    public OpenPGPSignatureChain getRevocationBy(OpenPGPCertificate thirdPartyCertificate) {
        return this.getRevocationBy(thirdPartyCertificate, new Date());
    }

    public OpenPGPSignatureChain getRevocationBy(OpenPGPCertificate thirdPartyCertificate, Date evaluationTime) {
        OpenPGPSignatureChains chainsBy = this.getPrimaryKey().getMergedDanglingExternalSignatureChainEndsFrom(thirdPartyCertificate, evaluationTime);
        return chainsBy.getRevocationAt(evaluationTime);
    }

    private List<OpenPGPComponentKey> filterKeys(Date evaluationTime, KeyFilter filter) {
        ArrayList<OpenPGPComponentKey> result = new ArrayList<OpenPGPComponentKey>();
        for (OpenPGPComponentKey key : this.getKeys()) {
            if (!this.isBound(key, evaluationTime) || !filter.test(key, evaluationTime)) continue;
            result.add(key);
        }
        return result;
    }

    private void addSignaturesToChains(List<OpenPGPComponentSignature> signatures, OpenPGPSignatureChains chains) {
        Iterator<OpenPGPComponentSignature> it = signatures.iterator();
        while (it.hasNext()) {
            chains.add(OpenPGPSignatureChain.direct(it.next()));
        }
    }

    private static interface KeyFilter {
        public boolean test(OpenPGPComponentKey var1, Date var2);
    }

    public static abstract class OpenPGPCertificateComponent {
        private final OpenPGPCertificate certificate;

        public OpenPGPCertificateComponent(OpenPGPCertificate certificate) {
            this.certificate = certificate;
        }

        public OpenPGPCertificate getCertificate() {
            return this.certificate;
        }

        public abstract String toDetailString();

        public boolean isBound() {
            return this.isBoundAt(new Date());
        }

        public boolean isBoundAt(Date evaluationTime) {
            return this.getCertificate().isBound(this, evaluationTime);
        }

        public OpenPGPSignatureChains getSignatureChains() {
            OpenPGPPrimaryKey pk;
            OpenPGPSignatureChains chains = this.getCertificate().getAllSignatureChainsFor(this);
            if (this.getPublicComponent() instanceof OpenPGPPrimaryKey && !(pk = (OpenPGPPrimaryKey)this.getPublicComponent()).getUserIDs().isEmpty()) {
                chains.addAll(this.getCertificate().getAllSignatureChainsFor(pk.getUserIDs().get(0)));
            }
            return chains;
        }

        public OpenPGPComponentSignature getCertification(Date evaluationTime) {
            OpenPGPSignatureChain certification = this.getSignatureChains().getCertificationAt(evaluationTime);
            if (certification != null) {
                return certification.getSignature();
            }
            return null;
        }

        public OpenPGPComponentSignature getRevocation(Date evaluationTime) {
            OpenPGPSignatureChain revocation = this.getSignatureChains().getRevocationAt(evaluationTime);
            if (revocation != null) {
                return revocation.getSignature();
            }
            return null;
        }

        public OpenPGPComponentSignature getLatestSelfSignature() {
            return this.getLatestSelfSignature(new Date());
        }

        public abstract OpenPGPComponentSignature getLatestSelfSignature(Date var1);

        protected OpenPGPCertificateComponent getPublicComponent() {
            return this;
        }

        protected abstract OpenPGPComponentKey getKeyComponent();

        public KeyFlags getKeyFlags() {
            return this.getKeyFlags(new Date());
        }

        public KeyFlags getKeyFlags(Date evaluationTime) {
            OpenPGPSignature.OpenPGPSignatureSubpacket subpacket = this.getApplyingSubpacket(evaluationTime, 27);
            if (subpacket != null) {
                return (KeyFlags)subpacket.getSubpacket();
            }
            return null;
        }

        public boolean hasKeyFlags(Date evaluationTime, int ... flags) {
            KeyFlags keyFlags = this.getKeyFlags(evaluationTime);
            if (keyFlags == null) {
                return false;
            }
            for (int i = 0; i < flags.length; ++i) {
                if ((keyFlags.getFlags() & flags[i]) != flags[i]) continue;
                return true;
            }
            return false;
        }

        public Features getFeatures() {
            return this.getFeatures(new Date());
        }

        public Features getFeatures(Date evaluationTime) {
            OpenPGPSignature.OpenPGPSignatureSubpacket subpacket = this.getApplyingSubpacket(evaluationTime, 30);
            if (subpacket != null) {
                return (Features)subpacket.getSubpacket();
            }
            return null;
        }

        public PreferredAEADCiphersuites getAEADCipherSuitePreferences() {
            return this.getAEADCipherSuitePreferences(new Date());
        }

        public PreferredAEADCiphersuites getAEADCipherSuitePreferences(Date evaluationTime) {
            OpenPGPSignature.OpenPGPSignatureSubpacket subpacket = this.getApplyingSubpacket(evaluationTime, 39);
            if (subpacket != null) {
                return (PreferredAEADCiphersuites)subpacket.getSubpacket();
            }
            return null;
        }

        public PreferredAlgorithms getSymmetricCipherPreferences() {
            return this.getSymmetricCipherPreferences(new Date());
        }

        public PreferredAlgorithms getSymmetricCipherPreferences(Date evaluationTime) {
            OpenPGPSignature.OpenPGPSignatureSubpacket subpacket = this.getApplyingSubpacket(evaluationTime, 11);
            if (subpacket != null) {
                return (PreferredAlgorithms)subpacket.getSubpacket();
            }
            return null;
        }

        public PreferredAlgorithms getHashAlgorithmPreferences() {
            return this.getHashAlgorithmPreferences(new Date());
        }

        public PreferredAlgorithms getHashAlgorithmPreferences(Date evaluationTime) {
            OpenPGPSignature.OpenPGPSignatureSubpacket subpacket = this.getApplyingSubpacket(evaluationTime, 21);
            if (subpacket != null) {
                return (PreferredAlgorithms)subpacket.getSubpacket();
            }
            return null;
        }

        public PreferredAlgorithms getCompressionAlgorithmPreferences() {
            return this.getCompressionAlgorithmPreferences(new Date());
        }

        public PreferredAlgorithms getCompressionAlgorithmPreferences(Date evaluationTime) {
            OpenPGPSignature.OpenPGPSignatureSubpacket subpacket = this.getApplyingSubpacket(evaluationTime, 22);
            if (subpacket != null) {
                return (PreferredAlgorithms)subpacket.getSubpacket();
            }
            return null;
        }

        public Date getKeyExpirationDate() {
            return this.getKeyExpirationDateAt(new Date());
        }

        public Date getKeyExpirationDateAt(Date evaluationTime) {
            return this.getLatestSelfSignature(evaluationTime).getKeyExpirationTime();
        }

        protected OpenPGPSignature.OpenPGPSignatureSubpacket getApplyingSubpacket(Date evaluationTime, int subpacketType) {
            SignatureSubpacket subpacket;
            OpenPGPSignatureChain binding = this.getSignatureChains().getCertificationAt(evaluationTime);
            if (binding == null) {
                return null;
            }
            try {
                if (!binding.isValid()) {
                    return null;
                }
            }
            catch (PGPSignatureException e) {
                return null;
            }
            OpenPGPComponentSignature keySignature = binding.getSignature();
            PGPSignatureSubpacketVector hashedSubpackets = keySignature.getSignature().getHashedSubPackets();
            if (hashedSubpackets == null || !hashedSubpackets.hasSubpacket(subpacketType)) {
                OpenPGPSignatureChain preferenceBinding = this.getCertificate().getPreferenceSignature(evaluationTime);
                if (preferenceBinding == null) {
                    return null;
                }
                keySignature = preferenceBinding.getSignature();
                hashedSubpackets = keySignature.getSignature().getHashedSubPackets();
            }
            if ((subpacket = hashedSubpackets.getSubpacket(subpacketType)) == null) {
                return null;
            }
            return OpenPGPSignature.OpenPGPSignatureSubpacket.hashed(subpacket, keySignature);
        }

        protected OpenPGPSignatureChains getMergedDanglingExternalSignatureChainEndsFrom(OpenPGPCertificate thirdPartyCertificate, Date evaluationTime) {
            OpenPGPSignatureChains chainsBy = new OpenPGPSignatureChains(this);
            OpenPGPSignatureChains allChains = this.getCertificate().getAllSignatureChainsFor(this).getChainsAt(evaluationTime);
            Iterator<OpenPGPSignatureChain> it = allChains.iterator();
            while (it.hasNext()) {
                OpenPGPSignatureChain.Link rootLink = it.next().getRootLink();
                for (OpenPGPComponentKey issuerKey : thirdPartyCertificate.getKeys()) {
                    if (!KeyIdentifier.matches(rootLink.getSignature().getKeyIdentifiers(), issuerKey.getKeyIdentifier(), true)) continue;
                    OpenPGPSignatureChain externalChain = issuerKey.getSignatureChains().getChainAt(evaluationTime);
                    externalChain = externalChain.plus(new OpenPGPComponentSignature(rootLink.signature.getSignature(), issuerKey, this));
                    chainsBy.add(externalChain);
                }
            }
            return chainsBy;
        }
    }

    public static abstract class OpenPGPComponentKey
    extends OpenPGPCertificateComponent {
        protected final PGPPublicKey rawPubkey;

        public OpenPGPComponentKey(PGPPublicKey rawPubkey, OpenPGPCertificate certificate) {
            super(certificate);
            this.rawPubkey = rawPubkey;
        }

        public PGPPublicKey getPGPPublicKey() {
            return this.rawPubkey;
        }

        public KeyIdentifier getKeyIdentifier() {
            return this.rawPubkey.getKeyIdentifier();
        }

        public int getAlgorithm() {
            return this.getPGPPublicKey().getAlgorithm();
        }

        public int getVersion() {
            return this.getPGPPublicKey().getVersion();
        }

        public Date getCreationTime() {
            return this.rawPubkey.getCreationTime();
        }

        public abstract boolean isPrimaryKey();

        public OpenPGPComponentSignature getLatestSelfSignature(Date evaluationTime) {
            OpenPGPSignatureChain currentDKChain = this.getSignatureChains().getChainAt(evaluationTime);
            if (currentDKChain != null && !currentDKChain.chainLinks.isEmpty()) {
                return currentDKChain.getSignature();
            }
            return null;
        }

        public boolean isEncryptionKey() {
            return this.isEncryptionKey(new Date());
        }

        public boolean isEncryptionKey(Date evaluationTime) {
            if (!this.rawPubkey.isEncryptionKey()) {
                return false;
            }
            return this.hasKeyFlags(evaluationTime, 8) || this.hasKeyFlags(evaluationTime, 4);
        }

        public boolean isSigningKey() {
            return this.isSigningKey(new Date());
        }

        public boolean isSigningKey(Date evaluationTime) {
            if (!PublicKeyUtils.isSigningAlgorithm(this.rawPubkey.getAlgorithm())) {
                return false;
            }
            return this.hasKeyFlags(evaluationTime, 2);
        }

        public boolean isCertificationKey() {
            return this.isCertificationKey(new Date());
        }

        public boolean isCertificationKey(Date evaluationTime) {
            if (!PublicKeyUtils.isSigningAlgorithm(this.rawPubkey.getAlgorithm())) {
                return false;
            }
            return this.hasKeyFlags(evaluationTime, 1);
        }

        protected OpenPGPComponentKey getKeyComponent() {
            return this;
        }

        public int hashCode() {
            return this.getPGPPublicKey().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof OpenPGPComponentKey)) {
                return false;
            }
            OpenPGPComponentKey other = (OpenPGPComponentKey)obj;
            return this.getPGPPublicKey().equals(other.getPGPPublicKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OpenPGPComponentSignature
    extends OpenPGPSignature {
        private final OpenPGPCertificateComponent target;

        public OpenPGPComponentSignature(PGPSignature signature, OpenPGPComponentKey issuer, OpenPGPCertificateComponent target) {
            super(signature, issuer);
            this.target = target;
        }

        public OpenPGPComponentKey getIssuerComponent() {
            return this.getIssuer();
        }

        public OpenPGPCertificateComponent getTargetComponent() {
            return this.target;
        }

        public OpenPGPComponentKey getTargetKeyComponent() {
            if (this.getTargetComponent() instanceof OpenPGPIdentityComponent) {
                return ((OpenPGPIdentityComponent)this.getTargetComponent()).getPrimaryKey();
            }
            if (this.getTargetComponent() instanceof OpenPGPComponentKey) {
                return (OpenPGPComponentKey)this.getTargetComponent();
            }
            throw new IllegalArgumentException("Unknown target type.");
        }

        public Date getKeyExpirationTime() {
            PGPSignatureSubpacketVector hashed = this.signature.getHashedSubPackets();
            if (hashed == null) {
                return null;
            }
            long exp = hashed.getKeyExpirationTime();
            if (exp < 0L) {
                throw new RuntimeException("Negative key expiration time");
            }
            if (exp == 0L) {
                return null;
            }
            return new Date(this.getTargetKeyComponent().getCreationTime().getTime() + 1000L * exp);
        }

        public void verify(OpenPGPImplementation implementation) throws PGPSignatureException {
            this.verify(implementation.pgpContentVerifierBuilderProvider(), implementation.policy());
        }

        public void verify(PGPContentVerifierBuilderProvider contentVerifierBuilderProvider, OpenPGPPolicy policy) throws PGPSignatureException {
            if (this.issuer == null) {
                throw new MissingIssuerCertException(this, "Issuer certificate unavailable.");
            }
            this.sanitize(this.issuer, policy);
            if (this.signature.getSignatureType() == 31 || this.signature.getSignatureType() == 32) {
                this.verifyKeySignature(this.issuer, this.target.getKeyComponent(), contentVerifierBuilderProvider);
            } else if (this.signature.getSignatureType() == 24) {
                this.verifyEmbeddedPrimaryKeyBinding(contentVerifierBuilderProvider, policy, this.getCreationTime());
                if (((OpenPGPSubkey)this.target).getCreationTime().after(this.signature.getCreationTime())) {
                    this.isCorrect = false;
                    throw new MalformedOpenPGPSignatureException(this, "Subkey binding signature predates subkey creation time.");
                }
                this.verifyKeySignature(this.issuer, (OpenPGPSubkey)this.target, contentVerifierBuilderProvider);
            } else if (this.signature.getSignatureType() == 40) {
                if (((OpenPGPSubkey)this.target).getCreationTime().after(this.signature.getCreationTime())) {
                    this.isCorrect = false;
                    throw new MalformedOpenPGPSignatureException(this, "Subkey revocation signature predates subkey creation time.");
                }
                this.verifyKeySignature(this.issuer, (OpenPGPSubkey)this.target, contentVerifierBuilderProvider);
            } else if (this.target instanceof OpenPGPUserId) {
                this.verifyUserIdSignature(this.issuer, (OpenPGPUserId)this.target, contentVerifierBuilderProvider);
            } else if (this.target instanceof OpenPGPUserAttribute) {
                this.verifyUserAttributeSignature(this.issuer, (OpenPGPUserAttribute)this.target, contentVerifierBuilderProvider);
            } else {
                throw new PGPSignatureException("Unexpected signature type: " + this.getType());
            }
        }

        private void verifyEmbeddedPrimaryKeyBinding(PGPContentVerifierBuilderProvider contentVerifierBuilderProvider, OpenPGPPolicy policy, Date signatureCreationTime) throws PGPSignatureException {
            int keyFlags = this.signature.getHashedSubPackets().getKeyFlags();
            if ((keyFlags & 2) != 2) {
                return;
            }
            OpenPGPComponentKey subkey = this.getTargetKeyComponent();
            ArrayList<PGPSignature> embeddedSignatures = new ArrayList<PGPSignature>();
            try {
                PGPSignatureList sigList = this.signature.getHashedSubPackets().getEmbeddedSignatures();
                OpenPGPComponentSignature.addSignatures(embeddedSignatures, sigList);
                sigList = this.signature.getUnhashedSubPackets().getEmbeddedSignatures();
                OpenPGPComponentSignature.addSignatures(embeddedSignatures, sigList);
            }
            catch (PGPException e) {
                throw new PGPSignatureException("Cannot extract embedded signature.", e);
            }
            if (embeddedSignatures.isEmpty()) {
                throw new MalformedOpenPGPSignatureException(this, "Signing key SubkeyBindingSignature MUST contain embedded PrimaryKeyBindingSignature.");
            }
            PGPSignatureException exception = null;
            for (PGPSignature primaryKeyBinding : embeddedSignatures) {
                OpenPGPComponentSignature backSig = new OpenPGPComponentSignature(primaryKeyBinding, subkey, this.issuer);
                if (primaryKeyBinding.getSignatureType() != 25) {
                    exception = new PGPSignatureException("Unexpected embedded signature type: " + primaryKeyBinding.getSignatureType());
                    continue;
                }
                if (!backSig.isEffectiveAt(signatureCreationTime)) {
                    exception = new PGPSignatureException("Embedded PrimaryKeyBinding signature is expired or not yet effective.");
                    continue;
                }
                try {
                    backSig.sanitize(subkey, policy);
                    backSig.verifyKeySignature(subkey, this.issuer, contentVerifierBuilderProvider);
                    return;
                }
                catch (PGPSignatureException e) {
                    exception = e;
                }
            }
            throw exception;
        }

        private static void addSignatures(List<PGPSignature> embeddedSignatures, PGPSignatureList sigList) {
            Iterator<PGPSignature> it = sigList.iterator();
            while (it.hasNext()) {
                embeddedSignatures.add(it.next());
            }
        }

        protected void verifyKeySignature(OpenPGPComponentKey issuer, OpenPGPComponentKey target, PGPContentVerifierBuilderProvider contentVerifierBuilderProvider) throws PGPSignatureException {
            this.isTested = true;
            try {
                this.signature.init(contentVerifierBuilderProvider, issuer.getPGPPublicKey());
                this.isCorrect = this.signature.getSignatureType() == 31 || this.signature.getSignatureType() == 32 ? this.signature.verifyCertification(target.getPGPPublicKey()) : (this.signature.getSignatureType() == 25 ? this.signature.verifyCertification(target.getPGPPublicKey(), issuer.getPGPPublicKey()) : this.signature.verifyCertification(issuer.getPGPPublicKey(), target.getPGPPublicKey()));
                if (!this.isCorrect) {
                    throw new IncorrectOpenPGPSignatureException(this, "Key Signature is not correct.");
                }
            }
            catch (PGPException e) {
                this.isCorrect = false;
                throw new PGPSignatureException("Key Signature could not be verified.", e);
            }
        }

        protected void verifyUserIdSignature(OpenPGPComponentKey issuer, OpenPGPUserId target, PGPContentVerifierBuilderProvider contentVerifierBuilderProvider) throws PGPSignatureException {
            this.isTested = true;
            try {
                this.signature.init(contentVerifierBuilderProvider, issuer.getPGPPublicKey());
                this.isCorrect = this.signature.verifyCertification(target.getUserId(), target.getPrimaryKey().getPGPPublicKey());
                if (!this.isCorrect) {
                    throw new IncorrectOpenPGPSignatureException(this, "UserID Signature is not correct.");
                }
            }
            catch (PGPException e) {
                this.isCorrect = false;
                throw new PGPSignatureException("UserID Signature could not be verified.", e);
            }
        }

        protected void verifyUserAttributeSignature(OpenPGPComponentKey issuer, OpenPGPUserAttribute target, PGPContentVerifierBuilderProvider contentVerifierBuilderProvider) throws PGPSignatureException {
            this.isTested = true;
            try {
                this.signature.init(contentVerifierBuilderProvider, issuer.getPGPPublicKey());
                this.isCorrect = this.signature.verifyCertification(target.getUserAttribute(), target.getPrimaryKey().getPGPPublicKey());
                if (!this.isCorrect) {
                    throw new IncorrectOpenPGPSignatureException(this, "UserAttribute Signature is not correct.");
                }
            }
            catch (PGPException e) {
                this.isCorrect = false;
                throw new PGPSignatureException("Could not verify UserAttribute Signature.", e);
            }
        }

        @Override
        protected String getTargetDisplay() {
            return this.target.toString();
        }
    }

    public static abstract class OpenPGPIdentityComponent
    extends OpenPGPCertificateComponent {
        private final OpenPGPPrimaryKey primaryKey;

        public OpenPGPIdentityComponent(OpenPGPPrimaryKey primaryKey) {
            super(primaryKey.getCertificate());
            this.primaryKey = primaryKey;
        }

        public OpenPGPPrimaryKey getPrimaryKey() {
            return this.primaryKey;
        }

        public OpenPGPComponentSignature getLatestSelfSignature(Date evaluationTime) {
            OpenPGPSignatureChain currentChain = this.getSignatureChains().getChainAt(evaluationTime);
            if (currentChain != null && !currentChain.chainLinks.isEmpty()) {
                return currentChain.getSignature();
            }
            return null;
        }

        protected OpenPGPComponentKey getKeyComponent() {
            return this.primaryKey;
        }

        public OpenPGPSignatureChain getCertificationBy(OpenPGPCertificate thirdPartyCertificate) {
            return this.getCertificationBy(thirdPartyCertificate, new Date());
        }

        public OpenPGPSignatureChain getCertificationBy(OpenPGPCertificate thirdPartyCertificate, Date evaluationTime) {
            OpenPGPSignatureChains chainsBy = this.getMergedDanglingExternalSignatureChainEndsFrom(thirdPartyCertificate, evaluationTime);
            return chainsBy.getCertificationAt(evaluationTime);
        }

        public OpenPGPSignatureChain getRevocationBy(OpenPGPCertificate thirdPartyCertificate) {
            return this.getRevocationBy(thirdPartyCertificate, new Date());
        }

        public OpenPGPSignatureChain getRevocationBy(OpenPGPCertificate thirdPartyCertificate, Date evaluationTime) {
            OpenPGPSignatureChains chainsBy = this.getMergedDanglingExternalSignatureChainEndsFrom(thirdPartyCertificate, evaluationTime);
            return chainsBy.getRevocationAt(evaluationTime);
        }

        public String toDetailString() {
            return this.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OpenPGPPrimaryKey
    extends OpenPGPComponentKey {
        protected final List<OpenPGPIdentityComponent> identityComponents = new ArrayList<OpenPGPIdentityComponent>();

        public String toString() {
            return "PrimaryKey[" + Long.toHexString(this.getKeyIdentifier().getKeyId()).toUpperCase(Locale.getDefault()) + "]";
        }

        @Override
        public String toDetailString() {
            return "PrimaryKey[" + this.getKeyIdentifier() + "] (" + UTCUtil.format(this.getCreationTime()) + ")";
        }

        public OpenPGPPrimaryKey(PGPPublicKey rawPubkey, OpenPGPCertificate certificate) {
            super(rawPubkey, certificate);
            Iterator<String> userIds = rawPubkey.getUserIDs();
            while (userIds.hasNext()) {
                this.identityComponents.add(new OpenPGPUserId(userIds.next(), this));
            }
            Iterator<PGPUserAttributeSubpacketVector> userAttributes = rawPubkey.getUserAttributes();
            while (userAttributes.hasNext()) {
                this.identityComponents.add(new OpenPGPUserAttribute(userAttributes.next(), this));
            }
        }

        @Override
        public boolean isPrimaryKey() {
            return true;
        }

        public OpenPGPComponentSignature getLatestDirectKeySelfSignature() {
            return this.getLatestDirectKeySelfSignature(new Date());
        }

        public OpenPGPComponentSignature getLatestDirectKeySelfSignature(Date evaluationTime) {
            OpenPGPSignatureChain currentDKChain = this.getCertificate().getAllSignatureChainsFor(this).getCertificationAt(evaluationTime);
            if (currentDKChain != null && !currentDKChain.chainLinks.isEmpty()) {
                return currentDKChain.getSignature();
            }
            return null;
        }

        public OpenPGPComponentSignature getLatestKeyRevocationSelfSignature() {
            return this.getLatestKeyRevocationSelfSignature(new Date());
        }

        public OpenPGPComponentSignature getLatestKeyRevocationSelfSignature(Date evaluationTime) {
            OpenPGPSignatureChain currentRevocationChain = this.getCertificate().getAllSignatureChainsFor(this).getRevocationAt(evaluationTime);
            if (currentRevocationChain != null && !currentRevocationChain.chainLinks.isEmpty()) {
                return currentRevocationChain.getSignature();
            }
            return null;
        }

        @Override
        public OpenPGPComponentSignature getLatestSelfSignature(Date evaluationTime) {
            OpenPGPComponentSignature keyRevocation;
            ArrayList<OpenPGPComponentSignature> signatures = new ArrayList<OpenPGPComponentSignature>();
            OpenPGPComponentSignature directKeySig = this.getLatestDirectKeySelfSignature(evaluationTime);
            if (directKeySig != null) {
                signatures.add(directKeySig);
            }
            if ((keyRevocation = this.getLatestKeyRevocationSelfSignature(evaluationTime)) != null) {
                signatures.add(keyRevocation);
            }
            Iterator<OpenPGPIdentityComponent> it = this.getCertificate().getIdentities().iterator();
            while (it.hasNext()) {
                OpenPGPComponentSignature identitySig = it.next().getLatestSelfSignature(evaluationTime);
                if (identitySig == null) continue;
                signatures.add(identitySig);
            }
            OpenPGPComponentSignature latest = null;
            for (OpenPGPComponentSignature signature : signatures) {
                if (latest != null && !signature.getCreationTime().after(latest.getCreationTime())) continue;
                latest = signature;
            }
            return latest;
        }

        public List<OpenPGPUserId> getUserIDs() {
            ArrayList<OpenPGPUserId> userIds = new ArrayList<OpenPGPUserId>();
            for (OpenPGPIdentityComponent identity : this.identityComponents) {
                if (!(identity instanceof OpenPGPUserId)) continue;
                userIds.add((OpenPGPUserId)identity);
            }
            return userIds;
        }

        public List<OpenPGPUserId> getValidUserIds() {
            return this.getValidUserIDs(new Date());
        }

        public List<OpenPGPUserId> getValidUserIDs(Date evaluationTime) {
            ArrayList<OpenPGPUserId> userIds = new ArrayList<OpenPGPUserId>();
            for (OpenPGPIdentityComponent identity : this.identityComponents) {
                if (!(identity instanceof OpenPGPUserId) || !identity.isBoundAt(evaluationTime)) continue;
                userIds.add((OpenPGPUserId)identity);
            }
            return userIds;
        }

        public OpenPGPUserId getExplicitPrimaryUserId(Date evaluationTime) {
            OpenPGPSignature latestBinding = null;
            OpenPGPUserId latestUid = null;
            for (OpenPGPUserId userId : this.getUserIDs()) {
                PrimaryUserID primaryUserId;
                OpenPGPSignature.OpenPGPSignatureSubpacket subpacket = userId.getApplyingSubpacket(evaluationTime, 25);
                if (subpacket == null || !(primaryUserId = (PrimaryUserID)subpacket.getSubpacket()).isPrimaryUserID() || latestBinding != null && !subpacket.getSignature().getCreationTime().after(latestBinding.getCreationTime())) continue;
                latestBinding = subpacket.getSignature();
                latestUid = userId;
            }
            return latestUid;
        }

        public OpenPGPUserId getExplicitOrImplicitPrimaryUserId(Date evaluationTime) {
            OpenPGPUserId explicitPrimaryUserId = this.getExplicitPrimaryUserId(evaluationTime);
            if (explicitPrimaryUserId != null) {
                return explicitPrimaryUserId;
            }
            OpenPGPComponentSignature oldestBinding = null;
            OpenPGPUserId oldestUid = null;
            for (OpenPGPUserId userId : this.getUserIDs()) {
                OpenPGPSignatureChain chain = userId.getSignatureChains().getCertificationAt(evaluationTime);
                if (chain == null) continue;
                OpenPGPComponentSignature binding = chain.getSignature();
                if (oldestBinding != null && !binding.getCreationTime().before(oldestBinding.getCreationTime())) continue;
                oldestBinding = binding;
                oldestUid = userId;
            }
            return oldestUid;
        }

        public List<OpenPGPUserAttribute> getUserAttributes() {
            ArrayList<OpenPGPUserAttribute> userAttributes = new ArrayList<OpenPGPUserAttribute>();
            for (OpenPGPIdentityComponent identity : this.identityComponents) {
                if (!(identity instanceof OpenPGPUserAttribute)) continue;
                userAttributes.add((OpenPGPUserAttribute)identity);
            }
            return userAttributes;
        }

        protected List<OpenPGPComponentSignature> getKeySignatures() {
            Iterator<PGPSignature> iterator = this.rawPubkey.getSignatures();
            ArrayList<OpenPGPComponentSignature> list = new ArrayList<OpenPGPComponentSignature>();
            while (iterator.hasNext()) {
                PGPSignature sig = iterator.next();
                int type = sig.getSignatureType();
                if (type != 31 && type != 32) continue;
                OpenPGPComponentKey issuer = this.getCertificate().getSigningKeyFor(sig);
                list.add(new OpenPGPComponentSignature(sig, issuer, this));
            }
            return list;
        }

        protected List<OpenPGPComponentSignature> getUserIdSignatures(OpenPGPUserId identity) {
            Iterator<PGPSignature> iterator = this.rawPubkey.getSignaturesForID(identity.getUserId());
            return this.signIterToList(identity, iterator);
        }

        protected List<OpenPGPComponentSignature> getUserAttributeSignatures(OpenPGPUserAttribute identity) {
            Iterator<PGPSignature> iterator = this.rawPubkey.getSignaturesForUserAttribute(identity.getUserAttribute());
            return this.signIterToList(identity, iterator);
        }

        private List<OpenPGPComponentSignature> signIterToList(OpenPGPIdentityComponent identity, Iterator<PGPSignature> iterator) {
            ArrayList<OpenPGPComponentSignature> list = new ArrayList<OpenPGPComponentSignature>();
            while (iterator.hasNext()) {
                PGPSignature sig = iterator.next();
                OpenPGPComponentKey issuer = this.getCertificate().getSigningKeyFor(sig);
                list.add(new OpenPGPComponentSignature(sig, issuer, identity));
            }
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OpenPGPSignatureChain
    implements Comparable<OpenPGPSignatureChain>,
    Iterable<Link> {
        private final List<Link> chainLinks = new ArrayList<Link>();

        private OpenPGPSignatureChain(Link rootLink) {
            this.chainLinks.add(rootLink);
        }

        private OpenPGPSignatureChain(List<Link> links) {
            this.chainLinks.addAll(links);
        }

        private OpenPGPSignatureChain(OpenPGPSignatureChain copy) {
            this(copy.chainLinks);
        }

        public OpenPGPComponentSignature getSignature() {
            return this.getLeafLink().getSignature();
        }

        public OpenPGPComponentSignature getRevocation() {
            for (OpenPGPComponentSignature signature : this.getSignatures()) {
                if (!signature.isRevocation()) continue;
                return signature;
            }
            return null;
        }

        public List<OpenPGPComponentSignature> getSignatures() {
            ArrayList<OpenPGPComponentSignature> signatures = new ArrayList<OpenPGPComponentSignature>();
            for (Link link : this.chainLinks) {
                signatures.add(link.getSignature());
            }
            return signatures;
        }

        public OpenPGPSignatureChain plus(OpenPGPComponentSignature sig) {
            if (this.getLeafLinkTargetKey() != sig.getIssuerComponent()) {
                throw new IllegalArgumentException("Chain head is not equal to link issuer.");
            }
            OpenPGPSignatureChain chain = new OpenPGPSignatureChain(this);
            chain.chainLinks.add(Link.create(sig));
            return chain;
        }

        public static OpenPGPSignatureChain direct(OpenPGPComponentSignature sig) {
            return new OpenPGPSignatureChain(Link.create(sig));
        }

        public Link getRootLink() {
            return this.chainLinks.get(0);
        }

        public OpenPGPComponentKey getRootLinkIssuer() {
            return this.getRootLink().getSignature().getIssuer();
        }

        public Link getLeafLink() {
            return this.chainLinks.get(this.chainLinks.size() - 1);
        }

        public OpenPGPComponentKey getLeafLinkTargetKey() {
            return this.getSignature().getTargetKeyComponent();
        }

        public boolean isCertification() {
            Iterator<Link> it = this.chainLinks.iterator();
            while (it.hasNext()) {
                if (!(it.next() instanceof Revocation)) continue;
                return false;
            }
            return true;
        }

        public boolean isRevocation() {
            Iterator<Link> it = this.chainLinks.iterator();
            while (it.hasNext()) {
                if (!(it.next() instanceof Revocation)) continue;
                return true;
            }
            return false;
        }

        public boolean isHardRevocation() {
            Iterator<Link> it = this.chainLinks.iterator();
            while (it.hasNext()) {
                if (!it.next().signature.signature.isHardRevocation()) continue;
                return true;
            }
            return false;
        }

        public Date getSince() {
            Date latestDate = null;
            for (Link link : this.chainLinks) {
                OpenPGPComponentSignature signature = link.getSignature();
                Date currentDate = signature.getCreationTime();
                if (latestDate != null && !currentDate.after(latestDate)) continue;
                latestDate = currentDate;
            }
            return latestDate;
        }

        public Date getUntil() {
            Date soonestExpiration = null;
            for (Link link : this.chainLinks) {
                Date until = link.until();
                if (until == null) continue;
                soonestExpiration = soonestExpiration == null ? until : (until.before(soonestExpiration) ? until : soonestExpiration);
            }
            return soonestExpiration;
        }

        public boolean isEffectiveAt(Date evaluationDate) {
            if (this.isHardRevocation()) {
                return true;
            }
            Date since = this.getSince();
            Date until = this.getUntil();
            return !evaluationDate.before(since) && (until == null || !evaluationDate.after(until));
        }

        public boolean isValid() throws PGPSignatureException {
            OpenPGPComponentKey rootKey = this.getRootLinkIssuer();
            if (rootKey == null) {
                throw new MissingIssuerCertException(this.getRootLink().signature, "Missing issuer certificate.");
            }
            OpenPGPCertificate cert = rootKey.getCertificate();
            return this.isValid(cert.implementation.pgpContentVerifierBuilderProvider(), cert.policy);
        }

        public boolean isValid(PGPContentVerifierBuilderProvider contentVerifierBuilderProvider, OpenPGPPolicy policy) throws PGPSignatureException {
            boolean correct = true;
            for (Link link : this.chainLinks) {
                if (!link.signature.isTested) {
                    link.verify(contentVerifierBuilderProvider, policy);
                }
                if (link.signature.isCorrect) continue;
                correct = false;
            }
            return correct;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            String until = this.getUntil() == null ? "EndOfTime" : UTCUtil.format(this.getUntil());
            b.append("From ").append(UTCUtil.format(this.getSince())).append(" until ").append(until).append("\n");
            for (Link link : this.chainLinks) {
                b.append("  ").append(link.toString()).append("\n");
            }
            return b.toString();
        }

        @Override
        public int compareTo(OpenPGPSignatureChain other) {
            if (this == other) {
                return 0;
            }
            if (this.isHardRevocation()) {
                return -1;
            }
            if (other.isHardRevocation()) {
                return 1;
            }
            int compare = -this.getRootLink().since().compareTo(other.getRootLink().since());
            if (compare != 0) {
                return compare;
            }
            compare = -this.getLeafLink().since().compareTo(other.getLeafLink().since());
            if (compare != 0) {
                return compare;
            }
            if (this.isRevocation()) {
                return 1;
            }
            return -1;
        }

        @Override
        public Iterator<Link> iterator() {
            return this.chainLinks.iterator();
        }

        public static class Certification
        extends Link {
            public Certification(OpenPGPComponentSignature signature) {
                super(signature);
            }
        }

        public static abstract class Link {
            protected final OpenPGPComponentSignature signature;

            public Link(OpenPGPComponentSignature signature) {
                this.signature = signature;
            }

            public Date since() {
                return this.signature.getCreationTime();
            }

            public Date until() {
                Date backSigExpiration = this.getBackSigExpirationTime();
                Date expirationTime = this.signature.getExpirationTime();
                if (expirationTime == null) {
                    return backSigExpiration;
                }
                if (backSigExpiration == null || expirationTime.before(backSigExpiration)) {
                    return expirationTime;
                }
                return backSigExpiration;
            }

            private Date getBackSigExpirationTime() {
                if (this.signature.getSignature().getSignatureType() != 24) {
                    return null;
                }
                PGPSignatureSubpacketVector hashedSubpackets = this.signature.getSignature().getHashedSubPackets();
                if (hashedSubpackets == null) {
                    return null;
                }
                int keyFlags = this.signature.getSignature().getHashedSubPackets().getKeyFlags();
                if ((keyFlags & 2) != 2) {
                    return null;
                }
                try {
                    PGPSignatureList embeddedSigs = hashedSubpackets.getEmbeddedSignatures();
                    if (!embeddedSigs.isEmpty()) {
                        OpenPGPComponentSignature backSig = new OpenPGPComponentSignature(embeddedSigs.get(0), this.getSignature().getTargetKeyComponent(), this.getSignature().getIssuer());
                        return backSig.getExpirationTime();
                    }
                    return null;
                }
                catch (PGPException e) {
                    return null;
                }
            }

            public boolean verify(PGPContentVerifierBuilderProvider contentVerifierBuilderProvider, OpenPGPPolicy policy) throws PGPSignatureException {
                this.signature.verify(contentVerifierBuilderProvider, policy);
                return true;
            }

            public String toString() {
                return this.signature.toString();
            }

            public static Link create(OpenPGPComponentSignature signature) {
                if (signature.isRevocation()) {
                    return new Revocation(signature);
                }
                return new Certification(signature);
            }

            public OpenPGPComponentSignature getSignature() {
                return this.signature;
            }
        }

        public static class Revocation
        extends Link {
            public Revocation(OpenPGPComponentSignature signature) {
                super(signature);
            }

            public Date since() {
                if (this.signature.signature.isHardRevocation()) {
                    return new Date(0L);
                }
                return super.since();
            }

            public Date until() {
                if (this.signature.signature.isHardRevocation()) {
                    return new Date(Long.MAX_VALUE);
                }
                return super.until();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OpenPGPSignatureChains
    implements Iterable<OpenPGPSignatureChain> {
        private final OpenPGPCertificateComponent targetComponent;
        private final Set<OpenPGPSignatureChain> chains = new TreeSet<OpenPGPSignatureChain>();

        public OpenPGPSignatureChains(OpenPGPCertificateComponent component) {
            this.targetComponent = component;
        }

        public void add(OpenPGPSignatureChain chain) {
            this.chains.add(chain);
        }

        public void addAll(OpenPGPSignatureChains otherChains) {
            this.chains.addAll(otherChains.chains);
        }

        public boolean isEmpty() {
            return this.chains.isEmpty();
        }

        public OpenPGPSignatureChain getCertificationAt(Date evaluationTime) {
            for (OpenPGPSignatureChain chain : this.chains) {
                boolean isEffective = chain.isEffectiveAt(evaluationTime);
                boolean isCertification = chain.isCertification();
                if (!isEffective || !isCertification) continue;
                return chain;
            }
            return null;
        }

        public OpenPGPSignatureChains getChainsAt(Date evaluationTime) {
            OpenPGPSignatureChains effectiveChains = new OpenPGPSignatureChains(this.targetComponent);
            for (OpenPGPSignatureChain chain : this.chains) {
                if (!chain.isEffectiveAt(evaluationTime)) continue;
                effectiveChains.add(chain);
            }
            return effectiveChains;
        }

        public OpenPGPSignatureChain getRevocationAt(Date evaluationTime) {
            for (OpenPGPSignatureChain chain : this.chains) {
                if (!chain.isRevocation() || !chain.isEffectiveAt(evaluationTime)) continue;
                return chain;
            }
            return null;
        }

        public String toString() {
            StringBuilder b = new StringBuilder(this.targetComponent.toDetailString()).append(" is bound with ").append(this.chains.size()).append(" chains:").append("\n");
            for (OpenPGPSignatureChain chain : this.chains) {
                b.append(chain.toString());
            }
            return b.toString();
        }

        public OpenPGPSignatureChains fromOrigin(OpenPGPComponentKey root) {
            OpenPGPSignatureChains chainsFromRoot = new OpenPGPSignatureChains(root);
            for (OpenPGPSignatureChain chain : this.chains) {
                if (chain.getRootLinkIssuer() != root) continue;
                chainsFromRoot.add(chain);
            }
            return chainsFromRoot;
        }

        public OpenPGPSignatureChain getChainAt(Date evaluationDate) {
            OpenPGPSignatureChains atDate = this.getChainsAt(evaluationDate);
            Iterator<OpenPGPSignatureChain> it = atDate.chains.iterator();
            if (it.hasNext()) {
                return it.next();
            }
            return null;
        }

        @Override
        public Iterator<OpenPGPSignatureChain> iterator() {
            return this.chains.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OpenPGPSubkey
    extends OpenPGPComponentKey {
        public OpenPGPSubkey(PGPPublicKey rawPubkey, OpenPGPCertificate certificate) {
            super(rawPubkey, certificate);
        }

        @Override
        public boolean isPrimaryKey() {
            return false;
        }

        public String toString() {
            return "Subkey[" + Long.toHexString(this.getKeyIdentifier().getKeyId()).toUpperCase(Locale.getDefault()) + "]";
        }

        @Override
        public String toDetailString() {
            return "Subkey[" + this.getKeyIdentifier() + "] (" + UTCUtil.format(this.getCreationTime()) + ")";
        }

        protected List<OpenPGPComponentSignature> getKeySignatures() {
            Iterator<PGPSignature> iterator = this.rawPubkey.getSignatures();
            ArrayList<OpenPGPComponentSignature> list = new ArrayList<OpenPGPComponentSignature>();
            while (iterator.hasNext()) {
                PGPSignature sig = iterator.next();
                int type = sig.getSignatureType();
                if (type != 24 && type != 40) continue;
                OpenPGPComponentKey issuer = this.getCertificate().getSigningKeyFor(sig);
                list.add(new OpenPGPComponentSignature(sig, issuer, this));
            }
            return list;
        }
    }

    public static class OpenPGPUserAttribute
    extends OpenPGPIdentityComponent {
        private final PGPUserAttributeSubpacketVector userAttribute;

        public OpenPGPUserAttribute(PGPUserAttributeSubpacketVector userAttribute, OpenPGPPrimaryKey primaryKey) {
            super(primaryKey);
            this.userAttribute = userAttribute;
        }

        public PGPUserAttributeSubpacketVector getUserAttribute() {
            return this.userAttribute;
        }

        public String toString() {
            return "UserAttribute" + this.userAttribute.toString();
        }
    }

    public static class OpenPGPUserId
    extends OpenPGPIdentityComponent {
        private final String userId;

        public OpenPGPUserId(String userId, OpenPGPPrimaryKey primaryKey) {
            super(primaryKey);
            this.userId = userId;
        }

        public String getUserId() {
            return this.userId;
        }

        public String toString() {
            return "UserID[" + this.userId + "]";
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof OpenPGPUserId)) {
                return false;
            }
            return this.getUserId().equals(((OpenPGPUserId)obj).getUserId());
        }

        public int hashCode() {
            return this.userId.hashCode();
        }
    }
}

