/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import org.bouncycastle.bcpg.sig.PreferredAEADCiphersuites;
import org.bouncycastle.openpgp.api.EncryptedDataPacketType;

public class MessageEncryptionMechanism {
    private final EncryptedDataPacketType mode;
    private final int symmetricKeyAlgorithm;
    private final int aeadAlgorithm;

    private MessageEncryptionMechanism(EncryptedDataPacketType mode, int symmetricKeyAlgorithm, int aeadAlgorithm) {
        this.mode = mode;
        this.symmetricKeyAlgorithm = symmetricKeyAlgorithm;
        this.aeadAlgorithm = aeadAlgorithm;
    }

    public EncryptedDataPacketType getMode() {
        return this.mode;
    }

    public int getSymmetricKeyAlgorithm() {
        return this.symmetricKeyAlgorithm;
    }

    public int getAeadAlgorithm() {
        return this.aeadAlgorithm;
    }

    public static MessageEncryptionMechanism unencrypted() {
        int none = 0;
        return new MessageEncryptionMechanism(EncryptedDataPacketType.SEIPDv1, 0, none);
    }

    @Deprecated
    public static MessageEncryptionMechanism legacyEncryptedNonIntegrityProtected(int symmetricKeyAlgorithm) {
        int none = 0;
        return new MessageEncryptionMechanism(EncryptedDataPacketType.SED, symmetricKeyAlgorithm, none);
    }

    public static MessageEncryptionMechanism integrityProtected(int symmetricKeyAlgorithm) {
        int none = 0;
        return new MessageEncryptionMechanism(EncryptedDataPacketType.SEIPDv1, symmetricKeyAlgorithm, none);
    }

    public static MessageEncryptionMechanism librePgp(int symmetricKeyAlgorithm) {
        return new MessageEncryptionMechanism(EncryptedDataPacketType.LIBREPGP_OED, symmetricKeyAlgorithm, 2);
    }

    public static MessageEncryptionMechanism aead(int symmetricKeyAlgorithm, int aeadAlgorithm) {
        return new MessageEncryptionMechanism(EncryptedDataPacketType.SEIPDv2, symmetricKeyAlgorithm, aeadAlgorithm);
    }

    public static MessageEncryptionMechanism aead(PreferredAEADCiphersuites.Combination combination) {
        return MessageEncryptionMechanism.aead(combination.getSymmetricAlgorithm(), combination.getAeadAlgorithm());
    }

    public boolean isEncrypted() {
        return this.symmetricKeyAlgorithm != 0;
    }

    public int hashCode() {
        return this.mode.hashCode() + 13 * this.symmetricKeyAlgorithm + 17 * this.aeadAlgorithm;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MessageEncryptionMechanism)) {
            return false;
        }
        MessageEncryptionMechanism m = (MessageEncryptionMechanism)obj;
        return this.getMode() == m.getMode() && this.getSymmetricKeyAlgorithm() == m.getSymmetricKeyAlgorithm() && this.getAeadAlgorithm() == m.getAeadAlgorithm();
    }

    public String toString() {
        String out = this.mode.name() + "[cipher: " + this.symmetricKeyAlgorithm;
        if (this.mode == EncryptedDataPacketType.SEIPDv2 || this.mode == EncryptedDataPacketType.LIBREPGP_OED) {
            out = out + " aead: " + this.aeadAlgorithm;
        }
        return out + "]";
    }
}

