/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Date;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;

public abstract class PGPKeyPairGenerator {
    protected final Date creationTime;
    protected final int version;
    protected SecureRandom random;
    protected final KeyFingerPrintCalculator fingerPrintCalculator;

    public PGPKeyPairGenerator(int version, Date creationTime, SecureRandom random, KeyFingerPrintCalculator fingerPrintCalculator) {
        this.creationTime = new Date(creationTime.getTime() / 1000L * 1000L);
        this.version = version;
        this.random = random;
        this.fingerPrintCalculator = fingerPrintCalculator;
    }

    public PGPKeyPair generatePrimaryKey() throws PGPException {
        return this.generateEd25519KeyPair();
    }

    public PGPKeyPair generateEncryptionSubkey() throws PGPException {
        return this.generateX25519KeyPair().asSubkey(this.fingerPrintCalculator);
    }

    public PGPKeyPair generateSigningSubkey() throws PGPException {
        return this.generateEd25519KeyPair().asSubkey(this.fingerPrintCalculator);
    }

    public PGPKeyPair generateRsaKeyPair(int bitStrength) throws PGPException {
        return this.generateRsaKeyPair(BigInteger.valueOf(65537L), bitStrength);
    }

    public abstract PGPKeyPair generateRsaKeyPair(BigInteger var1, int var2) throws PGPException;

    public abstract PGPKeyPair generateEd25519KeyPair() throws PGPException;

    public abstract PGPKeyPair generateEd448KeyPair() throws PGPException;

    public abstract PGPKeyPair generateX25519KeyPair() throws PGPException;

    public abstract PGPKeyPair generateX448KeyPair() throws PGPException;

    public abstract PGPKeyPair generateLegacyEd25519KeyPair() throws PGPException;

    public abstract PGPKeyPair generateLegacyX25519KeyPair() throws PGPException;

    public PGPKeyPair generateNistP256ECDHKeyPair() throws PGPException {
        return this.generateECDHKeyPair(SECObjectIdentifiers.secp256r1);
    }

    public PGPKeyPair generateNistP384ECDHKeyPair() throws PGPException {
        return this.generateECDHKeyPair(SECObjectIdentifiers.secp384r1);
    }

    public PGPKeyPair generateNistP521ECDHKeyPair() throws PGPException {
        return this.generateECDHKeyPair(SECObjectIdentifiers.secp521r1);
    }

    public PGPKeyPair generateNistP256ECDSAKeyPair() throws PGPException {
        return this.generateECDSAKeyPair(SECObjectIdentifiers.secp256r1);
    }

    public PGPKeyPair generateNistP384ECDSAKeyPair() throws PGPException {
        return this.generateECDSAKeyPair(SECObjectIdentifiers.secp384r1);
    }

    public PGPKeyPair generateNistP521ECDSAKeyPair() throws PGPException {
        return this.generateECDSAKeyPair(SECObjectIdentifiers.secp521r1);
    }

    public abstract PGPKeyPair generateECDHKeyPair(ASN1ObjectIdentifier var1) throws PGPException;

    public abstract PGPKeyPair generateECDSAKeyPair(ASN1ObjectIdentifier var1) throws PGPException;
}

