/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.PacketFormat;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPadding;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.api.OpenPGPMessageGenerator;
import org.bouncycastle.util.io.TeeOutputStream;

public class OpenPGPMessageOutputStream
extends OutputStream {
    private final OutputStream baseOut;
    private final OutputStream armorOut;
    private final OutputStream encodeOut;
    private final OutputStream encryptOut;
    private final OutputStream paddingOut;
    private final OutputStream signOut;
    private final OutputStream compressOut;
    private final OutputStream literalOut;
    private final OutputStream plaintextOut;

    OpenPGPMessageOutputStream(OutputStream baseOut, Builder builder) throws PGPException, IOException {
        this.baseOut = baseOut;
        OutputStream innermostOut = baseOut;
        if (builder.armorFactory != null) {
            innermostOut = this.armorOut = builder.armorFactory.get(innermostOut);
        } else {
            this.armorOut = null;
        }
        innermostOut = this.encodeOut = new BCPGOutputStream(innermostOut, PacketFormat.CURRENT);
        if (builder.encryptionStreamFactory != null) {
            innermostOut = this.encryptOut = builder.encryptionStreamFactory.get(innermostOut);
        } else {
            this.encryptOut = null;
        }
        if (builder.paddingStreamFactory != null) {
            innermostOut = this.paddingOut = builder.paddingStreamFactory.get(innermostOut);
        } else {
            this.paddingOut = null;
        }
        this.signOut = builder.signatureStreamFactory != null ? builder.signatureStreamFactory.get(innermostOut) : null;
        if (builder.compressionStreamFactory != null) {
            innermostOut = this.compressOut = builder.compressionStreamFactory.get(innermostOut);
        } else {
            this.compressOut = null;
        }
        if (builder.literalDataStreamFactory == null) {
            throw new PGPException("Missing instructions for LiteralData encoding.");
        }
        this.literalOut = builder.literalDataStreamFactory.get(innermostOut);
        this.plaintextOut = this.signOut != null ? new TeeOutputStream(this.literalOut, this.signOut) : this.literalOut;
    }

    public void write(int i) throws IOException {
        this.plaintextOut.write(i);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.plaintextOut.write(b, off, len);
    }

    public void flush() throws IOException {
        this.literalOut.flush();
        if (this.compressOut != null) {
            this.compressOut.flush();
        }
        if (this.signOut != null) {
            this.signOut.flush();
        }
        if (this.paddingOut != null) {
            this.paddingOut.flush();
        }
        if (this.encryptOut != null) {
            this.encryptOut.flush();
        }
        this.encodeOut.flush();
        if (this.armorOut != null) {
            this.armorOut.flush();
        }
        this.baseOut.flush();
    }

    public void close() throws IOException {
        this.literalOut.close();
        if (this.compressOut != null) {
            this.compressOut.close();
        }
        if (this.signOut != null) {
            this.signOut.close();
        }
        if (this.paddingOut != null) {
            this.paddingOut.close();
        }
        if (this.encryptOut != null) {
            this.encryptOut.close();
        }
        this.encodeOut.close();
        if (this.armorOut != null) {
            this.armorOut.close();
        }
        this.baseOut.close();
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private OpenPGPMessageGenerator.ArmoredOutputStreamFactory armorFactory;
        private OutputStreamFactory paddingStreamFactory;
        private OutputStreamFactory encryptionStreamFactory;
        private OutputStreamFactory signatureStreamFactory;
        private OutputStreamFactory compressionStreamFactory;
        private OutputStreamFactory literalDataStreamFactory;

        Builder() {
        }

        public Builder armor(OpenPGPMessageGenerator.ArmoredOutputStreamFactory factory) {
            this.armorFactory = factory;
            return this;
        }

        public Builder encrypt(OutputStreamFactory factory) {
            this.encryptionStreamFactory = factory;
            return this;
        }

        public Builder padding(OutputStreamFactory factory) {
            this.paddingStreamFactory = factory;
            return this;
        }

        public Builder sign(OutputStreamFactory factory) {
            this.signatureStreamFactory = factory;
            return this;
        }

        public Builder compress(OutputStreamFactory factory) {
            this.compressionStreamFactory = factory;
            return this;
        }

        public Builder literalData(OutputStreamFactory factory) {
            this.literalDataStreamFactory = factory;
            return this;
        }

        public OpenPGPMessageOutputStream build(OutputStream baseOut) throws PGPException, IOException {
            return new OpenPGPMessageOutputStream(baseOut, this);
        }
    }

    public static interface OutputStreamFactory {
        public OutputStream get(OutputStream var1) throws PGPException, IOException;
    }

    static class PaddingPacketAppenderOutputStream
    extends OutputStream {
        private final OutputStream out;
        private final PaddingPacketFactory packetFactory;

        public PaddingPacketAppenderOutputStream(OutputStream out, PaddingPacketFactory packetFactory) {
            this.out = out;
            this.packetFactory = packetFactory;
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void write(int i) throws IOException {
            this.out.write(i);
        }

        public void close() throws IOException {
            this.packetFactory.providePaddingPacket().encode(this.out);
            this.out.close();
        }
    }

    public static interface PaddingPacketFactory {
        public PGPPadding providePaddingPacket();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SignatureGeneratorOutputStream
    extends OutputStream {
        private final OutputStream out;
        private final List<PGPSignatureGenerator> signatureGenerators;

        public SignatureGeneratorOutputStream(OutputStream out, List<PGPSignatureGenerator> signatureGenerators) {
            this.out = out;
            this.signatureGenerators = signatureGenerators;
        }

        @Override
        public void write(int i) throws IOException {
            for (PGPSignatureGenerator sigGen : this.signatureGenerators) {
                sigGen.update((byte)i);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            for (PGPSignatureGenerator sigGen : this.signatureGenerators) {
                sigGen.update(b);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            for (PGPSignatureGenerator sigGen : this.signatureGenerators) {
                sigGen.update(b, off, len);
            }
        }

        @Override
        public void close() throws IOException {
            for (int i = this.signatureGenerators.size() - 1; i >= 0; --i) {
                PGPSignatureGenerator gen = this.signatureGenerators.get(i);
                PGPSignature sig = null;
                try {
                    sig = gen.generate();
                }
                catch (PGPException e) {
                    throw new RuntimeException(e);
                }
                sig.encode(this.out);
            }
        }
    }
}

