/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleBufferedInputStream<I extends InputStream>
extends InputStream {
    private static final int BUFFER_SIZE = 0x2000000;
    private byte[] buf1;
    private byte[] buf2;
    private int b1Pos;
    private int b1Max;
    private int b2Max;
    private final I in;
    private boolean closed = false;

    public DoubleBufferedInputStream(I in) {
        this(in, 0x2000000);
    }

    public DoubleBufferedInputStream(I in, int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size cannot be zero nor negative.");
        }
        this.buf1 = new byte[bufferSize];
        this.buf2 = new byte[bufferSize];
        this.in = in;
        this.b1Pos = -1;
    }

    public I getInputStream() {
        return this.in;
    }

    private void fill() throws IOException {
        if (this.b1Pos == -1) {
            this.b1Max = ((InputStream)this.in).read(this.buf1);
            this.b2Max = ((InputStream)this.in).read(this.buf2);
            if (this.b2Max == -1) {
                this.close();
            }
            this.b1Pos = 0;
            return;
        }
        if (this.b1Max <= 0) {
            return;
        }
        if (this.b1Pos == this.b1Max) {
            byte[] t = this.buf1;
            this.buf1 = this.buf2;
            this.buf2 = t;
            this.b1Max = this.b2Max;
            this.b1Pos = 0;
            try {
                int i;
                this.b2Max = ((InputStream)this.in).read(this.buf2);
                if (this.b2Max != this.buf2.length && (i = ((InputStream)this.in).read()) != -1) {
                    this.buf2[this.b2Max++] = (byte)i;
                }
            }
            catch (IOException e) {
                this.b1Max = -1;
                this.b2Max = -1;
                this.close();
                throw e;
            }
            if (this.b2Max == -1) {
                this.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            ((InputStream)this.in).close();
        }
    }

    @Override
    public int read() throws IOException {
        this.fill();
        if (this.b1Max == -1) {
            this.close();
            return -1;
        }
        return this.buf1[this.b1Pos++];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.fill();
        if (this.b1Max == -1) {
            this.close();
            return -1;
        }
        int ret = Math.min(this.b1Max - this.b1Pos, len);
        System.arraycopy(this.buf1, this.b1Pos, b, off, ret);
        this.b1Pos += ret;
        return ret;
    }
}

