/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.bcpg.PublicKeyUtils;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.sig.PreferredAEADCiphersuites;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.api.KeyPairGeneratorCallback;
import org.bouncycastle.openpgp.api.SignatureSubpacketsFunction;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PGPKeyPairGenerator;
import org.bouncycastle.openpgp.operator.PGPKeyPairGeneratorProvider;
import org.bouncycastle.util.Arrays;

public class OpenPGPV6KeyGenerator {
    public static final int DEFAULT_SIGNATURE_HASH_ALGORITHM = 14;
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_DAY = 86400L;
    private static final long SECONDS_PER_YEAR = 31536000L;
    public static SignatureSubpacketsFunction DEFAULT_AEAD_ALGORITHM_PREFERENCES = new SignatureSubpacketsFunction(){

        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator subpackets) {
            subpackets.removePacketsOfType(39);
            subpackets.setPreferredAEADCiphersuites(PreferredAEADCiphersuites.builder(false).addCombination(9, 2).addCombination(8, 2).addCombination(7, 2));
            return subpackets;
        }
    };
    public static SignatureSubpacketsFunction DEFAULT_SYMMETRIC_KEY_PREFERENCES = new SignatureSubpacketsFunction(){

        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator subpackets) {
            subpackets.removePacketsOfType(11);
            subpackets.setPreferredSymmetricAlgorithms(false, new int[]{9, 8, 7});
            return subpackets;
        }
    };
    public static SignatureSubpacketsFunction DEFAULT_HASH_ALGORITHM_PREFERENCES = new SignatureSubpacketsFunction(){

        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator subpackets) {
            subpackets.removePacketsOfType(21);
            subpackets.setPreferredHashAlgorithms(false, new int[]{14, 12, 10, 9, 8});
            return subpackets;
        }
    };
    public static SignatureSubpacketsFunction DEFAULT_COMPRESSION_ALGORITHM_PREFERENCES = new SignatureSubpacketsFunction(){

        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator subpackets) {
            subpackets.removePacketsOfType(22);
            subpackets.setPreferredCompressionAlgorithms(false, new int[]{0, 1, 2, 3});
            return subpackets;
        }
    };
    public static SignatureSubpacketsFunction DEFAULT_FEATURES = new SignatureSubpacketsFunction(){

        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator subpackets) {
            subpackets.removePacketsOfType(30);
            subpackets.setFeature(false, (byte)9);
            return subpackets;
        }
    };
    public static SignatureSubpacketsFunction SIGNING_SUBKEY_SUBPACKETS = new SignatureSubpacketsFunction(){

        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator subpackets) {
            subpackets.removePacketsOfType(27);
            subpackets.setKeyFlags(true, 2);
            return subpackets;
        }
    };
    public static SignatureSubpacketsFunction ENCRYPTION_SUBKEY_SUBPACKETS = new SignatureSubpacketsFunction(){

        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator subpackets) {
            subpackets.removePacketsOfType(27);
            subpackets.setKeyFlags(true, 12);
            return subpackets;
        }
    };
    public static SignatureSubpacketsFunction DIRECT_KEY_SIGNATURE_SUBPACKETS = new SignatureSubpacketsFunction(){

        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator subpackets) {
            subpackets = DEFAULT_FEATURES.apply(subpackets);
            subpackets = DEFAULT_HASH_ALGORITHM_PREFERENCES.apply(subpackets);
            subpackets = DEFAULT_COMPRESSION_ALGORITHM_PREFERENCES.apply(subpackets);
            subpackets = DEFAULT_SYMMETRIC_KEY_PREFERENCES.apply(subpackets);
            subpackets = DEFAULT_AEAD_ALGORITHM_PREFERENCES.apply(subpackets);
            return subpackets;
        }
    };
    private final Implementation impl;
    private final Configuration conf;

    public OpenPGPV6KeyGenerator(PGPKeyPairGeneratorProvider kpGenProvider, PGPContentSignerBuilderProvider contentSignerBuilderProvider, PGPDigestCalculatorProvider digestCalculatorProvider, PBESecretKeyEncryptorFactory keyEncryptionBuilderProvider, KeyFingerPrintCalculator keyFingerPrintCalculator, Date creationTime) {
        this.impl = new Implementation(kpGenProvider, contentSignerBuilderProvider, digestCalculatorProvider, keyEncryptionBuilderProvider, keyFingerPrintCalculator);
        this.conf = new Configuration(new Date(creationTime.getTime() / 1000L * 1000L));
    }

    public PGPSecretKeyRing classicKey(String userId, char[] passphrase) throws PGPException {
        return this.withPrimaryKey().addUserId(userId).addSigningSubkey().addEncryptionSubkey().build(passphrase);
    }

    public PGPSecretKeyRing ed25519x25519Key(String userId, char[] passphrase) throws PGPException {
        return this.withPrimaryKey(new KeyPairGeneratorCallback(){

            public PGPKeyPair generateFrom(PGPKeyPairGenerator generator) throws PGPException {
                return generator.generateEd25519KeyPair();
            }
        }).addSigningSubkey(new KeyPairGeneratorCallback(){

            public PGPKeyPair generateFrom(PGPKeyPairGenerator generator) throws PGPException {
                return generator.generateEd25519KeyPair();
            }
        }).addEncryptionSubkey(new KeyPairGeneratorCallback(){

            public PGPKeyPair generateFrom(PGPKeyPairGenerator generator) throws PGPException {
                return generator.generateX25519KeyPair();
            }
        }).addUserId(userId).build(passphrase);
    }

    public PGPSecretKeyRing ed448x448Key(String userId, char[] passphrase) throws PGPException {
        return this.withPrimaryKey(new KeyPairGeneratorCallback(){

            public PGPKeyPair generateFrom(PGPKeyPairGenerator generator) throws PGPException {
                return generator.generateEd448KeyPair();
            }
        }).addSigningSubkey(new KeyPairGeneratorCallback(){

            public PGPKeyPair generateFrom(PGPKeyPairGenerator generator) throws PGPException {
                return generator.generateEd448KeyPair();
            }
        }).addEncryptionSubkey(new KeyPairGeneratorCallback(){

            public PGPKeyPair generateFrom(PGPKeyPairGenerator generator) throws PGPException {
                return generator.generateX448KeyPair();
            }
        }).addUserId(userId).build(passphrase);
    }

    public PGPSecretKeyRing signOnlyKey(char[] passphrase) throws PGPException {
        return this.signOnlyKey(passphrase, null);
    }

    public PGPSecretKeyRing signOnlyKey(char[] passphrase, SignatureSubpacketsFunction userSubpackets) throws PGPException {
        PGPKeyPair primaryKeyPair = this.impl.kpGenProvider.get(6, this.conf.keyCreationTime).generatePrimaryKey();
        PBESecretKeyEncryptor encryptor = this.impl.keyEncryptorBuilderProvider.build(passphrase, primaryKeyPair.getPublicKey().getPublicKeyPacket());
        return this.signOnlyKey(primaryKeyPair, encryptor, userSubpackets);
    }

    public PGPSecretKeyRing signOnlyKey(PGPKeyPair primaryKeyPair, PBESecretKeyEncryptor keyEncryptor, SignatureSubpacketsFunction userSubpackets) throws PGPException {
        if (primaryKeyPair.getPublicKey().getPublicKeyPacket() instanceof PublicSubkeyPacket) {
            throw new IllegalArgumentException("Primary key MUST NOT consist of subkey packet.");
        }
        return this.primaryKeyWithDirectKeySig(primaryKeyPair, new SignatureSubpacketsFunction(){

            public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator baseSubpackets) {
                baseSubpackets.removePacketsOfType(39);
                baseSubpackets.removePacketsOfType(11);
                baseSubpackets.removePacketsOfType(22);
                baseSubpackets.removePacketsOfType(27);
                baseSubpackets.setKeyFlags(true, 3);
                return baseSubpackets;
            }
        }, userSubpackets, keyEncryptor).build();
    }

    public WithPrimaryKey withPrimaryKey() throws PGPException {
        return this.withPrimaryKey((SignatureSubpacketsFunction)null);
    }

    public WithPrimaryKey withPrimaryKey(KeyPairGeneratorCallback keyGenCallback) throws PGPException {
        return this.withPrimaryKey(keyGenCallback, null);
    }

    public WithPrimaryKey withPrimaryKey(SignatureSubpacketsFunction directKeySubpackets) throws PGPException {
        return this.withPrimaryKey(new KeyPairGeneratorCallback(){

            public PGPKeyPair generateFrom(PGPKeyPairGenerator generator) throws PGPException {
                return generator.generatePrimaryKey();
            }
        }, directKeySubpackets);
    }

    public WithPrimaryKey withPrimaryKey(KeyPairGeneratorCallback keyGenCallback, SignatureSubpacketsFunction directKeySubpackets) throws PGPException {
        return this.withPrimaryKey(keyGenCallback, directKeySubpackets, null);
    }

    public WithPrimaryKey withPrimaryKey(PGPKeyPair primaryKeyPair, SignatureSubpacketsFunction directKeySubpackets) throws PGPException {
        return this.withPrimaryKey(primaryKeyPair, directKeySubpackets, null);
    }

    public WithPrimaryKey withPrimaryKey(KeyPairGeneratorCallback keyGenCallback, SignatureSubpacketsFunction directKeySubpackets, char[] passphrase) throws PGPException {
        PGPKeyPair primaryKeyPair = keyGenCallback.generateFrom(this.impl.kpGenProvider.get(6, this.conf.keyCreationTime));
        PBESecretKeyEncryptor keyEncryptor = this.impl.keyEncryptorBuilderProvider.build(passphrase, primaryKeyPair.getPublicKey().getPublicKeyPacket());
        return this.withPrimaryKey(primaryKeyPair, directKeySubpackets, keyEncryptor);
    }

    public WithPrimaryKey withPrimaryKey(final PGPKeyPair primaryKeyPair, SignatureSubpacketsFunction directKeySubpackets, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        if (primaryKeyPair.getPublicKey().getPublicKeyPacket() instanceof PublicSubkeyPacket) {
            throw new IllegalArgumentException("Primary key MUST NOT consist of subkey packet.");
        }
        if (!PublicKeyUtils.isSigningAlgorithm(primaryKeyPair.getPublicKey().getAlgorithm())) {
            throw new PGPException("Primary key MUST use signing-capable algorithm.");
        }
        return this.primaryKeyWithDirectKeySig(primaryKeyPair, new SignatureSubpacketsFunction(){

            public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator subpackets) {
                subpackets.setIssuerFingerprint(true, primaryKeyPair.getPublicKey());
                subpackets.setSignatureCreationTime(((OpenPGPV6KeyGenerator)OpenPGPV6KeyGenerator.this).conf.keyCreationTime);
                subpackets.setKeyFlags(true, 1);
                subpackets = DIRECT_KEY_SIGNATURE_SUBPACKETS.apply(subpackets);
                subpackets.setKeyExpirationTime(false, 157680000L);
                return subpackets;
            }
        }, directKeySubpackets, keyEncryptor);
    }

    private WithPrimaryKey primaryKeyWithDirectKeySig(PGPKeyPair primaryKeyPair, SignatureSubpacketsFunction baseSubpackets, SignatureSubpacketsFunction customSubpackets, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        if (baseSubpackets != null || customSubpackets != null) {
            PGPSignatureGenerator dkSigGen = new PGPSignatureGenerator(this.impl.contentSignerBuilderProvider.get(primaryKeyPair.getPublicKey()), primaryKeyPair.getPublicKey());
            dkSigGen.init(31, primaryKeyPair.getPrivateKey());
            PGPSignatureSubpacketGenerator subpackets = new PGPSignatureSubpacketGenerator();
            if (baseSubpackets != null) {
                subpackets = baseSubpackets.apply(subpackets);
            }
            if (customSubpackets != null) {
                subpackets = customSubpackets.apply(subpackets);
            }
            dkSigGen.setHashedSubpackets(subpackets.generate());
            PGPSignature dkSig = dkSigGen.generateCertification(primaryKeyPair.getPublicKey());
            primaryKeyPair = new PGPKeyPair(PGPPublicKey.addCertification(primaryKeyPair.getPublicKey(), dkSig), primaryKeyPair.getPrivateKey());
        }
        Key primaryKey = new Key(primaryKeyPair, keyEncryptor);
        return new WithPrimaryKey(this.impl, this.conf, primaryKey);
    }

    private static class Configuration {
        final Date keyCreationTime;

        public Configuration(Date keyCreationTime) {
            this.keyCreationTime = keyCreationTime;
        }
    }

    private static class Implementation {
        final PGPKeyPairGeneratorProvider kpGenProvider;
        final PGPContentSignerBuilderProvider contentSignerBuilderProvider;
        final PGPDigestCalculatorProvider digestCalculatorProvider;
        final PBESecretKeyEncryptorFactory keyEncryptorBuilderProvider;
        final KeyFingerPrintCalculator keyFingerprintCalculator;

        public Implementation(PGPKeyPairGeneratorProvider keyPairGeneratorProvider, PGPContentSignerBuilderProvider contentSignerBuilderProvider, PGPDigestCalculatorProvider digestCalculatorProvider, PBESecretKeyEncryptorFactory keyEncryptorBuilderProvider, KeyFingerPrintCalculator keyFingerPrintCalculator) {
            this.kpGenProvider = keyPairGeneratorProvider;
            this.contentSignerBuilderProvider = contentSignerBuilderProvider;
            this.digestCalculatorProvider = digestCalculatorProvider;
            this.keyEncryptorBuilderProvider = keyEncryptorBuilderProvider;
            this.keyFingerprintCalculator = keyFingerPrintCalculator;
        }
    }

    private static class Key {
        private final PGPKeyPair pair;
        private final PBESecretKeyEncryptor encryptor;

        public Key(PGPKeyPair key, PBESecretKeyEncryptor encryptor) {
            this.pair = key;
            this.encryptor = encryptor;
        }
    }

    public static class WithPrimaryKey {
        private final Implementation impl;
        private final Configuration conf;
        private Key primaryKey;
        private final List<Key> subkeys = new ArrayList<Key>();

        private WithPrimaryKey(Implementation implementation, Configuration configuration, Key primaryKey) {
            this.impl = implementation;
            this.conf = configuration;
            this.primaryKey = primaryKey;
        }

        public WithPrimaryKey addUserId(String userId) throws PGPException {
            return this.addUserId(userId, null);
        }

        public WithPrimaryKey addUserId(String userId, SignatureSubpacketsFunction userIdSubpackets) throws PGPException {
            return this.addUserId(userId, 19, userIdSubpackets);
        }

        public WithPrimaryKey addUserId(String userId, int certificationType, SignatureSubpacketsFunction userIdSubpackets) throws PGPException {
            if (userId == null || userId.trim().length() == 0) {
                throw new IllegalArgumentException("User-ID cannot be null or empty.");
            }
            if (!PGPSignature.isCertification(certificationType)) {
                throw new IllegalArgumentException("Signature type MUST be a certification type (0x10 - 0x13)");
            }
            PGPSignatureGenerator uidSigGen = new PGPSignatureGenerator(this.impl.contentSignerBuilderProvider.get(this.primaryKey.pair.getPublicKey()), this.primaryKey.pair.getPublicKey());
            uidSigGen.init(certificationType, this.primaryKey.pair.getPrivateKey());
            PGPSignatureSubpacketGenerator subpackets = new PGPSignatureSubpacketGenerator();
            subpackets.setIssuerFingerprint(true, this.primaryKey.pair.getPublicKey());
            subpackets.setSignatureCreationTime(this.conf.keyCreationTime);
            if (userIdSubpackets != null) {
                subpackets = userIdSubpackets.apply(subpackets);
            }
            uidSigGen.setHashedSubpackets(subpackets.generate());
            PGPSignature uidSig = uidSigGen.generateCertification(userId, this.primaryKey.pair.getPublicKey());
            PGPPublicKey pubKey = PGPPublicKey.addCertification(this.primaryKey.pair.getPublicKey(), userId, uidSig);
            this.primaryKey = new Key(new PGPKeyPair(pubKey, this.primaryKey.pair.getPrivateKey()), this.primaryKey.encryptor);
            return this;
        }

        public WithPrimaryKey addEncryptionSubkey() throws PGPException {
            return this.addEncryptionSubkey(new KeyPairGeneratorCallback(){

                public PGPKeyPair generateFrom(PGPKeyPairGenerator generator) throws PGPException {
                    return generator.generateEncryptionSubkey();
                }
            });
        }

        public WithPrimaryKey addEncryptionSubkey(KeyPairGeneratorCallback keyGenCallback) throws PGPException {
            return this.addEncryptionSubkey(keyGenCallback, (char[])null);
        }

        public WithPrimaryKey addEncryptionSubkey(KeyPairGeneratorCallback generatorCallback, SignatureSubpacketsFunction bindingSubpacketsCallback) throws PGPException {
            PGPKeyPairGenerator generator = this.impl.kpGenProvider.get(this.primaryKey.pair.getPublicKey().getVersion(), this.conf.keyCreationTime);
            PGPKeyPair subkey = generatorCallback.generateFrom(generator);
            return this.addEncryptionSubkey(subkey, bindingSubpacketsCallback, null);
        }

        public WithPrimaryKey addEncryptionSubkey(char[] passphrase) throws PGPException {
            return this.addEncryptionSubkey(new KeyPairGeneratorCallback(){

                public PGPKeyPair generateFrom(PGPKeyPairGenerator generator) throws PGPException {
                    return generator.generateEncryptionSubkey();
                }
            }, passphrase);
        }

        public WithPrimaryKey addEncryptionSubkey(KeyPairGeneratorCallback keyGenCallback, char[] passphrase) throws PGPException {
            return this.addEncryptionSubkey(keyGenCallback, null, passphrase);
        }

        public WithPrimaryKey addEncryptionSubkey(KeyPairGeneratorCallback keyGenCallback, SignatureSubpacketsFunction bindingSignatureCallback, char[] passphrase) throws PGPException {
            PGPKeyPair subkey = keyGenCallback.generateFrom(this.impl.kpGenProvider.get(6, this.conf.keyCreationTime));
            subkey = subkey.asSubkey(this.impl.keyFingerprintCalculator);
            PBESecretKeyEncryptor keyEncryptor = this.impl.keyEncryptorBuilderProvider.build(passphrase, subkey.getPublicKey().getPublicKeyPacket());
            return this.addEncryptionSubkey(subkey, bindingSignatureCallback, keyEncryptor);
        }

        public WithPrimaryKey addEncryptionSubkey(PGPKeyPair encryptionSubkey, SignatureSubpacketsFunction bindingSubpacketsCallback, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
            if (!(encryptionSubkey.getPublicKey().getPublicKeyPacket() instanceof PublicSubkeyPacket)) {
                throw new IllegalArgumentException("Encryption subkey MUST NOT consist of a primary key packet.");
            }
            if (!encryptionSubkey.getPublicKey().isEncryptionKey()) {
                throw new PGPException("Encryption key MUST use encryption-capable algorithm.");
            }
            PGPSignatureSubpacketGenerator subpackets = new PGPSignatureSubpacketGenerator();
            subpackets.setIssuerFingerprint(true, this.primaryKey.pair.getPublicKey());
            subpackets.setSignatureCreationTime(this.conf.keyCreationTime);
            subpackets = ENCRYPTION_SUBKEY_SUBPACKETS.apply(subpackets);
            PGPPublicKey publicSubkey = this.getPublicSubKey(encryptionSubkey, bindingSubpacketsCallback, subpackets);
            Key subkey = new Key(new PGPKeyPair(publicSubkey, encryptionSubkey.getPrivateKey()), keyEncryptor);
            this.subkeys.add(subkey);
            return this;
        }

        public WithPrimaryKey addSigningSubkey() throws PGPException {
            return this.addSigningSubkey(new KeyPairGeneratorCallback(){

                public PGPKeyPair generateFrom(PGPKeyPairGenerator generator) throws PGPException {
                    return generator.generateSigningSubkey();
                }
            });
        }

        public WithPrimaryKey addSigningSubkey(KeyPairGeneratorCallback keyGenCallback) throws PGPException {
            return this.addSigningSubkey(keyGenCallback, null);
        }

        public WithPrimaryKey addSigningSubkey(char[] passphrase) throws PGPException {
            return this.addSigningSubkey(new KeyPairGeneratorCallback(){

                public PGPKeyPair generateFrom(PGPKeyPairGenerator generator) throws PGPException {
                    return generator.generateSigningSubkey();
                }
            }, passphrase);
        }

        public WithPrimaryKey addSigningSubkey(KeyPairGeneratorCallback keyGenCallback, char[] passphrase) throws PGPException {
            return this.addSigningSubkey(keyGenCallback, null, null, passphrase);
        }

        public WithPrimaryKey addSigningSubkey(KeyPairGeneratorCallback keyGenCallback, SignatureSubpacketsFunction bindingSignatureCallback, SignatureSubpacketsFunction backSignatureCallback, char[] passphrase) throws PGPException {
            PGPKeyPair subkey = keyGenCallback.generateFrom(this.impl.kpGenProvider.get(6, this.conf.keyCreationTime));
            subkey = subkey.asSubkey(this.impl.keyFingerprintCalculator);
            PBESecretKeyEncryptor keyEncryptor = this.impl.keyEncryptorBuilderProvider.build(passphrase, subkey.getPublicKey().getPublicKeyPacket());
            return this.addSigningSubkey(subkey, bindingSignatureCallback, backSignatureCallback, keyEncryptor);
        }

        public WithPrimaryKey addSigningSubkey(PGPKeyPair signingSubkey, SignatureSubpacketsFunction bindingSignatureCallback, SignatureSubpacketsFunction backSignatureCallback, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
            if (!(signingSubkey.getPublicKey().getPublicKeyPacket() instanceof PublicSubkeyPacket)) {
                throw new IllegalArgumentException("Signing subkey MUST NOT consist of primary key packet.");
            }
            if (!PublicKeyUtils.isSigningAlgorithm(signingSubkey.getPublicKey().getAlgorithm())) {
                throw new PGPException("Signing key MUST use signing-capable algorithm.");
            }
            PGPSignatureSubpacketGenerator backSigSubpackets = new PGPSignatureSubpacketGenerator();
            backSigSubpackets.setIssuerFingerprint(true, signingSubkey.getPublicKey());
            backSigSubpackets.setSignatureCreationTime(this.conf.keyCreationTime);
            if (backSignatureCallback != null) {
                backSigSubpackets = backSignatureCallback.apply(backSigSubpackets);
            }
            PGPSignatureSubpacketGenerator bindingSigSubpackets = new PGPSignatureSubpacketGenerator();
            bindingSigSubpackets.setIssuerFingerprint(true, this.primaryKey.pair.getPublicKey());
            bindingSigSubpackets.setSignatureCreationTime(this.conf.keyCreationTime);
            bindingSigSubpackets = SIGNING_SUBKEY_SUBPACKETS.apply(bindingSigSubpackets);
            PGPSignatureGenerator backSigGen = new PGPSignatureGenerator(this.impl.contentSignerBuilderProvider.get(signingSubkey.getPublicKey()), signingSubkey.getPublicKey());
            backSigGen.init(25, signingSubkey.getPrivateKey());
            backSigGen.setHashedSubpackets(backSigSubpackets.generate());
            PGPSignature backSig = backSigGen.generateCertification(this.primaryKey.pair.getPublicKey(), signingSubkey.getPublicKey());
            try {
                bindingSigSubpackets.addEmbeddedSignature(false, backSig);
            }
            catch (IOException e) {
                throw new PGPException("Cannot embed back-signature.", e);
            }
            PGPPublicKey signingPubKey = this.getPublicSubKey(signingSubkey, bindingSignatureCallback, bindingSigSubpackets);
            signingSubkey = new PGPKeyPair(signingPubKey, signingSubkey.getPrivateKey());
            this.subkeys.add(new Key(signingSubkey, keyEncryptor));
            return this;
        }

        public PGPSecretKeyRing build() throws PGPException {
            PGPSecretKey primarySecretKey = new PGPSecretKey(this.primaryKey.pair.getPrivateKey(), this.primaryKey.pair.getPublicKey(), this.impl.digestCalculatorProvider.get(2), true, this.primaryKey.encryptor);
            ArrayList<PGPSecretKey> keys = new ArrayList<PGPSecretKey>();
            keys.add(primarySecretKey);
            for (Key key : this.subkeys) {
                PGPSecretKey subkey = new PGPSecretKey(key.pair.getPrivateKey(), key.pair.getPublicKey(), this.impl.digestCalculatorProvider.get(2), false, key.encryptor);
                keys.add(subkey);
            }
            return new PGPSecretKeyRing(keys);
        }

        public PGPSecretKeyRing build(char[] passphrase) throws PGPException {
            PBESecretKeyEncryptor primaryKeyEncryptor = this.impl.keyEncryptorBuilderProvider.build(passphrase, this.primaryKey.pair.getPublicKey().getPublicKeyPacket());
            this.sanitizeKeyEncryptor(primaryKeyEncryptor);
            PGPSecretKey primarySecretKey = new PGPSecretKey(this.primaryKey.pair.getPrivateKey(), this.primaryKey.pair.getPublicKey(), this.impl.digestCalculatorProvider.get(2), true, primaryKeyEncryptor);
            ArrayList<PGPSecretKey> keys = new ArrayList<PGPSecretKey>();
            keys.add(primarySecretKey);
            for (Key key : this.subkeys) {
                PBESecretKeyEncryptor subkeyEncryptor = this.impl.keyEncryptorBuilderProvider.build(passphrase, key.pair.getPublicKey().getPublicKeyPacket());
                this.sanitizeKeyEncryptor(subkeyEncryptor);
                PGPSecretKey subkey = new PGPSecretKey(key.pair.getPrivateKey(), key.pair.getPublicKey(), this.impl.digestCalculatorProvider.get(2), false, subkeyEncryptor);
                keys.add(subkey);
            }
            if (passphrase != null) {
                Arrays.fill((char[])passphrase, (char)'\u0000');
            }
            return new PGPSecretKeyRing(keys);
        }

        protected void sanitizeKeyEncryptor(PBESecretKeyEncryptor keyEncryptor) {
            if (keyEncryptor == null) {
                return;
            }
            S2K s2k = keyEncryptor.getS2K();
            if (s2k.getType() == 0 || s2k.getType() == 1) {
                throw new IllegalArgumentException("S2K specifiers SIMPLE and SALTED are not allowed for secret key encryption.");
            }
            if (s2k.getType() == 4 && keyEncryptor.getAeadAlgorithm() == 0) {
                throw new IllegalArgumentException("Argon2 MUST be used with AEAD.");
            }
        }

        private PGPPublicKey getPublicSubKey(PGPKeyPair encryptionSubkey, SignatureSubpacketsFunction bindingSubpacketsCallback, PGPSignatureSubpacketGenerator subpackets) throws PGPException {
            if (bindingSubpacketsCallback != null) {
                subpackets = bindingSubpacketsCallback.apply(subpackets);
            }
            PGPSignatureGenerator bindingSigGen = new PGPSignatureGenerator(this.impl.contentSignerBuilderProvider.get(this.primaryKey.pair.getPublicKey()), this.primaryKey.pair.getPublicKey());
            bindingSigGen.init(24, this.primaryKey.pair.getPrivateKey());
            bindingSigGen.setHashedSubpackets(subpackets.generate());
            PGPSignature bindingSig = bindingSigGen.generateCertification(this.primaryKey.pair.getPublicKey(), encryptionSubkey.getPublicKey());
            return PGPPublicKey.addCertification(encryptionSubkey.getPublicKey(), bindingSig);
        }
    }
}

