/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;

public class SymmetricKeyEncSessionPacket
extends ContainedPacket {
    public static final int VERSION_4 = 4;
    public static final int VERSION_5 = 5;
    public static final int VERSION_6 = 6;
    private int version;
    private int encAlgorithm;
    private S2K s2k;
    private byte[] s2kBytes;
    private byte[] secKeyData;
    private int aeadAlgorithm;
    private byte[] iv;
    private byte[] authTag;

    public SymmetricKeyEncSessionPacket(BCPGInputStream in) throws IOException {
        this(in, false);
    }

    public SymmetricKeyEncSessionPacket(BCPGInputStream in, boolean newPacketFormat) throws IOException {
        super(3, newPacketFormat);
        this.version = in.read();
        if (this.version == 4) {
            this.encAlgorithm = in.read();
            this.s2k = new S2K(in);
            this.secKeyData = in.readAll();
        } else if (this.version == 5 || this.version == 6) {
            int ivLen = 0;
            if (this.version == 6) {
                ivLen = in.read();
            }
            this.encAlgorithm = in.read();
            this.aeadAlgorithm = in.read();
            if (this.version == 6) {
                int s2kOctetCount = in.read();
                ivLen = ivLen - 3 - s2kOctetCount;
            } else {
                ivLen = AEADUtils.getIVLength(this.aeadAlgorithm);
            }
            this.s2k = new S2K(in);
            this.iv = new byte[ivLen];
            if (in.read(this.iv) != this.iv.length) {
                throw new EOFException("Premature end of stream.");
            }
            int authTagLen = AEADUtils.getAuthTagLength(this.aeadAlgorithm);
            this.authTag = new byte[authTagLen];
            byte[] sessKeyAndAuthTag = in.readAll();
            this.secKeyData = new byte[sessKeyAndAuthTag.length - authTagLen];
            System.arraycopy(sessKeyAndAuthTag, 0, this.secKeyData, 0, this.secKeyData.length);
            System.arraycopy(sessKeyAndAuthTag, this.secKeyData.length, this.authTag, 0, authTagLen);
        } else {
            throw new UnsupportedPacketVersionException("Unsupported PGP symmetric-key encrypted session key packet version encountered: " + this.version);
        }
    }

    public static SymmetricKeyEncSessionPacket createV4Packet(int encAlgorithm, S2K s2k, byte[] secKeyData) {
        return new SymmetricKeyEncSessionPacket(encAlgorithm, s2k, secKeyData);
    }

    public static SymmetricKeyEncSessionPacket createV5Packet(int encAlgorithm, int aeadAlgorithm, byte[] iv, S2K s2k, byte[] secKeyData, byte[] authTag) {
        return new SymmetricKeyEncSessionPacket(5, encAlgorithm, aeadAlgorithm, iv, s2k, secKeyData, authTag);
    }

    public static SymmetricKeyEncSessionPacket createV6Packet(int encAlgorithm, int aeadAlgorithm, byte[] iv, S2K s2k, byte[] secKeyData, byte[] authTag) {
        return new SymmetricKeyEncSessionPacket(6, encAlgorithm, aeadAlgorithm, iv, s2k, secKeyData, authTag);
    }

    public SymmetricKeyEncSessionPacket(int encAlgorithm, S2K s2k, byte[] secKeyData) {
        super(3);
        this.version = 4;
        this.encAlgorithm = encAlgorithm;
        this.s2k = s2k;
        this.secKeyData = secKeyData;
    }

    private SymmetricKeyEncSessionPacket(int version, int encAlgorithm, int aeadAlgorithm, byte[] iv, S2K s2k, byte[] secKeyData, byte[] authTag) {
        super(3);
        this.version = version;
        this.encAlgorithm = encAlgorithm;
        this.aeadAlgorithm = aeadAlgorithm;
        this.s2k = s2k;
        this.secKeyData = secKeyData;
        int expectedIVLen = AEADUtils.getIVLength(aeadAlgorithm);
        if (expectedIVLen != iv.length) {
            throw new IllegalArgumentException("Mismatched AEAD IV length. Expected " + expectedIVLen + ", got " + iv.length);
        }
        this.iv = iv;
        int expectedAuthTagLen = AEADUtils.getAuthTagLength(aeadAlgorithm);
        if (expectedAuthTagLen != authTag.length) {
            throw new IllegalArgumentException("Mismatched AEAD AuthTag length. Expected " + expectedAuthTagLen + ", got " + authTag.length);
        }
        this.authTag = authTag;
    }

    public int getEncAlgorithm() {
        return this.encAlgorithm;
    }

    public S2K getS2K() {
        return this.s2k;
    }

    public byte[] getSecKeyData() {
        return this.secKeyData;
    }

    public int getVersion() {
        return this.version;
    }

    public int getAeadAlgorithm() {
        return this.aeadAlgorithm;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public byte[] getAuthTag() {
        return this.authTag;
    }

    public byte[] getAAData() {
        return SymmetricKeyEncSessionPacket.createAAData(this.getVersion(), this.getEncAlgorithm(), this.getAeadAlgorithm());
    }

    public static byte[] createAAData(int version, int encAlgorithm, int aeadAlgorithm) {
        byte[] aaData = new byte[]{-61, (byte)(version & 0xFF), (byte)(encAlgorithm & 0xFF), (byte)(aeadAlgorithm & 0xFF)};
        return aaData;
    }

    public void encode(BCPGOutputStream out) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = this.version == 4 ? new BCPGOutputStream(bOut) : new BCPGOutputStream((OutputStream)bOut, true);
        pOut.write(this.version);
        if (this.version == 4) {
            pOut.write(this.encAlgorithm);
            pOut.writeObject(this.s2k);
            if (this.secKeyData != null && this.secKeyData.length > 0) {
                pOut.write(this.secKeyData);
            }
        } else {
            int s2kLen = 0;
            if (this.version == 6) {
                s2kLen = this.s2k.getEncoded().length;
                int count = 3 + s2kLen + this.iv.length;
                pOut.write(count);
            }
            pOut.write(this.encAlgorithm);
            pOut.write(this.aeadAlgorithm);
            if (this.version == 6) {
                pOut.write(s2kLen);
            }
            pOut.writeObject(this.s2k);
            pOut.write(this.iv);
            if (this.secKeyData != null && this.secKeyData.length > 0) {
                pOut.write(this.secKeyData);
            }
            pOut.write(this.authTag);
        }
        pOut.close();
        out.writePacket(this.hasNewPacketFormat(), 3, bOut.toByteArray());
    }
}

