/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.FingerprintUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyIdentifier {
    private final byte[] fingerprint;
    private final long keyId;

    public KeyIdentifier(String hexEncoded) {
        this(Hex.decode((String)hexEncoded));
    }

    public KeyIdentifier(byte[] fingerprint) {
        this.fingerprint = Arrays.clone((byte[])fingerprint);
        this.keyId = fingerprint.length == 20 ? FingerprintUtil.keyIdFromV4Fingerprint(fingerprint) : (fingerprint.length == 32 ? FingerprintUtil.keyIdFromV6Fingerprint(fingerprint) : 0L);
    }

    public KeyIdentifier(byte[] fingerprint, long keyId) {
        this.fingerprint = Arrays.clone((byte[])fingerprint);
        this.keyId = keyId;
    }

    public KeyIdentifier(long keyId) {
        this(null, keyId);
    }

    private KeyIdentifier() {
        this(new byte[0], 0L);
    }

    public static KeyIdentifier wildcard() {
        return new KeyIdentifier();
    }

    public byte[] getFingerprint() {
        return Arrays.clone((byte[])this.fingerprint);
    }

    public long getKeyId() {
        return this.keyId;
    }

    public boolean isWildcard() {
        return this.keyId == 0L && this.fingerprint.length == 0;
    }

    public boolean hasFingerprint(byte[] fingerprint) {
        return Arrays.constantTimeAreEqual((byte[])this.fingerprint, (byte[])fingerprint);
    }

    public boolean matches(KeyIdentifier other) {
        if (this.isWildcard() || other.isWildcard()) {
            return true;
        }
        if (this.fingerprint != null && other.fingerprint != null) {
            return Arrays.constantTimeAreEqual((byte[])this.fingerprint, (byte[])other.fingerprint);
        }
        return this.keyId == other.keyId;
    }

    public static boolean matches(List<KeyIdentifier> identifiers, KeyIdentifier identifier, boolean explicit) {
        Iterator<KeyIdentifier> it = identifiers.iterator();
        if (it.hasNext()) {
            KeyIdentifier candidate = it.next();
            if (!explicit && candidate.isWildcard()) {
                return true;
            }
            if (candidate.getFingerprint() != null && Arrays.constantTimeAreEqual((byte[])candidate.getFingerprint(), (byte[])identifier.getFingerprint())) {
                return true;
            }
            return candidate.getKeyId() == identifier.getKeyId();
        }
        return false;
    }

    public boolean isPresentIn(List<KeyIdentifier> others) {
        Iterator<KeyIdentifier> it = others.iterator();
        while (it.hasNext()) {
            if (!this.matches(it.next())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KeyIdentifier)) {
            return false;
        }
        KeyIdentifier other = (KeyIdentifier)obj;
        if (this.getFingerprint() != null && other.getFingerprint() != null) {
            return Arrays.constantTimeAreEqual((byte[])this.getFingerprint(), (byte[])other.getFingerprint());
        }
        return this.getKeyId() == other.getKeyId();
    }

    public int hashCode() {
        return (int)this.getKeyId();
    }

    public String toString() {
        if (this.isWildcard()) {
            return "*";
        }
        if (this.fingerprint == null) {
            return "" + this.keyId;
        }
        return Hex.toHexString((byte[])this.fingerprint).toUpperCase();
    }
}

