/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.jcajce.spec.HybridValueParameterSpec;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPPad;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.RFC6637Utils;
import org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.Arrays;

public class JcePublicKeyKeyEncryptionMethodGenerator
extends PublicKeyKeyEncryptionMethodGenerator {
    private static final byte X_HDR = 64;
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private SecureRandom random;
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public JcePublicKeyKeyEncryptionMethodGenerator(PGPPublicKey key) {
        super(key);
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        return this;
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        this.keyConverter.setProvider(providerName);
        return this;
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    protected byte[] encryptSessionInfo(PGPPublicKey pubKey, byte[] sessionInfo) throws PGPException {
        try {
            PublicKey cryptoPublicKey = this.keyConverter.getPublicKey(pubKey);
            if (pubKey.getAlgorithm() == 18) {
                final ECDHPublicBCPGKey ecKey = (ECDHPublicBCPGKey)pubKey.getPublicKeyPacket().getKey();
                String keyEncryptionOID = RFC6637Utils.getKeyEncryptionOID(ecKey.getSymmetricKeyAlgorithm()).getId();
                PublicKeyPacket pubKeyPacket = pubKey.getPublicKeyPacket();
                if (JcaJcePGPUtil.isX25519(ecKey.getCurveOID())) {
                    return this.getEncryptSessionInfo(pubKeyPacket, "X25519", cryptoPublicKey, keyEncryptionOID, ecKey.getSymmetricKeyAlgorithm(), sessionInfo, RFC6637Utils.getXDHAlgorithm(pubKeyPacket), new KeyPairGeneratorOperation(){

                        public void initialize(KeyPairGenerator kpGen) throws GeneralSecurityException, IOException {
                            kpGen.initialize(255, JcePublicKeyKeyEncryptionMethodGenerator.this.random);
                        }
                    }, new EphPubEncoding(){

                        public byte[] getEphPubEncoding(byte[] ephPubEncoding) {
                            return Arrays.prepend((byte[])ephPubEncoding, (byte)64);
                        }
                    });
                }
                if (ecKey.getCurveOID().equals((ASN1Primitive)EdECObjectIdentifiers.id_X448)) {
                    return this.getEncryptSessionInfo(pubKeyPacket, "X448", cryptoPublicKey, keyEncryptionOID, ecKey.getSymmetricKeyAlgorithm(), sessionInfo, RFC6637Utils.getXDHAlgorithm(pubKeyPacket), new KeyPairGeneratorOperation(){

                        public void initialize(KeyPairGenerator kpGen) throws GeneralSecurityException, IOException {
                            kpGen.initialize(448, JcePublicKeyKeyEncryptionMethodGenerator.this.random);
                        }
                    }, new EphPubEncoding(){

                        public byte[] getEphPubEncoding(byte[] ephPubEncoding) {
                            return Arrays.prepend((byte[])ephPubEncoding, (byte)64);
                        }
                    });
                }
                return this.getEncryptSessionInfo(pubKeyPacket, "EC", cryptoPublicKey, keyEncryptionOID, ecKey.getSymmetricKeyAlgorithm(), sessionInfo, RFC6637Utils.getAgreementAlgorithm(pubKeyPacket), new KeyPairGeneratorOperation(){

                    public void initialize(KeyPairGenerator kpGen) throws GeneralSecurityException, IOException {
                        AlgorithmParameters ecAlgParams = JcePublicKeyKeyEncryptionMethodGenerator.this.helper.createAlgorithmParameters("EC");
                        ecAlgParams.init(new X962Parameters(ecKey.getCurveOID()).getEncoded());
                        kpGen.initialize(ecAlgParams.getParameterSpec(AlgorithmParameterSpec.class), JcePublicKeyKeyEncryptionMethodGenerator.this.random);
                    }
                }, new EphPubEncoding(){

                    public byte[] getEphPubEncoding(byte[] ephPubEncoding) {
                        if (null == ephPubEncoding || ephPubEncoding.length < 1 || ephPubEncoding[0] != 4) {
                            ephPubEncoding = JcaJcePGPUtil.getX9Parameters(ecKey.getCurveOID()).getCurve().decodePoint(ephPubEncoding).getEncoded(false);
                        }
                        return ephPubEncoding;
                    }
                });
            }
            if (pubKey.getAlgorithm() == 25) {
                return this.getEncryptSessionInfo(pubKey, "X25519", cryptoPublicKey, NISTObjectIdentifiers.id_aes128_wrap.getId(), 7, sessionInfo, "X25519withSHA256HKDF", 255);
            }
            if (pubKey.getAlgorithm() == 26) {
                return this.getEncryptSessionInfo(pubKey, "X448", cryptoPublicKey, NISTObjectIdentifiers.id_aes256_wrap.getId(), 9, sessionInfo, "X448withSHA512HKDF", 448);
            }
            Cipher c = this.helper.createPublicKeyCipher(pubKey.getAlgorithm());
            c.init(1, (Key)cryptoPublicKey, this.random);
            return c.doFinal(sessionInfo);
        }
        catch (IllegalBlockSizeException e) {
            throw new PGPException("illegal block size: " + e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new PGPException("bad padding: " + e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new PGPException("key invalid: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PGPException("unable to encode MPI: " + e.getMessage(), e);
        }
        catch (GeneralSecurityException e) {
            throw new PGPException("unable to set up ephemeral keys: " + e.getMessage(), e);
        }
    }

    private byte[] getEncryptSessionInfo(PublicKeyPacket pubKeyPacket, String algorithmName, PublicKey cryptoPublicKey, String keyEncryptionOID, int symmetricKeyAlgorithm, byte[] sessionInfo, String agreementName, KeyPairGeneratorOperation kpOperation, EphPubEncoding getEncoding) throws GeneralSecurityException, IOException, PGPException {
        KeyPairGenerator kpGen = this.helper.createKeyPairGenerator(algorithmName);
        kpOperation.initialize(kpGen);
        KeyPair ephKP = kpGen.generateKeyPair();
        UserKeyingMaterialSpec ukmSpec = new UserKeyingMaterialSpec(RFC6637Utils.createUserKeyingMaterial(pubKeyPacket, new JcaKeyFingerprintCalculator()));
        Key secret = JcaJcePGPUtil.getSecret(this.helper, cryptoPublicKey, keyEncryptionOID, agreementName, (AlgorithmParameterSpec)ukmSpec, ephKP.getPrivate());
        byte[] ephPubEncoding = getEncoding.getEphPubEncoding(SubjectPublicKeyInfo.getInstance((Object)ephKP.getPublic().getEncoded()).getPublicKeyData().getBytes());
        byte[] paddedSessionData = PGPPad.padSessionData(sessionInfo, this.sessionKeyObfuscation);
        return JcePublicKeyKeyEncryptionMethodGenerator.getSessionInfo(ephPubEncoding, this.getWrapper(symmetricKeyAlgorithm, sessionInfo, secret, paddedSessionData));
    }

    private byte[] getEncryptSessionInfo(PGPPublicKey pgpPublicKey, String algorithmName, PublicKey cryptoPublicKey, String keyEncryptionOID, int symmetricKeyAlgorithm, byte[] sessionInfo, String agreementAlgorithmName, int keySize) throws GeneralSecurityException, IOException, PGPException {
        KeyPairGenerator kpGen = this.helper.createKeyPairGenerator(algorithmName);
        kpGen.initialize(keySize, this.random);
        KeyPair ephKP = kpGen.generateKeyPair();
        byte[] ephPubEncoding = SubjectPublicKeyInfo.getInstance((Object)ephKP.getPublic().getEncoded()).getPublicKeyData().getBytes();
        HybridValueParameterSpec ukmSpec = JcaJcePGPUtil.getHybridValueParameterSpecWithPrepend(ephPubEncoding, pgpPublicKey.getPublicKeyPacket(), algorithmName);
        Key secret = JcaJcePGPUtil.getSecret(this.helper, cryptoPublicKey, keyEncryptionOID, agreementAlgorithmName, (AlgorithmParameterSpec)ukmSpec, ephKP.getPrivate());
        byte[] sessionData = new byte[sessionInfo.length - 3];
        System.arraycopy(sessionInfo, 1, sessionData, 0, sessionData.length);
        return JcePublicKeyKeyEncryptionMethodGenerator.getSessionInfo(ephPubEncoding, sessionInfo[0], this.getWrapper(symmetricKeyAlgorithm, sessionInfo, secret, sessionData));
    }

    private byte[] getWrapper(int symmetricKeyAlgorithm, byte[] sessionInfo, Key secret, byte[] sessionData) throws PGPException, InvalidKeyException, IllegalBlockSizeException {
        Cipher c = this.helper.createKeyWrapper(symmetricKeyAlgorithm);
        c.init(3, secret, this.random);
        return c.wrap(new SecretKeySpec(sessionData, PGPUtil.getSymmetricCipherName(sessionInfo[0])));
    }

    @FunctionalInterface
    private static interface EphPubEncoding {
        public byte[] getEphPubEncoding(byte[] var1);
    }

    @FunctionalInterface
    private static interface KeyPairGeneratorOperation {
        public void initialize(KeyPairGenerator var1) throws GeneralSecurityException, IOException;
    }
}

