/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.ECSecretBCPGKey;
import org.bouncycastle.bcpg.Ed25519PublicBCPGKey;
import org.bouncycastle.bcpg.Ed25519SecretBCPGKey;
import org.bouncycastle.bcpg.Ed448PublicBCPGKey;
import org.bouncycastle.bcpg.Ed448SecretBCPGKey;
import org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import org.bouncycastle.bcpg.EdSecretBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.OctetArrayBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.bcpg.X25519PublicBCPGKey;
import org.bouncycastle.bcpg.X25519SecretBCPGKey;
import org.bouncycastle.bcpg.X448PublicBCPGKey;
import org.bouncycastle.bcpg.X448SecretBCPGKey;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECNamedDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import org.bouncycastle.crypto.params.ElGamalParameters;
import org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import org.bouncycastle.crypto.params.X448PublicKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.PGPAlgorithmParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKdfParameters;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPKeyConverter;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class BcPGPKeyConverter
extends PGPKeyConverter {
    public PGPPrivateKey getPGPPrivateKey(PGPPublicKey pubKey, AsymmetricKeyParameter privKey) throws PGPException {
        BCPGKey privPk = this.getPrivateBCPGKey(pubKey, privKey);
        return new PGPPrivateKey(pubKey.getKeyID(), pubKey.getPublicKeyPacket(), privPk);
    }

    public PGPPublicKey getPGPPublicKey(int algorithm, PGPAlgorithmParameters algorithmParameters, AsymmetricKeyParameter pubKey, Date time) throws PGPException {
        BCPGKey bcpgKey = this.getPublicBCPGKey(algorithm, algorithmParameters, pubKey);
        return new PGPPublicKey(new PublicKeyPacket(algorithm, time, bcpgKey), new BcKeyFingerprintCalculator());
    }

    public AsymmetricKeyParameter getPrivateKey(PGPPrivateKey privKey) throws PGPException {
        PublicKeyPacket pubPk = privKey.getPublicKeyPacket();
        BCPGKey privPk = privKey.getPrivateKeyDataPacket();
        try {
            switch (pubPk.getAlgorithm()) {
                case 17: {
                    DSAPublicBCPGKey dsaPub = (DSAPublicBCPGKey)pubPk.getKey();
                    DSASecretBCPGKey dsaPriv = (DSASecretBCPGKey)privPk;
                    return new DSAPrivateKeyParameters(dsaPriv.getX(), new DSAParameters(dsaPub.getP(), dsaPub.getQ(), dsaPub.getG()));
                }
                case 18: {
                    ECDHPublicBCPGKey ecdhPub = (ECDHPublicBCPGKey)pubPk.getKey();
                    if (CryptlibObjectIdentifiers.curvey25519.equals((ASN1Primitive)ecdhPub.getCurveOID())) {
                        return PrivateKeyFactory.createKey((PrivateKeyInfo)this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X25519, Arrays.reverseInPlace((byte[])BigIntegers.asUnsignedByteArray((BigInteger)((ECSecretBCPGKey)privPk).getX()))));
                    }
                    return this.implGetPrivateKeyEC(ecdhPub, (ECSecretBCPGKey)privPk);
                }
                case 25: {
                    return PrivateKeyFactory.createKey((PrivateKeyInfo)this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X25519, 32, Arrays.reverseInPlace((byte[])privPk.getEncoded())));
                }
                case 26: {
                    return PrivateKeyFactory.createKey((PrivateKeyInfo)this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X448, 56, Arrays.reverseInPlace((byte[])privPk.getEncoded())));
                }
                case 19: {
                    return this.implGetPrivateKeyEC((ECDSAPublicBCPGKey)pubPk.getKey(), (ECSecretBCPGKey)privPk);
                }
                case 22: {
                    if (((EdDSAPublicBCPGKey)pubPk.getKey()).getCurveOID().equals((ASN1Primitive)EdECObjectIdentifiers.id_Ed448)) {
                        return this.implGetPrivateKeyPKCS8(EdECObjectIdentifiers.id_Ed448, 57, privPk);
                    }
                    return this.implGetPrivateKeyPKCS8(EdECObjectIdentifiers.id_Ed25519, 32, privPk);
                }
                case 27: {
                    return PrivateKeyFactory.createKey((PrivateKeyInfo)this.getPrivateKeyInfo(EdECObjectIdentifiers.id_Ed25519, 32, privPk.getEncoded()));
                }
                case 28: {
                    return PrivateKeyFactory.createKey((PrivateKeyInfo)this.getPrivateKeyInfo(EdECObjectIdentifiers.id_Ed448, 57, privPk.getEncoded()));
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elPub = (ElGamalPublicBCPGKey)pubPk.getKey();
                    ElGamalSecretBCPGKey elPriv = (ElGamalSecretBCPGKey)privPk;
                    return new ElGamalPrivateKeyParameters(elPriv.getX(), new ElGamalParameters(elPub.getP(), elPub.getG()));
                }
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rsaPub = (RSAPublicBCPGKey)pubPk.getKey();
                    RSASecretBCPGKey rsaPriv = (RSASecretBCPGKey)privPk;
                    return new RSAPrivateCrtKeyParameters(rsaPriv.getModulus(), rsaPub.getPublicExponent(), rsaPriv.getPrivateExponent(), rsaPriv.getPrimeP(), rsaPriv.getPrimeQ(), rsaPriv.getPrimeExponentP(), rsaPriv.getPrimeExponentQ(), rsaPriv.getCrtCoefficient());
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception constructing key", e);
        }
    }

    public AsymmetricKeyParameter getPublicKey(PGPPublicKey publicKey) throws PGPException {
        PublicKeyPacket publicPk = publicKey.getPublicKeyPacket();
        try {
            switch (publicPk.getAlgorithm()) {
                case 17: {
                    DSAPublicBCPGKey dsaK = (DSAPublicBCPGKey)publicPk.getKey();
                    return new DSAPublicKeyParameters(dsaK.getY(), new DSAParameters(dsaK.getP(), dsaK.getQ(), dsaK.getG()));
                }
                case 18: {
                    ECDHPublicBCPGKey ecdhK = (ECDHPublicBCPGKey)publicPk.getKey();
                    if (ecdhK.getCurveOID().equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519)) {
                        byte[] pEnc = BigIntegers.asUnsignedByteArray((BigInteger)ecdhK.getEncodedPoint());
                        if (pEnc.length < 1 || 64 != pEnc[0]) {
                            throw new IllegalArgumentException("Invalid Curve25519 public key");
                        }
                        return this.implGetPublicKeyX509(EdECObjectIdentifiers.id_X25519, pEnc, 1);
                    }
                    return this.implGetPublicKeyEC(ecdhK);
                }
                case 25: {
                    return this.implGetPublicKeyX509((X25519PublicBCPGKey)publicPk.getKey(), EdECObjectIdentifiers.id_X25519);
                }
                case 26: {
                    return this.implGetPublicKeyX509((X448PublicBCPGKey)publicPk.getKey(), EdECObjectIdentifiers.id_X448);
                }
                case 19: {
                    return this.implGetPublicKeyEC((ECDSAPublicBCPGKey)publicPk.getKey());
                }
                case 22: {
                    EdDSAPublicBCPGKey eddsaK = (EdDSAPublicBCPGKey)publicPk.getKey();
                    byte[] pEnc = BigIntegers.asUnsignedByteArray((BigInteger)eddsaK.getEncodedPoint());
                    if (pEnc.length < 1) {
                        throw new IllegalArgumentException("Invalid EdDSA public key");
                    }
                    if (pEnc[0] == 64 && !eddsaK.getCurveOID().equals((ASN1Primitive)EdECObjectIdentifiers.id_Ed448)) {
                        return this.implGetPublicKeyX509(EdECObjectIdentifiers.id_Ed25519, pEnc, 1);
                    }
                    if (eddsaK.getCurveOID().equals((ASN1Primitive)EdECObjectIdentifiers.id_Ed448)) {
                        return this.implGetPublicKeyX509(EdECObjectIdentifiers.id_Ed448, pEnc, 0);
                    }
                    throw new IllegalArgumentException("Invalid EdDSA public key");
                }
                case 27: {
                    return this.implGetPublicKeyX509((Ed25519PublicBCPGKey)publicPk.getKey(), EdECObjectIdentifiers.id_Ed25519);
                }
                case 28: {
                    return this.implGetPublicKeyX509((Ed448PublicBCPGKey)publicPk.getKey(), EdECObjectIdentifiers.id_Ed448);
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elK = (ElGamalPublicBCPGKey)publicPk.getKey();
                    return new ElGamalPublicKeyParameters(elK.getY(), new ElGamalParameters(elK.getP(), elK.getG()));
                }
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rsaK = (RSAPublicBCPGKey)publicPk.getKey();
                    return new RSAKeyParameters(false, rsaK.getModulus(), rsaK.getPublicExponent());
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("exception constructing public key", e);
        }
    }

    private BCPGKey getPrivateBCPGKey(PGPPublicKey pubKey, AsymmetricKeyParameter privKey) throws PGPException {
        switch (pubKey.getAlgorithm()) {
            case 17: {
                DSAPrivateKeyParameters dsK = (DSAPrivateKeyParameters)privKey;
                return new DSASecretBCPGKey(dsK.getX());
            }
            case 18: {
                if (privKey instanceof X25519PrivateKeyParameters) {
                    return new ECSecretBCPGKey(new BigInteger(1, Arrays.reverseInPlace((byte[])((X25519PrivateKeyParameters)privKey).getEncoded())));
                }
                ECPrivateKeyParameters ecK = (ECPrivateKeyParameters)privKey;
                return new ECSecretBCPGKey(ecK.getD());
            }
            case 25: {
                return new X25519SecretBCPGKey(Arrays.reverseInPlace((byte[])((X25519PrivateKeyParameters)privKey).getEncoded()));
            }
            case 26: {
                return new X448SecretBCPGKey(Arrays.reverseInPlace((byte[])((X448PrivateKeyParameters)privKey).getEncoded()));
            }
            case 19: {
                ECPrivateKeyParameters ecK = (ECPrivateKeyParameters)privKey;
                return new ECSecretBCPGKey(ecK.getD());
            }
            case 22: {
                return new EdSecretBCPGKey(new BigInteger(1, ((Ed25519PrivateKeyParameters)privKey).getEncoded()));
            }
            case 27: {
                return new Ed25519SecretBCPGKey(((Ed25519PrivateKeyParameters)privKey).getEncoded());
            }
            case 28: {
                return new Ed448SecretBCPGKey(((Ed448PrivateKeyParameters)privKey).getEncoded());
            }
            case 16: 
            case 20: {
                ElGamalPrivateKeyParameters esK = (ElGamalPrivateKeyParameters)privKey;
                return new ElGamalSecretBCPGKey(esK.getX());
            }
            case 1: 
            case 2: 
            case 3: {
                RSAPrivateCrtKeyParameters rsK = (RSAPrivateCrtKeyParameters)privKey;
                return new RSASecretBCPGKey(rsK.getExponent(), rsK.getP(), rsK.getQ());
            }
        }
        throw new PGPException("unknown key class");
    }

    private BCPGKey getPublicBCPGKey(int algorithm, PGPAlgorithmParameters algorithmParameters, AsymmetricKeyParameter pubKey) throws PGPException {
        if (pubKey instanceof RSAKeyParameters) {
            RSAKeyParameters rK = (RSAKeyParameters)pubKey;
            return new RSAPublicBCPGKey(rK.getModulus(), rK.getExponent());
        }
        if (pubKey instanceof DSAPublicKeyParameters) {
            DSAPublicKeyParameters dK = (DSAPublicKeyParameters)pubKey;
            DSAParameters dP = dK.getParameters();
            return new DSAPublicBCPGKey(dP.getP(), dP.getQ(), dP.getG(), dK.getY());
        }
        if (pubKey instanceof ElGamalPublicKeyParameters) {
            ElGamalPublicKeyParameters eK = (ElGamalPublicKeyParameters)pubKey;
            ElGamalParameters eS = eK.getParameters();
            return new ElGamalPublicBCPGKey(eS.getP(), eS.getG(), eK.getY());
        }
        if (pubKey instanceof ECPublicKeyParameters) {
            ECPublicKeyParameters ecK = (ECPublicKeyParameters)pubKey;
            ECNamedDomainParameters parameters = (ECNamedDomainParameters)ecK.getParameters();
            if (algorithm == 18) {
                PGPKdfParameters kdfParams = this.implGetKdfParameters(parameters.getName(), algorithmParameters);
                return new ECDHPublicBCPGKey(parameters.getName(), ecK.getQ(), kdfParams.getHashAlgorithm(), kdfParams.getSymmetricWrapAlgorithm());
            }
            if (algorithm == 19) {
                return new ECDSAPublicBCPGKey(parameters.getName(), ecK.getQ());
            }
            throw new PGPException("unknown EC algorithm");
        }
        if (algorithm == 27) {
            byte[] pointEnc = new byte[32];
            ((Ed25519PublicKeyParameters)pubKey).encode(pointEnc, 0);
            return new Ed25519PublicBCPGKey(pointEnc);
        }
        if (pubKey instanceof Ed25519PublicKeyParameters) {
            byte[] pointEnc = new byte[33];
            pointEnc[0] = 64;
            ((Ed25519PublicKeyParameters)pubKey).encode(pointEnc, 1);
            return new EdDSAPublicBCPGKey(GNUObjectIdentifiers.Ed25519, new BigInteger(1, pointEnc));
        }
        if (pubKey instanceof Ed448PublicKeyParameters) {
            byte[] pointEnc = new byte[57];
            ((Ed448PublicKeyParameters)pubKey).encode(pointEnc, 0);
            return new Ed448PublicBCPGKey(pointEnc);
        }
        if (algorithm == 25) {
            byte[] pointEnc = new byte[32];
            ((X25519PublicKeyParameters)pubKey).encode(pointEnc, 0);
            return new X25519PublicBCPGKey(pointEnc);
        }
        if (pubKey instanceof X25519PublicKeyParameters) {
            byte[] pointEnc = new byte[33];
            pointEnc[0] = 64;
            ((X25519PublicKeyParameters)pubKey).encode(pointEnc, 1);
            PGPKdfParameters kdfParams = this.implGetKdfParameters(CryptlibObjectIdentifiers.curvey25519, algorithmParameters);
            return new ECDHPublicBCPGKey(CryptlibObjectIdentifiers.curvey25519, new BigInteger(1, pointEnc), kdfParams.getHashAlgorithm(), kdfParams.getSymmetricWrapAlgorithm());
        }
        if (pubKey instanceof X448PublicKeyParameters) {
            byte[] pointEnc = new byte[56];
            ((X448PublicKeyParameters)pubKey).encode(pointEnc, 0);
            return new X448PublicBCPGKey(pointEnc);
        }
        throw new PGPException("unknown key class");
    }

    private AsymmetricKeyParameter implGetPublicKeyX509(OctetArrayBCPGKey eddsaK, ASN1ObjectIdentifier algorithm) throws IOException {
        byte[] pEnc = Arrays.clone((byte[])eddsaK.getKey());
        return PublicKeyFactory.createKey((SubjectPublicKeyInfo)new SubjectPublicKeyInfo(new AlgorithmIdentifier(algorithm), Arrays.copyOfRange((byte[])pEnc, (int)0, (int)pEnc.length)));
    }

    private AsymmetricKeyParameter implGetPublicKeyX509(ASN1ObjectIdentifier algorithm, byte[] pEnc, int pEncOff) throws IOException {
        return PublicKeyFactory.createKey((SubjectPublicKeyInfo)new SubjectPublicKeyInfo(new AlgorithmIdentifier(algorithm), Arrays.copyOfRange((byte[])pEnc, (int)pEncOff, (int)pEnc.length)));
    }

    private ECNamedDomainParameters implGetParametersEC(ECPublicBCPGKey ecPub) {
        ASN1ObjectIdentifier curveOID = ecPub.getCurveOID();
        X9ECParameters x9 = BcUtil.getX9Parameters(curveOID);
        return new ECNamedDomainParameters(curveOID, x9.getCurve(), x9.getG(), x9.getN(), x9.getH());
    }

    private AsymmetricKeyParameter implGetPrivateKeyEC(ECPublicBCPGKey ecPub, ECSecretBCPGKey ecPriv) throws PGPException {
        ECNamedDomainParameters parameters = this.implGetParametersEC(ecPub);
        return new ECPrivateKeyParameters(ecPriv.getX(), (ECDomainParameters)parameters);
    }

    private AsymmetricKeyParameter implGetPrivateKeyPKCS8(ASN1ObjectIdentifier algorithm, int keySize, BCPGKey privPk) throws IOException {
        return PrivateKeyFactory.createKey((PrivateKeyInfo)this.getPrivateKeyInfo(algorithm, BigIntegers.asUnsignedByteArray((int)keySize, (BigInteger)((EdSecretBCPGKey)privPk).getX())));
    }

    private AsymmetricKeyParameter implGetPublicKeyEC(ECPublicBCPGKey ecPub) throws PGPException {
        ECNamedDomainParameters parameters = this.implGetParametersEC(ecPub);
        ECPoint pubPoint = BcUtil.decodePoint(ecPub.getEncodedPoint(), parameters.getCurve());
        return new ECPublicKeyParameters(pubPoint, (ECDomainParameters)parameters);
    }
}

