/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.openpgp.PGPAlgorithmParameters;
import org.bouncycastle.openpgp.PGPKdfParameters;
import org.bouncycastle.util.BigIntegers;

public abstract class PGPKeyConverter {
    protected PGPKeyConverter() {
    }

    protected PGPKdfParameters implGetKdfParameters(ASN1ObjectIdentifier curveID, PGPAlgorithmParameters algorithmParameters) {
        if (null == algorithmParameters) {
            if (curveID.equals((ASN1Primitive)SECObjectIdentifiers.secp256r1) || curveID.equals((ASN1Primitive)TeleTrusTObjectIdentifiers.brainpoolP256r1) || curveID.equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519) || curveID.equals((ASN1Primitive)EdECObjectIdentifiers.id_X25519)) {
                return new PGPKdfParameters(8, 7);
            }
            if (curveID.equals((ASN1Primitive)SECObjectIdentifiers.secp384r1) || curveID.equals((ASN1Primitive)TeleTrusTObjectIdentifiers.brainpoolP384r1)) {
                return new PGPKdfParameters(9, 8);
            }
            if (curveID.equals((ASN1Primitive)SECObjectIdentifiers.secp521r1) || curveID.equals((ASN1Primitive)TeleTrusTObjectIdentifiers.brainpoolP512r1)) {
                return new PGPKdfParameters(10, 9);
            }
            throw new IllegalArgumentException("unknown curve");
        }
        return (PGPKdfParameters)algorithmParameters;
    }

    protected PrivateKeyInfo getPrivateKeyInfo(ASN1ObjectIdentifier algorithm, int keySize, byte[] key) throws IOException {
        return new PrivateKeyInfo(new AlgorithmIdentifier(algorithm), (ASN1Encodable)new DEROctetString(BigIntegers.asUnsignedByteArray((int)keySize, (BigInteger)new BigInteger(1, key))));
    }

    protected PrivateKeyInfo getPrivateKeyInfo(ASN1ObjectIdentifier algorithm, byte[] key) throws IOException {
        return new PrivateKeyInfo(new AlgorithmIdentifier(algorithm), (ASN1Encodable)new DEROctetString(key));
    }
}

