/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UserAttributeSubpacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.operator.PGPContentVerifier;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Strings;

public class PGPSignature {
    public static final int BINARY_DOCUMENT = 0;
    public static final int CANONICAL_TEXT_DOCUMENT = 1;
    public static final int STAND_ALONE = 2;
    public static final int DEFAULT_CERTIFICATION = 16;
    public static final int NO_CERTIFICATION = 17;
    public static final int CASUAL_CERTIFICATION = 18;
    public static final int POSITIVE_CERTIFICATION = 19;
    public static final int SUBKEY_BINDING = 24;
    public static final int PRIMARYKEY_BINDING = 25;
    public static final int DIRECT_KEY = 31;
    public static final int KEY_REVOCATION = 32;
    public static final int SUBKEY_REVOCATION = 40;
    public static final int CERTIFICATION_REVOCATION = 48;
    public static final int TIMESTAMP = 64;
    public static final int THIRD_PARTY_CONFIRMATION = 80;
    private final int signatureType;
    private final SignaturePacket sigPck;
    private final TrustPacket trustPck;
    private volatile PGPContentVerifier verifier;
    private volatile byte lastb;
    private volatile OutputStream sigOut;

    private static SignaturePacket cast(Packet packet) throws IOException {
        if (!(packet instanceof SignaturePacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        return (SignaturePacket)packet;
    }

    public PGPSignature(BCPGInputStream pIn) throws IOException, PGPException {
        this(PGPSignature.cast(pIn.readPacket()));
    }

    PGPSignature(PGPSignature signature) {
        this.sigPck = signature.sigPck;
        this.signatureType = signature.signatureType;
        this.trustPck = signature.trustPck;
    }

    PGPSignature(SignaturePacket sigPacket) {
        this(sigPacket, null);
    }

    PGPSignature(SignaturePacket sigPacket, TrustPacket trustPacket) {
        this.sigPck = sigPacket;
        this.signatureType = this.sigPck.getSignatureType();
        this.trustPck = trustPacket;
    }

    public int getVersion() {
        return this.sigPck.getVersion();
    }

    public int getKeyAlgorithm() {
        return this.sigPck.getKeyAlgorithm();
    }

    public int getHashAlgorithm() {
        return this.sigPck.getHashAlgorithm();
    }

    public byte[] getDigestPrefix() {
        return this.sigPck.getFingerPrint();
    }

    public boolean isCertification() {
        return PGPSignature.isCertification(this.getSignatureType());
    }

    public void init(PGPContentVerifierBuilderProvider verifierBuilderProvider, PGPPublicKey pubKey) throws PGPException {
        PGPContentVerifierBuilder verifierBuilder = this.createVerifierProvider(verifierBuilderProvider);
        this.init(verifierBuilder.build(pubKey));
    }

    PGPContentVerifierBuilder createVerifierProvider(PGPContentVerifierBuilderProvider verifierBuilderProvider) throws PGPException {
        return verifierBuilderProvider.get(this.sigPck.getKeyAlgorithm(), this.sigPck.getHashAlgorithm());
    }

    void init(PGPContentVerifier verifier) {
        this.verifier = verifier;
        this.lastb = 0;
        this.sigOut = verifier.getOutputStream();
    }

    public void update(byte b) {
        if (this.signatureType == 1) {
            if (b == 13) {
                this.byteUpdate((byte)13);
                this.byteUpdate((byte)10);
            } else if (b == 10) {
                if (this.lastb != 13) {
                    this.byteUpdate((byte)13);
                    this.byteUpdate((byte)10);
                }
            } else {
                this.byteUpdate(b);
            }
            this.lastb = b;
        } else {
            this.byteUpdate(b);
        }
    }

    public void update(byte[] bytes) {
        this.update(bytes, 0, bytes.length);
    }

    public void update(byte[] bytes, int off, int length) {
        if (this.signatureType == 1) {
            int finish = off + length;
            for (int i = off; i != finish; ++i) {
                this.update(bytes[i]);
            }
        } else {
            this.blockUpdate(bytes, off, length);
        }
    }

    private void byteUpdate(byte b) {
        try {
            this.sigOut.write(b);
        }
        catch (IOException e) {
            throw new PGPRuntimeOperationException(e.getMessage(), e);
        }
    }

    private void blockUpdate(byte[] block, int off, int len) {
        try {
            this.sigOut.write(block, off, len);
        }
        catch (IOException e) {
            throw new PGPRuntimeOperationException(e.getMessage(), e);
        }
    }

    public boolean verify() throws PGPException {
        try {
            this.sigOut.write(this.getSignatureTrailer());
            this.sigOut.close();
        }
        catch (IOException e) {
            throw new PGPException(e.getMessage(), e);
        }
        return this.verifier.verify(this.getSignature());
    }

    private void updateWithIdData(int header, byte[] idBytes) {
        this.update((byte)header);
        this.update((byte)(idBytes.length >> 24));
        this.update((byte)(idBytes.length >> 16));
        this.update((byte)(idBytes.length >> 8));
        this.update((byte)idBytes.length);
        this.update(idBytes);
    }

    private void updateWithPublicKey(PGPPublicKey key) throws PGPException {
        byte[] keyBytes = this.getEncodedPublicKey(key);
        this.update((byte)-103);
        this.update((byte)(keyBytes.length >> 8));
        this.update((byte)keyBytes.length);
        this.update(keyBytes);
    }

    public boolean verifyCertification(PGPUserAttributeSubpacketVector userAttributes, PGPPublicKey key) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        if (!PGPSignature.isCertification(this.signatureType) && 48 != this.signatureType) {
            throw new PGPException("signature is neither a certification signature nor a certification revocation.");
        }
        return this.doVerifyCertification(userAttributes, key);
    }

    boolean doVerifyCertification(PGPUserAttributeSubpacketVector userAttributes, PGPPublicKey key) throws PGPException {
        this.updateWithPublicKey(key);
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            UserAttributeSubpacket[] packets = userAttributes.toSubpacketArray();
            for (int i = 0; i != packets.length; ++i) {
                packets[i].encode(bOut);
            }
            this.updateWithIdData(209, bOut.toByteArray());
        }
        catch (IOException e) {
            throw new PGPException("cannot encode subpacket array", e);
        }
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    public boolean verifyCertification(String id, PGPPublicKey key) throws PGPException {
        return this.verifyCertification(Strings.toUTF8ByteArray((String)id), key);
    }

    public boolean verifyCertification(byte[] rawID, PGPPublicKey key) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        if (!PGPSignature.isCertification(this.signatureType) && 48 != this.signatureType) {
            throw new PGPException("signature is neither a certification signature nor a certification revocation.");
        }
        return this.doVerifyCertification(rawID, key);
    }

    boolean doVerifyCertification(byte[] rawID, PGPPublicKey key) throws PGPException {
        this.updateWithPublicKey(key);
        this.updateWithIdData(180, rawID);
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    public boolean verifyCertification(PGPPublicKey masterKey, PGPPublicKey pubKey) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        if (24 != this.signatureType && 25 != this.signatureType && 40 != this.signatureType) {
            throw new PGPException("signature is not a key binding signature.");
        }
        return this.doVerifyCertification(masterKey, pubKey);
    }

    boolean doVerifyCertification(PGPPublicKey masterKey, PGPPublicKey pubKey) throws PGPException {
        this.updateWithPublicKey(masterKey);
        this.updateWithPublicKey(pubKey);
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    private void addTrailer() {
        try {
            this.sigOut.write(this.sigPck.getSignatureTrailer());
            this.sigOut.close();
        }
        catch (IOException e) {
            throw new PGPRuntimeOperationException(e.getMessage(), e);
        }
    }

    public boolean verifyCertification(PGPPublicKey pubKey) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        if (this.getSignatureType() != 32 && this.getSignatureType() != 31) {
            throw new PGPException("signature is not a key signature");
        }
        return this.doVerifyCertification(pubKey);
    }

    boolean doVerifyCertification(PGPPublicKey pubKey) throws PGPException {
        this.updateWithPublicKey(pubKey);
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    public int getSignatureType() {
        return this.sigPck.getSignatureType();
    }

    public long getKeyID() {
        return this.sigPck.getKeyID();
    }

    public Date getCreationTime() {
        return new Date(this.sigPck.getCreationTime());
    }

    public byte[] getSignatureTrailer() {
        return this.sigPck.getSignatureTrailer();
    }

    public boolean hasSubpackets() {
        return this.sigPck.getHashedSubPackets() != null || this.sigPck.getUnhashedSubPackets() != null;
    }

    public PGPSignatureSubpacketVector getHashedSubPackets() {
        return this.createSubpacketVector(this.sigPck.getHashedSubPackets());
    }

    public PGPSignatureSubpacketVector getUnhashedSubPackets() {
        return this.createSubpacketVector(this.sigPck.getUnhashedSubPackets());
    }

    private PGPSignatureSubpacketVector createSubpacketVector(SignatureSubpacket[] pcks) {
        if (pcks != null) {
            return new PGPSignatureSubpacketVector(pcks);
        }
        return null;
    }

    public byte[] getSignature() throws PGPException {
        byte[] signature;
        MPInteger[] sigValues = this.sigPck.getSignature();
        if (sigValues != null) {
            if (sigValues.length == 1) {
                signature = BigIntegers.asUnsignedByteArray((BigInteger)sigValues[0].getValue());
            } else if (this.getKeyAlgorithm() == 22) {
                signature = new byte[64];
                byte[] a = BigIntegers.asUnsignedByteArray((BigInteger)sigValues[0].getValue());
                byte[] b = BigIntegers.asUnsignedByteArray((BigInteger)sigValues[1].getValue());
                System.arraycopy(a, 0, signature, 32 - a.length, a.length);
                System.arraycopy(b, 0, signature, 64 - b.length, b.length);
            } else {
                try {
                    ASN1EncodableVector v = new ASN1EncodableVector();
                    v.add((ASN1Encodable)new ASN1Integer(sigValues[0].getValue()));
                    v.add((ASN1Encodable)new ASN1Integer(sigValues[1].getValue()));
                    signature = new DERSequence(v).getEncoded();
                }
                catch (IOException e) {
                    throw new PGPException("exception encoding DSA sig.", e);
                }
            }
        } else {
            signature = this.sigPck.getSignatureBytes();
        }
        return signature;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public byte[] getEncoded(boolean forTransfer) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut, forTransfer);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        this.encode(outStream, false);
    }

    public void encode(OutputStream outStream, boolean forTransfer) throws IOException {
        if (!(!forTransfer || this.getHashedSubPackets().isExportable() && this.getUnhashedSubPackets().isExportable())) {
            return;
        }
        BCPGOutputStream out = BCPGOutputStream.wrap(outStream);
        out.writePacket(this.sigPck);
        if (!forTransfer && this.trustPck != null) {
            out.writePacket(this.trustPck);
        }
    }

    private byte[] getEncodedPublicKey(PGPPublicKey pubKey) throws PGPException {
        byte[] keyBytes;
        try {
            keyBytes = pubKey.publicPk.getEncodedContents();
        }
        catch (IOException e) {
            throw new PGPException("exception preparing key.", e);
        }
        return keyBytes;
    }

    public static boolean isCertification(int signatureType) {
        return 16 == signatureType || 17 == signatureType || 18 == signatureType || 19 == signatureType;
    }

    public static boolean isSignatureEncodingEqual(PGPSignature sig1, PGPSignature sig2) {
        return Arrays.areEqual((byte[])sig1.sigPck.getSignatureBytes(), (byte[])sig2.sigPck.getSignatureBytes());
    }

    public static PGPSignature join(PGPSignature sig1, PGPSignature sig2) throws PGPException {
        if (!PGPSignature.isSignatureEncodingEqual(sig1, sig2)) {
            throw new IllegalArgumentException("These are different signatures.");
        }
        SignatureSubpacket[] sig1Unhashed = sig1.getUnhashedSubPackets().packets;
        SignatureSubpacket[] sig2Unhashed = sig2.getUnhashedSubPackets().packets;
        ArrayList<SignatureSubpacket> merged = new ArrayList<SignatureSubpacket>(java.util.Arrays.asList(sig1Unhashed));
        for (int i = 0; i != sig2Unhashed.length; ++i) {
            SignatureSubpacket subpacket = sig2Unhashed[i];
            boolean found = false;
            for (int j = 0; j != sig1Unhashed.length; ++j) {
                SignatureSubpacket existing = sig1Unhashed[j];
                if (!subpacket.equals(existing)) continue;
                found = true;
                break;
            }
            if (found) continue;
            merged.add(subpacket);
        }
        SignatureSubpacket[] unhashed = merged.toArray(new SignatureSubpacket[0]);
        return new PGPSignature(new SignaturePacket(sig1.getSignatureType(), sig1.getKeyID(), sig1.getKeyAlgorithm(), sig1.getHashAlgorithm(), sig1.getHashedSubPackets().packets, unhashed, sig1.getDigestPrefix(), sig1.sigPck.getSignature()));
    }
}

