/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.security.SecureRandom;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPUtil;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.util.Arrays;

public abstract class PBEKeyEncryptionMethodGenerator
extends PGPKeyEncryptionMethodGenerator {
    private char[] passPhrase;
    private PGPDigestCalculator s2kDigestCalculator;
    private S2K s2k;
    private SecureRandom random;
    private int s2kCount;
    private int wrapAlg = -1;

    protected PBEKeyEncryptionMethodGenerator(char[] passPhrase, PGPDigestCalculator s2kDigestCalculator) {
        this(passPhrase, s2kDigestCalculator, 96);
    }

    protected PBEKeyEncryptionMethodGenerator(char[] passPhrase, S2K.Argon2Params params) {
        this.passPhrase = passPhrase;
        this.s2k = new S2K(params);
    }

    protected PBEKeyEncryptionMethodGenerator(char[] passPhrase, PGPDigestCalculator s2kDigestCalculator, int s2kCount) {
        this.passPhrase = passPhrase;
        this.s2kDigestCalculator = s2kDigestCalculator;
        if (s2kCount < 0 || s2kCount > 255) {
            throw new IllegalArgumentException("s2kCount value outside of range 0 to 255.");
        }
        this.s2kCount = s2kCount;
    }

    public PBEKeyEncryptionMethodGenerator setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public PBEKeyEncryptionMethodGenerator setSessionKeyWrapperAlgorithm(int wrapAlg) {
        this.wrapAlg = wrapAlg;
        return this;
    }

    public int getSessionKeyWrapperAlgorithm(int defaultWrapAlg) {
        if (this.wrapAlg < 0) {
            return defaultWrapAlg;
        }
        return this.wrapAlg;
    }

    public byte[] getKey(int encAlgorithm) throws PGPException {
        if (this.s2k == null) {
            byte[] iv = new byte[8];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            this.s2k = new S2K(this.s2kDigestCalculator.getAlgorithm(), iv, this.s2kCount);
        }
        return PGPUtil.makeKeyFromPassPhrase(this.s2kDigestCalculator, encAlgorithm, this.s2k, this.passPhrase);
    }

    public ContainedPacket generateV5(int kekAlgorithm, int aeadAlgorithm, byte[] sessionInfo) throws PGPException {
        return this.generate(kekAlgorithm, sessionInfo);
    }

    public ContainedPacket generateV6(int kekAlgorithm, int aeadAlgorithm, byte[] sessionInfo) throws PGPException {
        return this.generateV6ESK(kekAlgorithm, aeadAlgorithm, sessionInfo);
    }

    private ContainedPacket generateV5ESK(int kekAlgorithm, int aeadAlgorithm, byte[] sessionInfo) throws PGPException {
        byte[] ikm = this.getKey(kekAlgorithm);
        byte[] info = new byte[]{-61, 5, (byte)kekAlgorithm, (byte)aeadAlgorithm};
        byte[] sessionKey = new byte[sessionInfo.length - 3];
        System.arraycopy(sessionInfo, 1, sessionKey, 0, sessionKey.length);
        byte[] iv = new byte[AEADUtils.getIVLength(aeadAlgorithm)];
        this.random.nextBytes(iv);
        AEADBlockCipher aeadCipher = BcAEADUtil.createAEADCipher(kekAlgorithm, aeadAlgorithm);
        aeadCipher.init(true, (CipherParameters)new AEADParameters(new KeyParameter(ikm), 128, iv, info));
        int tagLen = AEADUtils.getAuthTagLength(aeadAlgorithm);
        int outLen = aeadCipher.getOutputSize(sessionKey.length);
        byte[] eskAndTag = new byte[outLen];
        int len = aeadCipher.processBytes(sessionKey, 0, sessionKey.length, eskAndTag, 0);
        try {
            len += aeadCipher.doFinal(eskAndTag, len);
        }
        catch (InvalidCipherTextException e) {
            throw new PGPException("cannot encrypt session info", (Exception)((Object)e));
        }
        byte[] esk = Arrays.copyOfRange((byte[])eskAndTag, (int)0, (int)(eskAndTag.length - tagLen));
        byte[] tag = Arrays.copyOfRange((byte[])eskAndTag, (int)esk.length, (int)eskAndTag.length);
        return SymmetricKeyEncSessionPacket.createV5Packet(kekAlgorithm, aeadAlgorithm, iv, this.s2k, esk, tag);
    }

    private ContainedPacket generateV6ESK(int kekAlgorithm, int aeadAlgorithm, byte[] sessionInfo) throws PGPException {
        byte[] ikm = this.getKey(kekAlgorithm);
        byte[] info = new byte[]{-61, 6, (byte)kekAlgorithm, (byte)aeadAlgorithm};
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator((Digest)new SHA256Digest());
        hkdf.init((DerivationParameters)new HKDFParameters(ikm, null, info));
        int kekLen = SymmetricKeyUtils.getKeyLengthInOctets(kekAlgorithm);
        byte[] kek = new byte[kekLen];
        hkdf.generateBytes(kek, 0, kek.length);
        byte[] sessionKey = new byte[sessionInfo.length - 3];
        System.arraycopy(sessionInfo, 1, sessionKey, 0, sessionKey.length);
        byte[] iv = new byte[AEADUtils.getIVLength(aeadAlgorithm)];
        this.random.nextBytes(iv);
        AEADBlockCipher aeadCipher = BcAEADUtil.createAEADCipher(kekAlgorithm, aeadAlgorithm);
        aeadCipher.init(true, (CipherParameters)new AEADParameters(new KeyParameter(kek), 128, iv, info));
        int tagLen = AEADUtils.getAuthTagLength(aeadAlgorithm);
        int outLen = aeadCipher.getOutputSize(sessionKey.length);
        byte[] eskAndTag = new byte[outLen];
        int len = aeadCipher.processBytes(sessionKey, 0, sessionKey.length, eskAndTag, 0);
        try {
            len += aeadCipher.doFinal(eskAndTag, len);
        }
        catch (InvalidCipherTextException e) {
            throw new PGPException("cannot encrypt session info", (Exception)((Object)e));
        }
        byte[] esk = Arrays.copyOfRange((byte[])eskAndTag, (int)0, (int)(eskAndTag.length - tagLen));
        byte[] tag = Arrays.copyOfRange((byte[])eskAndTag, (int)esk.length, (int)eskAndTag.length);
        return SymmetricKeyEncSessionPacket.createV6Packet(kekAlgorithm, aeadAlgorithm, iv, this.s2k, esk, tag);
    }

    public ContainedPacket generate(int encAlgorithm, byte[] sessionInfo) throws PGPException {
        if (sessionInfo == null) {
            return SymmetricKeyEncSessionPacket.createV4Packet(encAlgorithm, this.s2k, null);
        }
        byte[] key = this.getKey(encAlgorithm);
        byte[] nSessionInfo = new byte[sessionInfo.length - 2];
        System.arraycopy(sessionInfo, 0, nSessionInfo, 0, nSessionInfo.length);
        return SymmetricKeyEncSessionPacket.createV4Packet(encAlgorithm, this.s2k, this.encryptSessionInfo(encAlgorithm, key, nSessionInfo));
    }

    protected abstract byte[] encryptSessionInfo(int var1, byte[] var2, byte[] var3) throws PGPException;
}

