/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.HashAlgorithmTags;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.DecoderException;

public class PGPUtil
implements HashAlgorithmTags {
    private static String defProvider = "BC";
    private static Map nameToHashId = new HashMap(){
        {
            this.put("sha1", Integers.valueOf((int)2));
            this.put("sha224", Integers.valueOf((int)11));
            this.put("sha256", Integers.valueOf((int)8));
            this.put("sha384", Integers.valueOf((int)9));
            this.put("sha512", Integers.valueOf((int)10));
            this.put("sha3-224", Integers.valueOf((int)312));
            this.put("sha3-256", Integers.valueOf((int)12));
            this.put("sha3-384", Integers.valueOf((int)314));
            this.put("sha3-512", Integers.valueOf((int)14));
            this.put("ripemd160", Integers.valueOf((int)3));
            this.put("rmd160", Integers.valueOf((int)3));
            this.put("md2", Integers.valueOf((int)5));
            this.put("md4", Integers.valueOf((int)301));
            this.put("tiger", Integers.valueOf((int)6));
            this.put("haval", Integers.valueOf((int)7));
            this.put("sm3", Integers.valueOf((int)326));
            this.put("md5", Integers.valueOf((int)1));
        }
    };
    private static Map oidToName = new HashMap(){
        {
            this.put(CryptlibObjectIdentifiers.curvey25519, "Curve25519");
            this.put(GNUObjectIdentifiers.Ed25519, "Ed25519Legacy");
            this.put(EdECObjectIdentifiers.id_X25519, "Curve25519");
            this.put(EdECObjectIdentifiers.id_Ed25519, "Ed25519");
            this.put(SECObjectIdentifiers.secp256r1, "NIST P-256");
            this.put(SECObjectIdentifiers.secp384r1, "NIST P-384");
            this.put(SECObjectIdentifiers.secp521r1, "NIST P-521");
            this.put(TeleTrusTObjectIdentifiers.brainpoolP256r1, "brainpoolP256r1");
            this.put(TeleTrusTObjectIdentifiers.brainpoolP384r1, "brainpoolP384r1");
            this.put(TeleTrusTObjectIdentifiers.brainpoolP512r1, "brainpoolP512r1");
        }
    };
    private static final int READ_AHEAD = 60;

    public static String getDigestName(int hashAlgorithm) throws PGPException {
        switch (hashAlgorithm) {
            case 2: {
                return "SHA1";
            }
            case 5: {
                return "MD2";
            }
            case 1: {
                return "MD5";
            }
            case 3: {
                return "RIPEMD160";
            }
            case 8: {
                return "SHA256";
            }
            case 9: {
                return "SHA384";
            }
            case 10: {
                return "SHA512";
            }
            case 11: {
                return "SHA224";
            }
            case 12: 
            case 313: {
                return "SHA3-256";
            }
            case 314: {
                return "SHA3-384";
            }
            case 14: 
            case 315: {
                return "SHA3-512";
            }
            case 312: {
                return "SHA3-224";
            }
            case 6: {
                return "TIGER";
            }
        }
        throw new PGPException("unknown hash algorithm tag in getDigestName: " + hashAlgorithm);
    }

    public static int getDigestIDForName(String name) {
        if (nameToHashId.containsKey(name = Strings.toLowerCase((String)name))) {
            return (Integer)nameToHashId.get(name);
        }
        throw new IllegalArgumentException("unable to map " + name + " to a hash id");
    }

    public static String getCurveName(ASN1ObjectIdentifier oid) {
        String name = (String)oidToName.get(oid);
        if (name != null) {
            return name;
        }
        return ECNamedCurveTable.getName((ASN1ObjectIdentifier)oid);
    }

    /*
     * WARNING - void declaration
     */
    public static String getSignatureName(int keyAlgorithm, int hashAlgorithm) throws PGPException {
        void var2_2;
        switch (keyAlgorithm) {
            case 1: 
            case 3: {
                String encAlg = "RSA";
                break;
            }
            case 17: {
                String encAlg = "DSA";
                break;
            }
            case 16: 
            case 20: {
                String encAlg = "ElGamal";
                break;
            }
            default: {
                throw new PGPException("unknown algorithm tag in signature:" + keyAlgorithm);
            }
        }
        return PGPUtil.getDigestName(hashAlgorithm) + "with" + (String)var2_2;
    }

    public static String getSymmetricCipherName(int algorithm) {
        switch (algorithm) {
            case 0: {
                return null;
            }
            case 2: {
                return "DESEDE";
            }
            case 1: {
                return "IDEA";
            }
            case 3: {
                return "CAST5";
            }
            case 4: {
                return "Blowfish";
            }
            case 5: {
                return "SAFER";
            }
            case 6: {
                return "DES";
            }
            case 7: 
            case 8: 
            case 9: {
                return "AES";
            }
            case 11: 
            case 12: 
            case 13: {
                return "Camellia";
            }
            case 10: {
                return "Twofish";
            }
        }
        throw new IllegalArgumentException("unknown symmetric algorithm: " + algorithm);
    }

    public static String getDefaultProvider() {
        return defProvider;
    }

    public static void setDefaultProvider(String provider) {
        defProvider = provider;
    }

    static MPInteger[] dsaSigToMpi(byte[] encoding) throws PGPException {
        ASN1Integer i2;
        ASN1Integer i1;
        try {
            ASN1Sequence s = ASN1Sequence.getInstance((Object)encoding);
            i1 = ASN1Integer.getInstance((Object)s.getObjectAt(0));
            i2 = ASN1Integer.getInstance((Object)s.getObjectAt(1));
        }
        catch (RuntimeException e) {
            throw new PGPException("exception decoding signature", e);
        }
        return new MPInteger[]{new MPInteger(i1.getValue()), new MPInteger(i2.getValue())};
    }

    public static boolean isKeyRing(byte[] blob) throws IOException {
        BCPGInputStream bIn = new BCPGInputStream(new ByteArrayInputStream(blob));
        int tag = bIn.nextPacketTag();
        return tag == 6 || tag == 14 || tag == 5 || tag == 7;
    }

    public static boolean isKeyBox(byte[] data) throws IOException {
        if (data.length < 12) {
            return false;
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(data);
        for (int i = 0; i != 8; ++i) {
            ((InputStream)bIn).read();
        }
        return ((InputStream)bIn).read() == 75 && ((InputStream)bIn).read() == 66 && ((InputStream)bIn).read() == 88 && ((InputStream)bIn).read() == 102;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] makeRandomKey(int algorithm, SecureRandom random) throws PGPException {
        void var2_2;
        switch (algorithm) {
            case 2: 
            case 8: 
            case 12: {
                int keySize = 192;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: {
                int keySize = 128;
                break;
            }
            case 6: {
                int keySize = 64;
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                int keySize = 256;
                break;
            }
            default: {
                throw new PGPException("unknown symmetric algorithm: " + algorithm);
            }
        }
        byte[] keyBytes = new byte[(var2_2 + 7) / 8];
        random.nextBytes(keyBytes);
        return keyBytes;
    }

    public static void writeFileToLiteralData(OutputStream out, char fileType, File file) throws IOException {
        PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
        OutputStream pOut = lData.open(out, fileType, file);
        PGPUtil.pipeFileContents(file, pOut, 32768);
    }

    public static void writeFileToLiteralData(OutputStream out, char fileType, File file, byte[] buffer) throws IOException {
        PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
        OutputStream pOut = lData.open(out, fileType, file.getName(), new Date(file.lastModified()), buffer);
        PGPUtil.pipeFileContents(file, pOut, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void pipeFileContents(File file, OutputStream pOut, int bufferSize) throws IOException {
        byte[] buf = new byte[bufferSize];
        FileInputStream in = new FileInputStream(file);
        try {
            int len;
            while ((len = in.read(buf)) > 0) {
                pOut.write(buf, 0, len);
            }
            pOut.close();
        }
        finally {
            Arrays.fill((byte[])buf, (byte)0);
            try {
                in.close();
            }
            catch (IOException ignored) {}
        }
    }

    private static boolean isPossiblyBase64(int ch) {
        return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57 || ch == 43 || ch == 47 || ch == 13 || ch == 10;
    }

    public static InputStream getDecoderStream(InputStream in) throws IOException {
        if (!in.markSupported()) {
            in = new BufferedInputStreamExt(in);
        }
        in.mark(60);
        int ch = in.read();
        if ((ch & 0x80) != 0) {
            in.reset();
            return in;
        }
        if (!PGPUtil.isPossiblyBase64(ch)) {
            in.reset();
            return new ArmoredInputStream(in);
        }
        byte[] buf = new byte[60];
        int index = 1;
        buf[0] = (byte)ch;
        for (int count = 1; count != 60 && (ch = in.read()) >= 0; ++count) {
            if (!PGPUtil.isPossiblyBase64(ch)) {
                in.reset();
                return new ArmoredInputStream(in);
            }
            if (ch == 10 || ch == 13) continue;
            buf[index++] = (byte)ch;
        }
        in.reset();
        if (index < 4) {
            return new ArmoredInputStream(in);
        }
        byte[] firstBlock = new byte[8];
        System.arraycopy(buf, 0, firstBlock, 0, firstBlock.length);
        try {
            byte[] decoded = Base64.decode((byte[])firstBlock);
            if ((decoded[0] & 0x80) != 0) {
                return new ArmoredInputStream(in, false);
            }
            return new ArmoredInputStream(in);
        }
        catch (DecoderException e) {
            throw new IOException(e.getMessage());
        }
    }

    static class BufferedInputStreamExt
    extends BufferedInputStream {
        BufferedInputStreamExt(InputStream input) {
            super(input);
        }

        public synchronized int available() throws IOException {
            int result = super.available();
            if (result < 0) {
                result = Integer.MAX_VALUE;
            }
            return result;
        }
    }
}

