/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg.sig;

import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.sig.Utils;

public class SignatureExpirationTime
extends SignatureSubpacket {
    protected static byte[] timeToBytes(long t) {
        return Utils.timeToBytes(t);
    }

    public SignatureExpirationTime(boolean critical, boolean isLongLength, byte[] data) {
        super(3, critical, isLongLength, SignatureExpirationTime.verifyData(data));
    }

    public SignatureExpirationTime(boolean critical, long seconds) {
        super(3, critical, false, Utils.timeToBytes(seconds));
    }

    private static byte[] verifyData(byte[] data) {
        if (data.length != 4) {
            throw new IllegalArgumentException("Malformed data length. Expected 4, got " + data.length);
        }
        return data;
    }

    public long getTime() {
        return Utils.timeFromBytes(this.data);
    }
}

