/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import org.bouncycastle.bcpg.MalformedPacketException;
import org.bouncycastle.bcpg.PacketTags;

public class Packet
implements PacketTags {
    private final int packetTag;
    private final boolean newPacketFormat;

    public Packet() {
        this(0);
    }

    Packet(int packetTag) {
        this(packetTag, false);
    }

    Packet(int packetTag, boolean newPacketFormat) {
        this.packetTag = packetTag;
        this.newPacketFormat = newPacketFormat;
    }

    public final int getPacketTag() {
        return this.packetTag;
    }

    public boolean hasNewPacketFormat() {
        return this.newPacketFormat;
    }

    public boolean isCritical() {
        return this.getPacketTag() <= 39;
    }

    static int sanitizeLength(int len, int max, String variableName) throws MalformedPacketException {
        if (len < 0) {
            throw new MalformedPacketException(variableName + " cannot be negative.");
        }
        if (len > max) {
            throw new MalformedPacketException(variableName + " (" + len + ") exceeds limit (" + max + ").");
        }
        return len;
    }
}

