/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.examples.PGPExampleUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;

public class DetachedSignatureProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifySignature(String fileName, String inputFileName, String keyFileName) throws GeneralSecurityException, IOException, PGPException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFileName));
        BufferedInputStream keyIn = new BufferedInputStream(new FileInputStream(keyFileName));
        try {
            DetachedSignatureProcessor.verifySignature(fileName, in, keyIn);
        }
        finally {
            ((InputStream)keyIn).close();
            ((InputStream)in).close();
        }
    }

    private static void verifySignature(String fileName, InputStream in, InputStream keyIn) throws GeneralSecurityException, IOException, PGPException {
        int ch;
        PGPSignatureList p3;
        JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(in = PGPUtil.getDecoderStream(in));
        Object o = pgpFact.nextObject();
        if (o instanceof PGPCompressedData) {
            PGPCompressedData c1 = (PGPCompressedData)o;
            pgpFact = new JcaPGPObjectFactory(c1.getDataStream());
            p3 = (PGPSignatureList)pgpFact.nextObject();
        } else {
            p3 = (PGPSignatureList)o;
        }
        PGPPublicKeyRingCollection pgpPubRingCollection = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream(keyIn), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        BufferedInputStream dIn = new BufferedInputStream(new FileInputStream(fileName));
        PGPSignature sig = p3.get(0);
        PGPPublicKey key = pgpPubRingCollection.getPublicKey(sig.getKeyID());
        sig.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), key);
        while ((ch = ((InputStream)dIn).read()) >= 0) {
            sig.update((byte)ch);
        }
        ((InputStream)dIn).close();
        if (sig.verify()) {
            System.out.println("signature verified.");
        } else {
            System.out.println("signature verification failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createSignature(String inputFileName, String keyFileName, String outputFileName, char[] pass, boolean armor) throws GeneralSecurityException, IOException, PGPException {
        BufferedInputStream keyIn = new BufferedInputStream(new FileInputStream(keyFileName));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFileName));
        try {
            DetachedSignatureProcessor.createSignature(inputFileName, keyIn, out, pass, armor);
        }
        finally {
            ((OutputStream)out).close();
            ((InputStream)keyIn).close();
        }
    }

    private static void createSignature(String fileName, InputStream keyIn, OutputStream out, char[] pass, boolean armor) throws GeneralSecurityException, IOException, PGPException {
        int ch;
        if (armor) {
            out = new ArmoredOutputStream(out);
        }
        PGPSecretKey pgpSec = PGPExampleUtil.readSecretKey(keyIn);
        PGPPrivateKey pgpPrivKey = pgpSec.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(pass));
        PGPSignatureGenerator sGen = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(pgpSec.getPublicKey().getAlgorithm(), 2).setProvider("BC"));
        sGen.init(0, pgpPrivKey);
        BCPGOutputStream bOut = new BCPGOutputStream(out);
        BufferedInputStream fIn = new BufferedInputStream(new FileInputStream(fileName));
        while ((ch = ((InputStream)fIn).read()) >= 0) {
            sGen.update((byte)ch);
        }
        ((InputStream)fIn).close();
        sGen.generate().encode(bOut);
        if (armor) {
            out.close();
        }
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (args[0].equals("-s")) {
            if (args[1].equals("-a")) {
                DetachedSignatureProcessor.createSignature(args[2], args[3], args[2] + ".asc", args[4].toCharArray(), true);
            } else {
                DetachedSignatureProcessor.createSignature(args[1], args[2], args[1] + ".bpg", args[3].toCharArray(), false);
            }
        } else if (args[0].equals("-v")) {
            DetachedSignatureProcessor.verifySignature(args[1], args[2], args[3]);
        } else {
            System.err.println("usage: DetachedSignatureProcessor [-s [-a] file keyfile passPhrase]|[-v file sigFile keyFile]");
        }
    }
}

